/*
 * Decompiled with CFR 0.152.
 */
package top.offsetmonkey538.lanwhitelist.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_11871;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3337;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.offsetmonkey538.lanwhitelist.LANWhitelist;
import top.offsetmonkey538.lanwhitelist.LANWhitelistClient;
import top.offsetmonkey538.lanwhitelist.config.WhitelistEnabled;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_3324.class})
public abstract class PlayerManagerMixin {
    @Shadow
    public abstract MinecraftServer method_14561();

    @Mutable
    @Final
    @Accessor(value="whitelist")
    protected abstract void setWhitelist(class_3337 var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void lan_whitelist$storeSingleplayerWhitelistInWorldFolder(CallbackInfo ci) {
        class_3324 thiz = (class_3324)this;
        MinecraftServer minecraftServer = thiz.method_14561();
        if (!(minecraftServer instanceof class_1132)) {
            LANWhitelist.logServer();
            return;
        }
        class_1132 server = (class_1132)minecraftServer;
        Path savePath = server.method_27050(class_5218.field_24188).resolve("lan-whitelist").resolve(thiz.method_14590().method_14643().getName());
        try {
            Files.createDirectories(savePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LANWhitelist.LOGGER.error("Failed to create parent directories for whitelist file! Whitelist will fail to save.", (Throwable)e);
        }
        this.setWhitelist(new class_3337(savePath.toFile(), (class_11871)server.method_74055()));
    }

    @Inject(method={"reloadWhitelist"}, at={@At(value="TAIL")})
    private void lan_whitelist$reloadWhitelistEvenOnIntegratedServer(CallbackInfo ci) {
        class_3324 thiz = (class_3324)this;
        if (!(thiz.method_14561() instanceof class_1132)) {
            LANWhitelist.logServer();
            return;
        }
        try {
            thiz.method_14590().method_14630();
        }
        catch (IOException e) {
            LANWhitelist.LOGGER.warn("Failed to load white-list: ", (Throwable)e);
        }
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="RETURN")})
    private void lan_whitelist$notifyHostOfWhitelistStatus(CallbackInfo ci, @Local(argsOnly=true) class_3222 player) {
        MinecraftServer minecraftServer = this.method_14561();
        if (!(minecraftServer instanceof class_1132)) {
            LANWhitelist.logServer();
            return;
        }
        class_1132 integratedServer = (class_1132)minecraftServer;
        if (!integratedServer.method_19466(player.method_72498())) {
            return;
        }
        LANWhitelistClient.sendEnabledMessageToHost(integratedServer, WhitelistEnabled.isWhitelistEnabled(integratedServer));
    }
}

