/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.geysermc.api.Geyser;
import org.geysermc.floodgate.api.FloodgateApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import ru.turbovadim.OriginsReforged;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u000b\"\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dJ\u000e\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lru/turbovadim/ShortcutUtils;", "", "<init>", "()V", "colorCodeRegex", "Lkotlin/text/Regex;", "giveItemWithDrops", "", "player", "Lorg/bukkit/entity/Player;", "itemStacks", "", "Lorg/bukkit/inventory/ItemStack;", "(Lorg/bukkit/entity/Player;[Lorg/bukkit/inventory/ItemStack;)V", "getLivingDamageSource", "Lorg/bukkit/entity/LivingEntity;", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "openJSONFile", "Lorg/json/JSONObject;", "file", "Ljava/io/File;", "isBedrockPlayer", "", "uuid", "Ljava/util/UUID;", "getColored", "Lnet/kyori/adventure/text/Component;", "text", "", "substringsBetween", "", "s", "start", "end", "isInfinite", "effect", "Lorg/bukkit/potion/PotionEffect;", "infiniteDuration", "", "core"})
@SourceDebugExtension(value={"SMAP\nShortcutUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutUtils.kt\nru/turbovadim/ShortcutUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n37#2,2:104\n1869#3,2:106\n774#3:108\n865#3,2:109\n1878#3,3:111\n*S KotlinDebug\n*F\n+ 1 ShortcutUtils.kt\nru/turbovadim/ShortcutUtils\n*L\n26#1:104,2\n27#1:106,2\n67#1:108\n67#1:109,2\n69#1:111,3\n*E\n"})
public final class ShortcutUtils {
    @NotNull
    public static final ShortcutUtils INSTANCE = new ShortcutUtils();
    @NotNull
    private static final Regex colorCodeRegex = new Regex("<#\\w{6}>");

    private ShortcutUtils() {
    }

    public final void giveItemWithDrops(@NotNull Player player, ItemStack ... itemStacks) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)itemStacks, (String)"itemStacks");
        Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])itemStacks);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ItemStack[] validItems = thisCollection$iv.toArray(new ItemStack[0]);
        Collection collection = player.getInventory().addItem(Arrays.copyOf(validItems, validItems.length)).values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack leftover = (ItemStack)element$iv;
            boolean bl = false;
            player.getWorld().dropItemNaturally(player.getLocation(), leftover);
        }
    }

    @Nullable
    public final LivingEntity getLivingDamageSource(@NotNull EntityDamageByEntityEvent event2) {
        ProjectileSource projectileSource;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getDamager();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getDamager(...)");
        Entity damageDealer = entity;
        return damageDealer instanceof Projectile ? ((projectileSource = ((Projectile)damageDealer).getShooter()) instanceof LivingEntity ? (LivingEntity)projectileSource : null) : (damageDealer instanceof LivingEntity ? (LivingEntity)damageDealer : null);
    }

    @NotNull
    public final JSONObject openJSONFile(@NotNull File file) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            JSONObject jSONObject2;
            String data = FilesKt.readText$default((File)file, null, (int)1, null);
            try {
                jSONObject2 = new JSONObject(data);
            }
            catch (JSONException e) {
                jSONObject2 = new JSONObject();
            }
            jSONObject = jSONObject2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return jSONObject;
    }

    public final boolean isBedrockPlayer(@NotNull UUID uuid) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        try {
            bl = FloodgateApi.getInstance().isFloodgatePlayer(uuid);
        }
        catch (NoClassDefFoundError e) {
            boolean bl2;
            try {
                bl2 = Geyser.api().isBedrockPlayer(uuid);
            }
            catch (NoClassDefFoundError ex) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Component getColored(@NotNull String text) {
        String it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<String> colors = this.substringsBetween(text, "<", ">");
        Object object = text;
        Regex regex = colorCodeRegex;
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parts = (List)destination$iv$iv;
        Component component = null;
        TextComponent textComponent = Component.empty();
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"empty(...)");
        component = textComponent;
        Iterable $this$forEachIndexed$iv = parts;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void part;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (String)item$iv;
            int index = n2;
            boolean bl = false;
            TextComponent textComponent2 = index < colors.size() ? (TextComponent)Component.text((String)part).color(TextColor.fromHexString(colors.get(index))) : Component.text((String)part);
            Intrinsics.checkNotNull((Object)textComponent2);
            TextComponent coloredText = textComponent2;
            Intrinsics.checkNotNullExpressionValue((Object)component.append(coloredText), (String)"append(...)");
        }
        return component;
    }

    @NotNull
    public final List<String> substringsBetween(@NotNull String s, @NotNull String start, @NotNull String end) {
        int endIdx;
        int startIdx;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        List list = new ArrayList();
        int currentIndex = 0;
        while ((startIdx = StringsKt.indexOf$default((CharSequence)s, (String)start, (int)currentIndex, (boolean)false, (int)4, null)) != -1 && (endIdx = StringsKt.indexOf$default((CharSequence)s, (String)end, (int)(startIdx + start.length()), (boolean)false, (int)4, null)) != -1) {
            String string = s.substring(startIdx + start.length(), endIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            list.add(string);
            currentIndex = endIdx + end.length();
        }
        return list;
    }

    public final boolean isInfinite(@NotNull PotionEffect effect) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        return OriginsReforged.Companion.getNMSInvoker().supportsInfiniteDuration() ? effect.getDuration() == -1 : effect.getDuration() >= 20000;
    }

    public final int infiniteDuration() {
        return OriginsReforged.Companion.getNMSInvoker().supportsInfiniteDuration() ? -1 : 50000;
    }
}

