/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.AbilityRegister;
import ru.turbovadim.abilities.types.Ability;
import ru.turbovadim.abilities.types.AttributeModifierAbility;
import ru.turbovadim.abilities.types.DependencyAbility;
import ru.turbovadim.abilities.types.FlightAllowingAbility;
import ru.turbovadim.abilities.types.MultiAbility;
import ru.turbovadim.abilities.types.VisibilityChangingAbility;
import ru.turbovadim.commands.FlightToggleCommand;
import ru.turbovadim.cooldowns.CooldownAbility;
import ru.turbovadim.cooldowns.Cooldowns;
import ru.turbovadim.packetsenders.NMSInvoker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020'J\u0016\u0010+\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0086@\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020'J\u0016\u0010/\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020\"R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lru/turbovadim/abilities/AbilityRegister;", "", "<init>", "()V", "abilityMap", "", "Lnet/kyori/adventure/key/Key;", "Lru/turbovadim/abilities/types/Ability;", "getAbilityMap", "()Ljava/util/Map;", "dependencyAbilityMap", "Lru/turbovadim/abilities/types/DependencyAbility;", "getDependencyAbilityMap", "multiAbilityMap", "", "Lru/turbovadim/abilities/types/MultiAbility;", "getMultiAbilityMap", "origins", "Lru/turbovadim/OriginsReforged;", "getOrigins", "()Lru/turbovadim/OriginsReforged;", "nmsInvoker", "Lru/turbovadim/packetsenders/NMSInvoker;", "getNmsInvoker", "()Lru/turbovadim/packetsenders/NMSInvoker;", "attributeModifierAbilityFileConfig", "Lorg/bukkit/configuration/file/FileConfiguration;", "getAttributeModifierAbilityFileConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "setAttributeModifierAbilityFileConfig", "(Lorg/bukkit/configuration/file/FileConfiguration;)V", "attributeModifierAbilityFile", "Ljava/io/File;", "registerAbility", "", "ability", "instance", "Lorg/bukkit/plugin/java/JavaPlugin;", "canFly", "", "player", "Lorg/bukkit/entity/Player;", "disabledWorld", "isInvisible", "(Lorg/bukkit/entity/Player;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateFlight", "inDisabledWorld", "updateEntity", "target", "Lorg/bukkit/entity/Entity;", "setupAMAF", "core"})
@SourceDebugExtension(value={"SMAP\nAbilityRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbilityRegister.kt\nru/turbovadim/abilities/AbilityRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,197:1\n1869#2:198\n1870#2:206\n382#3,7:199\n*S KotlinDebug\n*F\n+ 1 AbilityRegister.kt\nru/turbovadim/abilities/AbilityRegister\n*L\n42#1:198\n42#1:206\n43#1:199,7\n*E\n"})
public final class AbilityRegister {
    @NotNull
    public static final AbilityRegister INSTANCE = new AbilityRegister();
    @NotNull
    private static final Map<Key, Ability> abilityMap = new LinkedHashMap();
    @NotNull
    private static final Map<Key, DependencyAbility> dependencyAbilityMap = new LinkedHashMap();
    @NotNull
    private static final Map<Key, List<MultiAbility>> multiAbilityMap = new LinkedHashMap();
    @NotNull
    private static final OriginsReforged origins = OriginsReforged.Companion.getInstance();
    @NotNull
    private static final NMSInvoker nmsInvoker = OriginsReforged.Companion.getNMSInvoker();
    public static FileConfiguration attributeModifierAbilityFileConfig;
    private static File attributeModifierAbilityFile;

    private AbilityRegister() {
    }

    @NotNull
    public final Map<Key, Ability> getAbilityMap() {
        return abilityMap;
    }

    @NotNull
    public final Map<Key, DependencyAbility> getDependencyAbilityMap() {
        return dependencyAbilityMap;
    }

    @NotNull
    public final Map<Key, List<MultiAbility>> getMultiAbilityMap() {
        return multiAbilityMap;
    }

    @NotNull
    public final OriginsReforged getOrigins() {
        return origins;
    }

    @NotNull
    public final NMSInvoker getNmsInvoker() {
        return nmsInvoker;
    }

    @NotNull
    public final FileConfiguration getAttributeModifierAbilityFileConfig() {
        FileConfiguration fileConfiguration = attributeModifierAbilityFileConfig;
        if (fileConfiguration != null) {
            return fileConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"attributeModifierAbilityFileConfig");
        return null;
    }

    public final void setAttributeModifierAbilityFileConfig(@NotNull FileConfiguration fileConfiguration) {
        Intrinsics.checkNotNullParameter((Object)fileConfiguration, (String)"<set-?>");
        attributeModifierAbilityFileConfig = fileConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    public final void registerAbility(@NotNull Ability ability, @NotNull JavaPlugin instance) {
        Intrinsics.checkNotNullParameter((Object)ability, (String)"ability");
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (ability instanceof DependencyAbility) {
            dependencyAbilityMap.put(ability.getKey(), (DependencyAbility)ability);
        }
        if (ability instanceof MultiAbility) {
            Iterable $this$forEach$iv = ((MultiAbility)ability).getAbilities();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                void $this$getOrPut$iv;
                Ability a2 = (Ability)element$iv;
                boolean bl = false;
                Map<Key, List<MultiAbility>> map = multiAbilityMap;
                Key key$iv = a2.getKey();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(ability);
            }
        }
        if (ability instanceof CooldownAbility) {
            Cooldowns.CooldownInfo cooldownInfo = ((CooldownAbility)ability).getCooldownInfo();
            if (cooldownInfo == null) {
                String $i$f$forEach = "Required value was null.";
                throw new IllegalArgumentException($i$f$forEach.toString());
            }
            OriginsReforged.Companion.getCooldowns().registerCooldown(instance, ((CooldownAbility)ability).getCooldownKey(), cooldownInfo);
        }
        if (ability instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)ability, (Plugin)instance);
        }
        if (ability instanceof AttributeModifierAbility) {
            String formattedValueKey = ability.getKey() + ".value";
            String formattedOperationKey = ability.getKey() + ".operation";
            boolean changed = false;
            if (!this.getAttributeModifierAbilityFileConfig().contains(ability.getKey().toString())) {
                this.getAttributeModifierAbilityFileConfig().set(formattedValueKey, (Object)"x");
                this.getAttributeModifierAbilityFileConfig().set(formattedOperationKey, (Object)"default");
                changed = true;
            }
            if (Intrinsics.areEqual((Object)"default", (Object)this.getAttributeModifierAbilityFileConfig().get(formattedValueKey, (Object)"default"))) {
                this.getAttributeModifierAbilityFileConfig().set(formattedValueKey, (Object)"x");
                changed = true;
            }
            if (changed) {
                try {
                    FileConfiguration fileConfiguration = this.getAttributeModifierAbilityFileConfig();
                    File file = attributeModifierAbilityFile;
                    if (file == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"attributeModifierAbilityFile");
                        file = null;
                    }
                    fileConfiguration.save(file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        abilityMap.put(ability.getKey(), ability);
    }

    public final boolean canFly(@NotNull Player player, boolean disabledWorld) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || FlightToggleCommand.Companion.canFly(player)) {
            return true;
        }
        if (disabledWorld) {
            return false;
        }
        for (Ability ability : abilityMap.values()) {
            if (!(ability instanceof FlightAllowingAbility) || !ability.hasAbility(player) || !((FlightAllowingAbility)ability).canFly(player)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object isInvisible(@NotNull Player player, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isInvisible.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AbilityRegister this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.isInvisible(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                    return Boxing.boxBoolean((boolean)true);
                }
                var3_6 = AbilityRegister.abilityMap.values().iterator();
lbl15:
                // 3 sources

                while (var3_6.hasNext()) {
                    ability = var3_6.next();
                    if (!(ability instanceof VisibilityChangingAbility)) continue;
                    $continuation.L$0 = player;
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = ability;
                    $continuation.label = 1;
                    v0 = ability.hasAbilityAsync(player, (Continuation<? super Boolean>)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl33
                }
                break;
            }
            case 1: {
                ability = (Ability)$continuation.L$2;
                var3_6 = (Iterator<Ability>)$continuation.L$1;
                player = (Player)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                if (!((Boolean)v0).booleanValue() || !((VisibilityChangingAbility)ability).isInvisible(player)) ** GOTO lbl15
                return Boxing.boxBoolean((boolean)true);
            }
        }
        return Boxing.boxBoolean((boolean)false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void updateFlight(@NotNull Player player, boolean inDisabledWorld) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            player.setFlySpeed(player.getFlySpeed() < 0.1f ? 0.1f : player.getFlySpeed());
            return;
        }
        if (FlightToggleCommand.Companion.canFly(player)) {
            player.setFlySpeed(0.1f);
            return;
        }
        if (inDisabledWorld) {
            return;
        }
        TriState flyingFallDamage = TriState.FALSE;
        float speed = -1.0f;
        for (Ability ability : abilityMap.values()) {
            if (!(ability instanceof FlightAllowingAbility) || !ability.hasAbility(player) || !((FlightAllowingAbility)ability).canFly(player)) continue;
            float abilitySpeed = ((FlightAllowingAbility)ability).getFlightSpeed(player);
            float f = speed = speed < 0.0f ? abilitySpeed : Math.min(speed, abilitySpeed);
            if (((FlightAllowingAbility)ability).getFlyingFallDamage(player) != TriState.TRUE) continue;
            flyingFallDamage = TriState.TRUE;
        }
        nmsInvoker.setFlyingFallDamage(player, flyingFallDamage);
        player.setFlySpeed(speed < 0.0f ? 0.0f : speed);
    }

    public final void updateEntity(@NotNull Player player, @NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        byte data = 0;
        if (target.getFireTicks() > 0) {
            data = 1;
        }
        if (target.isGlowing()) {
            data = (byte)(data | 0x40);
        }
        if (target instanceof LivingEntity && ((LivingEntity)target).isInvisible()) {
            data = (byte)(data | 0x20);
        }
        if (target instanceof Player) {
            if (((Player)target).isSneaking()) {
                data = (byte)(data | 2);
            }
            if (((Player)target).isSprinting()) {
                data = (byte)(data | 8);
            }
            if (((Player)target).isSwimming()) {
                data = (byte)(data | 0x10);
            }
            if (((Player)target).isGliding()) {
                data = (byte)(data | 0x80);
            }
            PlayerInventory playerInventory = ((Player)target).getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)playerInventory, (String)"getInventory(...)");
            PlayerInventory inventory = playerInventory;
            for (EquipmentSlot slot : EntriesMappings.entries$0) {
                try {
                    ItemStack item;
                    Intrinsics.checkNotNullExpressionValue((Object)inventory.getItem(slot), (String)"getItem(...)");
                    player.sendEquipmentChange((LivingEntity)target, slot, item);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        nmsInvoker.sendEntityData(player, target, data);
    }

    public final void setupAMAF() {
        attributeModifierAbilityFile = new File(origins.getDataFolder(), "attribute-modifier-ability-config.yml");
        File file = attributeModifierAbilityFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attributeModifierAbilityFile");
            file = null;
        }
        if (!file.exists()) {
            File file2 = attributeModifierAbilityFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attributeModifierAbilityFile");
                file2 = null;
            }
            file2.getParentFile().mkdirs();
            origins.saveResource("attribute-modifier-ability-config.yml", false);
        }
        this.setAttributeModifierAbilityFileConfig((FileConfiguration)new YamlConfiguration());
        try {
            FileConfiguration fileConfiguration = this.getAttributeModifierAbilityFileConfig();
            File file3 = attributeModifierAbilityFile;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attributeModifierAbilityFile");
                file3 = null;
            }
            fileConfiguration.load(file3);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

