/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.fantasy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lru/turbovadim/abilities/fantasy/FortuneIncreaser;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "blocks", "", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/inventory/ItemStack;", "onBlockDropItem", "", "event", "Lorg/bukkit/event/block/BlockDropItemEvent;", "onBlockBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nFortuneIncreaser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FortuneIncreaser.kt\nru/turbovadim/abilities/fantasy/FortuneIncreaser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1563#2:71\n1634#2,3:72\n1869#2:75\n1878#2,3:76\n1870#2:79\n1869#2,2:80\n*S KotlinDebug\n*F\n+ 1 FortuneIncreaser.kt\nru/turbovadim/abilities/fantasy/FortuneIncreaser\n*L\n39#1:71\n39#1:72,3\n42#1:75\n43#1:76,3\n42#1:79\n55#1:80,2\n*E\n"})
public final class FortuneIncreaser
implements VisibleAbility,
Listener {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("Your care and mastery in the art of extracting minerals results in a much higher yield from ores than other creatures.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Careful Miner", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;
    @NotNull
    private final Map<Player, List<ItemStack>> blocks;

    public FortuneIncreaser() {
        Key key = Key.key("fantasyorigins:fortune_increaser");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.blocks = new LinkedHashMap();
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onBlockDropItem(@NotNull BlockDropItemEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getPlayer().getInventory().getItemInMainHand().getItemMeta() == null) {
            return;
        }
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.runForAbility((Entity)player, arg_0 -> FortuneIncreaser.onBlockDropItem$lambda$0(this, event2, arg_0));
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ItemStack itemStack = event2.getPlayer().getInventory().getItemInMainHand().clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack mainHandItem = itemStack;
        if (mainHandItem.getItemMeta() == null) {
            return;
        }
        Enchantment fortune = OriginsReforged.Companion.getNMSInvoker().getFortuneEnchantment();
        mainHandItem.addUnsafeEnchantment(fortune, mainHandItem.getEnchantmentLevel(fortune) + 2);
        Map<Player, List<ItemStack>> map = this.blocks;
        Player player = event2.getPlayer();
        Collection collection = event2.getBlock().getDrops(mainHandItem, (Entity)event2.getPlayer());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDrops(...)");
        List list = CollectionsKt.toMutableList((Collection)collection);
        map.put(player, list);
    }

    /*
     * WARNING - void declaration
     */
    private static final void onBlockDropItem$lambda$0(FortuneIncreaser this$0, BlockDropItemEvent $event, Player player) {
        Iterator $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"<unused var>");
        List list = this$0.blocks.get($event.getPlayer());
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        List storedItems = list;
        List list2 = $event.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Item item = (Item)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getItemStack());
        }
        List droppedItems = (List)destination$iv$iv;
        $event.getItems().clear();
        Iterable $this$forEach$iv = droppedItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack dropped = (ItemStack)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = storedItems;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void stored;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ItemStack itemStack = (ItemStack)item$iv;
                int index = n;
                boolean bl2 = false;
                if (stored.getAmount() <= 0 || stored.getType() != dropped.getType() || !Intrinsics.areEqual((Object)stored.getItemMeta(), (Object)dropped.getItemMeta())) continue;
                stored.setAmount(Math.max(0, stored.getAmount() - dropped.getAmount()));
                storedItems.set(index, stored);
            }
        }
        storedItems.addAll(droppedItems);
        storedItems.removeIf(arg_0 -> FortuneIncreaser.onBlockDropItem$lambda$0$3(FortuneIncreaser::onBlockDropItem$lambda$0$2, arg_0));
        Location location = $event.getBlock().getLocation().clone().add(0.5, 0.0, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        Location dropLocation = location;
        Iterable $this$forEach$iv2 = storedItems;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ItemStack item = (ItemStack)element$iv;
            boolean bl = false;
            $event.getItems().add($event.getBlock().getWorld().dropItem(dropLocation, item));
        }
    }

    private static final boolean onBlockDropItem$lambda$0$2(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAmount() <= 0;
    }

    private static final boolean onBlockDropItem$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

