/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.Ability;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lru/turbovadim/abilities/main/Arthropod;", "Lru/turbovadim/abilities/types/Ability;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "random", "Ljava/util/Random;", "onEntityDamageByEntity", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "core"})
public final class Arthropod
implements Ability,
Listener {
    @NotNull
    private final Key key;
    @NotNull
    private final Random random;

    public Arthropod() {
        Key key = Key.key("origins:arthropod");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.random = new Random();
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getDamager();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity damager = livingEntity;
        EntityEquipment entityEquipment = damager.getEquipment();
        if (entityEquipment == null) {
            return;
        }
        EntityEquipment equipment = entityEquipment;
        ItemStack itemStack = equipment.getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        ItemStack mainHand = itemStack;
        Enchantment baneEnchantment = OriginsReforged.Companion.getNMSInvoker().getBaneOfArthropodsEnchantment();
        if (!mainHand.containsEnchantment(baneEnchantment)) {
            return;
        }
        Entity entity2 = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"getEntity(...)");
        this.runForAbility(entity2, arg_0 -> Arthropod.onEntityDamageByEntity$lambda$0(mainHand, baneEnchantment, event2, this, arg_0));
    }

    private static final void onEntityDamageByEntity$lambda$0(ItemStack $mainHand, Enchantment $baneEnchantment, EntityDamageByEntityEvent $event, Arthropod this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int level = $mainHand.getEnchantmentLevel($baneEnchantment);
        $event.setDamage($event.getDamage() + 1.25 * (double)level);
        int duration = (int)((double)20 * this$0.random.nextDouble(1.0, 1.0 + 0.5 * (double)level));
        player.addPotionEffect(new PotionEffect(OriginsReforged.Companion.getNMSInvoker().getSlownessEffect(), duration, 3, false, true));
    }
}

