/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.abilities.types.DependantAbility;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lru/turbovadim/abilities/main/BurnInDaylight;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lru/turbovadim/abilities/types/DependantAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "dependencyType", "Lru/turbovadim/abilities/types/DependantAbility$DependencyType;", "getDependencyType", "()Lru/turbovadim/abilities/types/DependantAbility$DependencyType;", "onServerTickEnd", "", "event", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "dependencyKey", "getDependencyKey", "core"})
@SourceDebugExtension(value={"SMAP\nBurnInDaylight.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BurnInDaylight.kt\nru/turbovadim/abilities/main/BurnInDaylight\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1869#2,2:58\n*S KotlinDebug\n*F\n+ 1 BurnInDaylight.kt\nru/turbovadim/abilities/main/BurnInDaylight\n*L\n26#1:58,2\n*E\n"})
public class BurnInDaylight
implements VisibleAbility,
DependantAbility,
Listener {
    @NotNull
    private final DependantAbility.DependencyType dependencyType = DependantAbility.DependencyType.INVERSE;
    @NotNull
    private final Key key;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;
    @NotNull
    private final Key dependencyKey;

    public BurnInDaylight() {
        Key key = Key.key("origins:burn_in_daylight");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("You begin to burn in daylight if you are not invisible.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Photoallergic", OriginSwapper.LineData.LineComponent.LineType.TITLE);
        Key key2 = Key.key("origins:phantomize");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"key(...)");
        this.dependencyKey = key2;
    }

    @Override
    @NotNull
    public DependantAbility.DependencyType getDependencyType() {
        return this.dependencyType;
    }

    @EventHandler
    public final void onServerTickEnd(@NotNull ServerTickEndEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getTickNumber() % 15 != 0) {
            return;
        }
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, BurnInDaylight::onServerTickEnd$lambda$0$0);
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return this.dependencyKey;
    }

    private static final void onServerTickEnd$lambda$0$0(Player player) {
        boolean isBelowPlayer;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        World world2 = world;
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Location loc = location;
        double playerY = loc.getY();
        Block block = world2.getHighestBlockAt(loc);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getHighestBlockAt(...)");
        Block block2 = block;
        while ((MaterialTags.GLASS.isTagged(block2) || MaterialTags.GLASS_PANES.isTagged(block2)) && (double)block2.getY() >= playerY) {
            Intrinsics.checkNotNullExpressionValue((Object)block2.getRelative(BlockFace.DOWN), (String)"getRelative(...)");
        }
        boolean bl = isBelowPlayer = (double)block2.getY() < playerY;
        if (isBelowPlayer && world2.getEnvironment() == World.Environment.NORMAL && world2.isDayTime() && !player.isInWaterOrRainOrBubbleColumn()) {
            player.setFireTicks(RangesKt.coerceAtLeast((int)player.getFireTicks(), (int)60));
        }
    }
}

