/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import com.destroystokyo.paper.MaterialTags;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.Origin;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.ShortcutUtils;
import ru.turbovadim.abilities.types.VisibleAbility;
import ru.turbovadim.events.PlayerSwapOriginEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001dH\u0007J\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lru/turbovadim/abilities/main/LightArmor;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "allowedTypes", "Lorg/bukkit/Material;", "onPlayerSwapOrigin", "", "event", "Lru/turbovadim/events/PlayerSwapOriginEvent;", "onInventoryDrag", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "onInventoryClick", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onPlayerInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onBlockDispenseArmor", "Lorg/bukkit/event/block/BlockDispenseArmorEvent;", "checkArmorEvent", "Lorg/bukkit/event/Cancellable;", "p", "Lorg/bukkit/entity/Player;", "armor", "Lorg/bukkit/inventory/ItemStack;", "isArmor", "", "material", "core"})
@SourceDebugExtension(value={"SMAP\nLightArmor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightArmor.kt\nru/turbovadim/abilities/main/LightArmor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1761#2,3:170\n1869#2,2:173\n1#3:175\n*S KotlinDebug\n*F\n+ 1 LightArmor.kt\nru/turbovadim/abilities/main/LightArmor\n*L\n61#1:170,3\n70#1:173,2\n*E\n"})
public final class LightArmor
implements VisibleAbility,
Listener {
    @NotNull
    private final Key key;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;
    @NotNull
    private final List<Material> allowedTypes;

    public LightArmor() {
        Key key = Key.key("origins:light_armor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("You can not wear any heavy armor (armor with protection values higher than chainmail).", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Need for Mobility", OriginSwapper.LineData.LineComponent.LineType.TITLE);
        Object[] objectArray = new Material[]{Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS};
        this.allowedTypes = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @EventHandler
    public final void onPlayerSwapOrigin(@NotNull PlayerSwapOriginEvent event2) {
        boolean bl;
        ItemStack boots;
        ItemStack leggings;
        ItemStack chestplate;
        ItemStack helmet;
        PlayerInventory inventory;
        Player player;
        block7: {
            Intrinsics.checkNotNullParameter((Object)((Object)event2), (String)"event");
            Origin origin2 = event2.newOrigin;
            if (origin2 == null) {
                return;
            }
            Origin newOrigin = origin2;
            if (!newOrigin.hasAbility(this.getKey())) {
                return;
            }
            Player player2 = event2.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
            player = player2;
            PlayerInventory playerInventory = player.getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)playerInventory, (String)"getInventory(...)");
            inventory = playerInventory;
            helmet = inventory.getHelmet();
            chestplate = inventory.getChestplate();
            leggings = inventory.getLeggings();
            boots = inventory.getBoots();
            Object[] objectArray = new ItemStack[]{helmet, chestplate, leggings, boots};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Object[] $i$f$any = new Pair[]{TuplesKt.to((Object)helmet, () -> LightArmor.onPlayerSwapOrigin$lambda$1(inventory)), TuplesKt.to((Object)chestplate, () -> LightArmor.onPlayerSwapOrigin$lambda$2(inventory)), TuplesKt.to((Object)leggings, () -> LightArmor.onPlayerSwapOrigin$lambda$3(inventory)), TuplesKt.to((Object)boots, () -> LightArmor.onPlayerSwapOrigin$lambda$4(inventory))};
        List armorPieces = CollectionsKt.listOf((Object[])$i$f$any);
        Iterable $this$forEach$iv = armorPieces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl3 = false;
            ItemStack item = (ItemStack)pair.component1();
            Function0 removeSlot = (Function0)pair.component2();
            ItemStack itemStack = item;
            if (CollectionsKt.contains((Iterable)this.allowedTypes, (Object)(itemStack != null ? itemStack.getType() : null))) continue;
            removeSlot.invoke();
            ItemStack[] itemStackArray = new ItemStack[]{item};
            ShortcutUtils.INSTANCE.giveItemWithDrops(player, itemStackArray);
        }
    }

    @EventHandler
    public final void onInventoryDrag(@NotNull InventoryDragEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getInventorySlots().contains(38)) {
            HumanEntity humanEntity = event2.getWhoClicked();
            Intrinsics.checkNotNullExpressionValue((Object)humanEntity, (String)"getWhoClicked(...)");
            HumanEntity clicker = humanEntity;
            if (clicker instanceof Player) {
                Cancellable cancellable = (Cancellable)event2;
                Player player = (Player)clicker;
                ItemStack itemStack = event2.getOldCursor();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getOldCursor(...)");
                this.checkArmorEvent(cancellable, player, itemStack);
            }
        }
    }

    @EventHandler
    public final void onInventoryClick(@NotNull InventoryClickEvent event2) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            HumanEntity humanEntity = event2.getWhoClicked();
            Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
            if (player == null) {
                return;
            }
            Player clicker = player;
            ItemStack itemStack = event2.getCursor();
            if (itemStack != null) {
                ItemStack itemStack2;
                ItemStack it = itemStack2 = itemStack;
                boolean bl = false;
                Material material = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
                Object object = humanEntity = this.isArmor(material) && event2.getSlotType() == InventoryType.SlotType.ARMOR ? itemStack2 : null;
                if (humanEntity != null) {
                    it = humanEntity;
                    boolean bl2 = false;
                    this.checkArmorEvent((Cancellable)event2, clicker, it);
                }
            }
            if (event2.isShiftClick()) {
                ItemStack itemStack3 = event2.getCurrentItem();
                if (itemStack3 == null) {
                    return;
                }
                ItemStack currentItem = itemStack3;
                if (event2.getInventory().getType() != InventoryType.CRAFTING) {
                    return;
                }
                if (MaterialTags.HELMETS.isTagged(currentItem.getType()) && clicker.getEquipment().getHelmet() == null) {
                    this.checkArmorEvent((Cancellable)event2, clicker, currentItem);
                }
                if (MaterialTags.CHESTPLATES.isTagged(currentItem.getType()) && clicker.getEquipment().getChestplate() == null) {
                    this.checkArmorEvent((Cancellable)event2, clicker, currentItem);
                }
                if (MaterialTags.LEGGINGS.isTagged(currentItem.getType()) && clicker.getEquipment().getLeggings() == null) {
                    this.checkArmorEvent((Cancellable)event2, clicker, currentItem);
                }
                if (MaterialTags.BOOTS.isTagged(currentItem.getType()) && clicker.getEquipment().getBoots() == null) {
                    this.checkArmorEvent((Cancellable)event2, clicker, currentItem);
                }
            }
            if (event2.getAction() == InventoryAction.HOTBAR_SWAP && event2.getHotbarButton() == -1 && event2.getSlotType() == InventoryType.SlotType.ARMOR) {
                Cancellable cancellable = (Cancellable)event2;
                ItemStack itemStack4 = clicker.getInventory().getItemInOffHand();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"getItemInOffHand(...)");
                this.checkArmorEvent(cancellable, clicker, itemStack4);
            }
            if (event2.getClick() != ClickType.NUMBER_KEY || event2.getSlotType() != InventoryType.SlotType.ARMOR) break block12;
            ItemStack itemStack5 = clicker.getInventory().getItem(event2.getHotbarButton());
            if (itemStack5 != null) {
                ItemStack item = itemStack5;
                boolean bl = false;
                this.checkArmorEvent((Cancellable)event2, clicker, item);
            }
        }
    }

    @EventHandler
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getAction().isRightClick()) {
            if (event2.getItem() == null) {
                return;
            }
            ItemStack itemStack = event2.getItem();
            Intrinsics.checkNotNull((Object)itemStack);
            if (MaterialTags.HELMETS.isTagged(itemStack.getType())) {
                Cancellable cancellable = (Cancellable)event2;
                Player player = event2.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                ItemStack itemStack2 = event2.getItem();
                Intrinsics.checkNotNull((Object)itemStack2);
                this.checkArmorEvent(cancellable, player, itemStack2);
            }
            ItemStack itemStack3 = event2.getItem();
            Intrinsics.checkNotNull((Object)itemStack3);
            if (MaterialTags.CHESTPLATES.isTagged(itemStack3.getType())) {
                Cancellable cancellable = (Cancellable)event2;
                Player player = event2.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                ItemStack itemStack4 = event2.getItem();
                Intrinsics.checkNotNull((Object)itemStack4);
                this.checkArmorEvent(cancellable, player, itemStack4);
            }
            ItemStack itemStack5 = event2.getItem();
            Intrinsics.checkNotNull((Object)itemStack5);
            if (MaterialTags.LEGGINGS.isTagged(itemStack5.getType())) {
                Cancellable cancellable = (Cancellable)event2;
                Player player = event2.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                ItemStack itemStack6 = event2.getItem();
                Intrinsics.checkNotNull((Object)itemStack6);
                this.checkArmorEvent(cancellable, player, itemStack6);
            }
            ItemStack itemStack7 = event2.getItem();
            Intrinsics.checkNotNull((Object)itemStack7);
            if (MaterialTags.BOOTS.isTagged(itemStack7.getType())) {
                Cancellable cancellable = (Cancellable)event2;
                Player player = event2.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                ItemStack itemStack8 = event2.getItem();
                Intrinsics.checkNotNull((Object)itemStack8);
                this.checkArmorEvent(cancellable, player, itemStack8);
            }
        }
    }

    @EventHandler
    public final void onBlockDispenseArmor(@NotNull BlockDispenseArmorEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        LivingEntity livingEntity = event2.getTargetEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getTargetEntity(...)");
        LivingEntity target = livingEntity;
        if (target instanceof Player) {
            Cancellable cancellable = (Cancellable)event2;
            Player player = (Player)target;
            ItemStack itemStack = event2.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            this.checkArmorEvent(cancellable, player, itemStack);
        }
    }

    public final void checkArmorEvent(@NotNull Cancellable event2, @NotNull Player p, @NotNull ItemStack armor) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
        this.runForAbility((Entity)p, arg_0 -> LightArmor.checkArmorEvent$lambda$0(this, armor, event2, arg_0));
    }

    public final boolean isArmor(@NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        return MaterialTags.HELMETS.isTagged(material) || MaterialTags.CHESTPLATES.isTagged(material) || MaterialTags.LEGGINGS.isTagged(material) || MaterialTags.BOOTS.isTagged(material);
    }

    private static final Unit onPlayerSwapOrigin$lambda$1(PlayerInventory $inventory) {
        $inventory.setHelmet(null);
        return Unit.INSTANCE;
    }

    private static final Unit onPlayerSwapOrigin$lambda$2(PlayerInventory $inventory) {
        $inventory.setChestplate(null);
        return Unit.INSTANCE;
    }

    private static final Unit onPlayerSwapOrigin$lambda$3(PlayerInventory $inventory) {
        $inventory.setLeggings(null);
        return Unit.INSTANCE;
    }

    private static final Unit onPlayerSwapOrigin$lambda$4(PlayerInventory $inventory) {
        $inventory.setBoots(null);
        return Unit.INSTANCE;
    }

    private static final void checkArmorEvent$lambda$0(LightArmor this$0, ItemStack $armor, Cancellable $event, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this$0.allowedTypes.contains($armor.getType())) {
            return;
        }
        $event.setCancelled(true);
    }
}

