/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerPosition;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.FlightAllowingAbility;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020 H\u0007R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%\u00a8\u0006("}, d2={"Lru/turbovadim/abilities/main/LikeWater;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lru/turbovadim/abilities/types/FlightAllowingAbility;", "Lorg/bukkit/event/Listener;", "Lcom/github/retrooper/packetevents/event/PacketListener;", "<init>", "()V", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "canFly", "", "player", "Lorg/bukkit/entity/Player;", "getFlightSpeed", "", "onPlayerToggleSneak", "", "event", "Lorg/bukkit/event/player/PlayerToggleSneakEvent;", "previousPositions", "", "Lcom/github/retrooper/packetevents/protocol/world/Location;", "getPreviousPositions", "()Ljava/util/Map;", "onPacketReceive", "Lcom/github/retrooper/packetevents/event/PacketReceiveEvent;", "onPlayerMove", "onPlayerToggleSprint", "Lorg/bukkit/event/player/PlayerToggleSprintEvent;", "onPlayerToggleFlight", "Lorg/bukkit/event/player/PlayerToggleFlightEvent;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "core"})
public final class LikeWater
implements VisibleAbility,
FlightAllowingAbility,
Listener,
PacketListener {
    @NotNull
    private final Key key;
    @NotNull
    private final Map<Player, Location> previousPositions;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;

    public LikeWater() {
        Key key = Key.key("origins:like_water");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.previousPositions = new LinkedHashMap();
        this.description = OriginSwapper.LineData.Companion.makeLineFor("When underwater, you do not sink to the ground unless you want to.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Like Water", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    public boolean canFly(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.isInWater() && !player.isInBubbleColumn();
    }

    @Override
    public float getFlightSpeed(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return 0.06f;
    }

    @EventHandler
    public final void onPlayerToggleSneak(@NotNull PlayerToggleSneakEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.runForAbility((Entity)player, LikeWater::onPlayerToggleSneak$lambda$0);
    }

    @NotNull
    public final Map<Player, Location> getPreviousPositions() {
        return this.previousPositions;
    }

    public void onPacketReceive(@NotNull PacketReceiveEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getPacketType() == PacketType.Play.Client.PLAYER_POSITION) {
            this.onPlayerMove(event2);
        }
    }

    public final void onPlayerMove(@NotNull PacketReceiveEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        WrapperPlayClientPlayerPosition packet = new WrapperPlayClientPlayerPosition(event2);
        Object object = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getPlayer(...)");
        Player player = (Player)object;
        if (!player.isInWater() || player.isSwimming()) {
            return;
        }
        this.runForAbility((Entity)player, arg_0 -> LikeWater.onPlayerMove$lambda$0(packet, this, arg_0));
    }

    @EventHandler
    public final void onPlayerToggleSprint(@NotNull PlayerToggleSprintEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!event2.getPlayer().isFlying()) {
            return;
        }
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.runForAbility((Entity)player, LikeWater::onPlayerToggleSprint$lambda$0);
    }

    @EventHandler
    public final void onPlayerToggleFlight(@NotNull PlayerToggleFlightEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.runForAbility((Entity)player, arg_0 -> LikeWater.onPlayerToggleFlight$lambda$0(event2, arg_0));
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    private static final void onPlayerToggleSneak$lambda$0(Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.isInWater()) {
            player.setFlying(false);
        }
    }

    private static final void onPlayerMove$lambda$0(WrapperPlayClientPlayerPosition $packet, LikeWater this$0, Player p) {
        boolean isFlying;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double d = $packet.getLocation().getY();
        Map<Player, Location> map = this$0.previousPositions;
        Location location = $packet.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        boolean rising = d > map.getOrDefault(p, location).getY();
        this$0.previousPositions.put(p, $packet.getLocation());
        boolean bl = isFlying = (p.isFlying() || rising) && !p.isInBubbleColumn();
        if (isFlying == p.isFlying()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)OriginsReforged.Companion.getBukkitDispatcher())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(p, isFlying, null){
            int label;
            final /* synthetic */ Player $p;
            final /* synthetic */ boolean $isFlying;
            {
                this.$p = $p;
                this.$isFlying = $isFlying;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            this.$p.setFlying(this.$isFlying);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void onPlayerToggleSprint$lambda$0(Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.isInWater()) {
            player.setFlying(false);
        }
    }

    private static final void onPlayerToggleFlight$lambda$0(PlayerToggleFlightEvent $event, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.isInWater()) {
            $event.setCancelled(true);
        }
    }
}

