/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.BreakSpeedModifierAbility;
import ru.turbovadim.abilities.types.DependantAbility;
import ru.turbovadim.abilities.types.FlightAllowingAbility;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0%J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020)H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020)H\u0016J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020)H\u0016J\u0018\u00103\u001a\u00020\u00162\u0006\u0010+\u001a\u00020)2\u0006\u00104\u001a\u00020\u001fH\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0006\u0012\u0004\u0018\u00010\u001f0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lru/turbovadim/abilities/main/Phasing;", "Lru/turbovadim/abilities/types/DependantAbility;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lru/turbovadim/abilities/types/FlightAllowingAbility;", "Lru/turbovadim/abilities/types/BreakSpeedModifierAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "dependencyKey", "getDependencyKey", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "onServerTick", "", "event", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "unphasable", "", "Lorg/bukkit/Material;", "isInBlock", "", "entity", "Lorg/bukkit/entity/Entity;", "location", "Lorg/bukkit/Location;", "predicate", "Ljava/util/function/Predicate;", "Lorg/bukkit/block/Block;", "isPhasing", "", "Lorg/bukkit/entity/Player;", "canFly", "player", "onEntityDamage", "Lorg/bukkit/event/entity/EntityDamageEvent;", "getFlightSpeed", "", "provideContextFor", "Lru/turbovadim/abilities/types/BreakSpeedModifierAbility$BlockMiningContext;", "shouldActivate", "setPhasing", "enabled", "core"})
@SourceDebugExtension(value={"SMAP\nPhasing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Phasing.kt\nru/turbovadim/abilities/main/Phasing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1869#2,2:172\n1761#2,2:174\n1761#2,2:176\n1761#2,3:178\n1763#2:181\n1763#2:182\n1#3:183\n*S KotlinDebug\n*F\n+ 1 Phasing.kt\nru/turbovadim/abilities/main/Phasing\n*L\n47#1:172,2\n93#1:174,2\n94#1:176,2\n95#1:178,3\n94#1:181\n93#1:182\n*E\n"})
public final class Phasing
implements DependantAbility,
VisibleAbility,
FlightAllowingAbility,
BreakSpeedModifierAbility,
Listener {
    @NotNull
    private final Key key;
    @NotNull
    private final Key dependencyKey;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;
    @NotNull
    private final List<Material> unphasable;
    @NotNull
    private final Map<Player, Boolean> isPhasing;

    public Phasing() {
        Key key = Key.key("origins:phasing");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        Key key2 = Key.key("origins:phantomize");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"key(...)");
        this.dependencyKey = key2;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("While phantomized, you can walk through solid material, except Obsidian.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Phasing", OriginSwapper.LineData.LineComponent.LineType.TITLE);
        Object[] objectArray = new Material[]{Material.OBSIDIAN, Material.BEDROCK};
        this.unphasable = CollectionsKt.listOf((Object[])objectArray);
        this.isPhasing = new HashMap();
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return this.dependencyKey;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @EventHandler
    public final void onServerTick(@Nullable ServerTickEndEvent event2) {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> Phasing.onServerTick$lambda$0$0(this, arg_0), arg_0 -> Phasing.onServerTick$lambda$0$1(this, arg_0));
        }
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        if (Intrinsics.areEqual((Object)this.isPhasing.get(player2), (Object)true)) {
            Location location = event2.getTo();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getTo(...)");
            if (this.isInBlock(location, arg_0 -> Phasing.onPlayerMove$lambda$0(this, arg_0))) {
                event2.setCancelled(true);
            }
        }
    }

    public final boolean isInBlock(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Location location = entity.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return this.isInBlock(location, arg_0 -> Phasing.isInBlock$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isInBlock(@NotNull Location location, @NotNull Predicate<Block> predicate) {
        boolean bl;
        block11: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Object object = new Double[]{0.4, -0.4};
            List offsets = CollectionsKt.listOf((Object[])object);
            object = new Location[]{location.clone().add(0.0, 1.0, 0.0), location.clone()};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block10: {
                        Location base = (Location)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = offsets;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                boolean bl4;
                                block9: {
                                    double dx = ((Number)element$iv2).doubleValue();
                                    boolean bl5 = false;
                                    Iterable $this$any$iv3 = offsets;
                                    boolean $i$f$any3 = false;
                                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                        bl4 = false;
                                    } else {
                                        for (Object element$iv3 : $this$any$iv3) {
                                            double dz = ((Number)element$iv3).doubleValue();
                                            boolean bl6 = false;
                                            if (!predicate.test(base.clone().add(dx, 0.0, dz).getBlock())) continue;
                                            bl4 = true;
                                            break block9;
                                        }
                                        bl4 = false;
                                    }
                                }
                                if (!bl4) continue;
                                bl2 = true;
                                break block10;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean canFly(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getDependency().isEnabled(player) && Intrinsics.areEqual((Object)this.isPhasing.getOrDefault(player, false), (Object)true);
    }

    @EventHandler
    public final void onEntityDamage(@NotNull EntityDamageEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        this.runForAbility(entity, arg_0 -> Phasing.onEntityDamage$lambda$0(event2, arg_0));
    }

    @Override
    public float getFlightSpeed(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return 0.1f;
    }

    @Override
    @NotNull
    public BreakSpeedModifierAbility.BlockMiningContext provideContextFor(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack helmet = player.getInventory().getHelmet();
        boolean aquaAffinity = false;
        if (helmet != null) {
            aquaAffinity = helmet.containsEnchantment(OriginsReforged.Companion.getNMSInvoker().getAquaAffinityEnchantment());
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        return new BreakSpeedModifierAbility.BlockMiningContext(itemStack, player.getPotionEffect(OriginsReforged.Companion.getNMSInvoker().getHasteEffect()), player.getPotionEffect(OriginsReforged.Companion.getNMSInvoker().getMiningFatigueEffect()), player.getPotionEffect(PotionEffectType.CONDUIT_POWER), OriginsReforged.Companion.getNMSInvoker().isUnderWater((LivingEntity)player), aquaAffinity, true);
    }

    @Override
    public boolean shouldActivate(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getDependency().isEnabled(player) && Intrinsics.areEqual((Object)this.isPhasing.getOrDefault(player, false), (Object)true);
    }

    private final void setPhasing(Player player, boolean enabled) {
        GameMode gameMode;
        boolean effectiveEnabled = this.hasAbility(player) && enabled;
        Block block = player.getEyeLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        Block block2 = block;
        if (block2.getType().isCollidable() && effectiveEnabled) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, -1, 0, false, false));
        } else {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
        }
        if (Intrinsics.areEqual((Object)this.isPhasing.getOrDefault(player, false), (Object)effectiveEnabled)) {
            return;
        }
        Vector vector = player.getVelocity();
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getVelocity(...)");
        Vector currentVelocity = vector;
        if (effectiveEnabled) {
            gameMode = GameMode.SPECTATOR;
        } else {
            GameMode gameMode2 = player.getGameMode();
            gameMode = gameMode2;
            Intrinsics.checkNotNullExpressionValue((Object)gameMode2, (String)"getGameMode(...)");
        }
        GameMode gameMode3 = gameMode;
        OriginsReforged.Companion.getNMSInvoker().sendPhasingGamemodeUpdate(player, gameMode3);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReforged.Companion.getInstance(), () -> Phasing.setPhasing$lambda$0(player, currentVelocity));
        this.isPhasing.put(player, effectiveEnabled);
    }

    private static final void onServerTick$lambda$0$0(Phasing this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean inBlock = this$0.isInBlock((Entity)player);
        Material material = player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        Material blockBelowType = material;
        boolean shouldPhase = player.isOnGround() && player.isSneaking() && !this$0.unphasable.contains(blockBelowType) || inBlock;
        this$0.setPhasing(player, shouldPhase);
        Boolean bl = this$0.isPhasing.getOrDefault(player, false);
        Intrinsics.checkNotNull((Object)bl);
        boolean phasingActive = bl;
        OriginsReforged.Companion.getNMSInvoker().setNoPhysics(player, player.getGameMode() == GameMode.SPECTATOR || phasingActive);
        if (phasingActive) {
            player.setFallDistance(0.0f);
            if (player.getAllowFlight()) {
                player.setFlying(true);
            }
        }
    }

    private static final void onServerTick$lambda$0$1(Phasing this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Boolean bl = this$0.isPhasing.getOrDefault(player, false);
        Intrinsics.checkNotNull((Object)bl);
        if (bl.booleanValue()) {
            this$0.setPhasing(player, false);
        }
    }

    private static final boolean onPlayerMove$lambda$0(Phasing this$0, Block block) {
        Block block2 = block;
        return CollectionsKt.contains((Iterable)this$0.unphasable, (Object)(block2 != null ? block2.getType() : null));
    }

    private static final boolean isInBlock$lambda$0(Phasing this$0, Block block) {
        boolean bl;
        Block block2 = block;
        if (block2 != null) {
            Block it = block2;
            boolean bl2 = false;
            bl = it.getType().isSolid() && !this$0.unphasable.contains(it.getType());
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void onEntityDamage$lambda$0(EntityDamageEvent $event, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($event.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
            $event.setCancelled(true);
        }
    }

    private static final void setPhasing$lambda$0(Player $player, Vector $currentVelocity) {
        $player.setVelocity($currentVelocity);
    }
}

