/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import com.destroystokyo.paper.entity.ai.Goal;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001eH\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lru/turbovadim/abilities/main/ScareCreepers;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "onEntitySpawn", "", "event", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "onEntitiesLoad", "Lorg/bukkit/event/world/EntitiesLoadEvent;", "fixCreeper", "creeper", "Lorg/bukkit/entity/Creeper;", "hitByPlayerKey", "Lorg/bukkit/NamespacedKey;", "onEntityDamageByEntity", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onEntityTargetLivingEntity", "Lorg/bukkit/event/entity/EntityTargetLivingEntityEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nScareCreepers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScareCreepers.kt\nru/turbovadim/abilities/main/ScareCreepers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class ScareCreepers
implements VisibleAbility,
Listener {
    @NotNull
    private final Key key;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;
    @NotNull
    private final NamespacedKey hitByPlayerKey;

    public ScareCreepers() {
        Key key = Key.key("origins:scare_creepers");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("Creepers are scared of you and will only explode if you attack them first.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Catlike Appearance", OriginSwapper.LineData.LineComponent.LineType.TITLE);
        this.hitByPlayerKey = new NamespacedKey((Plugin)OriginsReforged.Companion.getInstance(), "hit-by-player");
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @EventHandler
    public final void onEntitySpawn(@NotNull EntitySpawnEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        Entity creeper = entity;
        if (creeper instanceof Creeper) {
            this.fixCreeper((Creeper)creeper);
        }
    }

    @EventHandler
    public final void onEntitiesLoad(@NotNull EntitiesLoadEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        for (Entity entity : event2.getEntities()) {
            if (!(entity instanceof Creeper)) continue;
            this.fixCreeper((Creeper)entity);
        }
    }

    public final void fixCreeper(@NotNull Creeper creeper) {
        Intrinsics.checkNotNullParameter((Object)creeper, (String)"creeper");
        Goal<Creeper> afraidGoal = OriginsReforged.Companion.getNMSInvoker().getCreeperAfraidGoal((LivingEntity)creeper, arg_0 -> ScareCreepers.fixCreeper$lambda$0(this, arg_0), arg_0 -> ScareCreepers.fixCreeper$lambda$1(creeper, this, arg_0));
        Bukkit.getMobGoals().addGoal((Mob)creeper, 0, afraidGoal);
    }

    @EventHandler
    public final void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event2) {
        Player player;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getEntity().getType() != EntityType.CREEPER) {
            return;
        }
        Entity entity = event2.getDamager();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getDamager(...)");
        Entity damager = entity;
        if (damager instanceof Projectile) {
            ProjectileSource shooter = ((Projectile)damager).getShooter();
            player = shooter instanceof Player ? (Player)shooter : null;
            if (player == null) {
                return;
            }
        } else if (damager instanceof Player) {
            player = (Player)damager;
        } else {
            return;
        }
        Player player2 = player;
        this.runForAbility((Entity)player2, arg_0 -> ScareCreepers.onEntityDamageByEntity$lambda$0(this, arg_0));
    }

    @EventHandler
    public final void onEntityTargetLivingEntity(@NotNull EntityTargetLivingEntityEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getEntity().getType() == EntityType.CREEPER) {
            LivingEntity target = event2.getTarget();
            if (target == null) {
                return;
            }
            this.runForAbility((Entity)target, arg_0 -> ScareCreepers.onEntityTargetLivingEntity$lambda$0(event2, this, arg_0));
        }
    }

    private static final boolean fixCreeper$lambda$0(ScareCreepers this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this$0.hasAbility(player);
    }

    private static final boolean fixCreeper$lambda$1(Creeper $creeper, ScareCreepers this$0, LivingEntity livingEntity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        String string = (String)$creeper.getPersistentDataContainer().get(this$0.hitByPlayerKey, PersistentDataType.STRING);
        if (string != null) {
            String stored = string;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)stored, (Object)livingEntity.getUniqueId().toString());
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void onEntityDamageByEntity$lambda$0(ScareCreepers this$0, Player p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        p.getPersistentDataContainer().set(this$0.hitByPlayerKey, PersistentDataType.STRING, (Object)p.getUniqueId().toString());
    }

    private static final void onEntityTargetLivingEntity$lambda$0(EntityTargetLivingEntityEvent $event, ScareCreepers this$0, Player player) {
        String data = (String)$event.getEntity().getPersistentDataContainer().get(this$0.hitByPlayerKey, PersistentDataType.STRING);
        if (data == null) {
            $event.setCancelled(true);
            return;
        }
        Player player2 = player;
        Intrinsics.checkNotNull((Object)player2);
        if (!Intrinsics.areEqual((Object)data, (Object)player2.getUniqueId().toString())) {
            $event.setCancelled(true);
        }
    }
}

