/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.SavedPotionEffect;
import ru.turbovadim.ShortcutUtils;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0007R6\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lru/turbovadim/abilities/main/SwimSpeed;", "Lorg/bukkit/event/Listener;", "Lru/turbovadim/abilities/types/VisibleAbility;", "<init>", "()V", "storedEffects", "Ljava/util/HashMap;", "Lorg/bukkit/entity/Player;", "Lru/turbovadim/SavedPotionEffect;", "Lkotlin/collections/HashMap;", "getStoredEffects", "()Ljava/util/HashMap;", "setStoredEffects", "(Ljava/util/HashMap;)V", "onServerTickEnd", "", "event", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "onPlayerItemConsume", "Lorg/bukkit/event/player/PlayerItemConsumeEvent;", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "core"})
public final class SwimSpeed
implements Listener,
VisibleAbility {
    @NotNull
    private HashMap<Player, SavedPotionEffect> storedEffects = new HashMap();
    @NotNull
    private final Key key;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;

    public SwimSpeed() {
        Key key = Key.key("origins:swim_speed");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("Your underwater speed is increased.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Fins", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @NotNull
    public final HashMap<Player, SavedPotionEffect> getStoredEffects() {
        return this.storedEffects;
    }

    public final void setStoredEffects(@NotNull HashMap<Player, SavedPotionEffect> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.storedEffects = hashMap;
    }

    @EventHandler
    public final void onServerTickEnd(@NotNull ServerTickEndEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getTickNumber() % 6 != 0) {
            return;
        }
        int currentTick = Bukkit.getCurrentTick();
        PotionEffectType dolphinGrace = PotionEffectType.DOLPHINS_GRACE;
        for (Player player : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> SwimSpeed.onServerTickEnd$lambda$0(dolphinGrace, this, currentTick, arg_0));
        }
    }

    @EventHandler
    public final void onPlayerItemConsume(@NotNull PlayerItemConsumeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getItem().getType() == Material.MILK_BUCKET) {
            this.storedEffects.remove(event2.getPlayer());
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    private static final void onServerTickEnd$lambda$0(PotionEffectType $dolphinGrace, SwimSpeed this$0, int $currentTick, Player p) {
        block6: {
            PotionEffect original;
            int remainingTime;
            block5: {
                boolean showParticles;
                PotionEffect effect;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                if (!OriginsReforged.Companion.getNMSInvoker().isUnderWater((LivingEntity)p)) break block5;
                PotionEffect potionEffect = effect = p.getPotionEffect($dolphinGrace);
                boolean ambient = potionEffect != null ? potionEffect.isAmbient() : false;
                PotionEffect potionEffect2 = effect;
                boolean bl = potionEffect2 != null ? potionEffect2.hasParticles() : (showParticles = false);
                if (effect != null && !ShortcutUtils.INSTANCE.isInfinite(effect)) {
                    ((Map)this$0.storedEffects).put(p, new SavedPotionEffect(effect, $currentTick));
                    p.removePotionEffect($dolphinGrace);
                }
                p.addPotionEffect(new PotionEffect($dolphinGrace, ShortcutUtils.INSTANCE.infiniteDuration(), -1, ambient, showParticles));
                break block6;
            }
            if (p.hasPotionEffect($dolphinGrace)) {
                PotionEffect potionEffect = p.getPotionEffect($dolphinGrace);
                if (potionEffect != null) {
                    PotionEffect effect = potionEffect;
                    boolean bl = false;
                    if (ShortcutUtils.INSTANCE.isInfinite(effect)) {
                        p.removePotionEffect($dolphinGrace);
                    }
                }
            }
            SavedPotionEffect savedPotionEffect = this$0.storedEffects.remove(p);
            if (savedPotionEffect == null) break block6;
            SavedPotionEffect saved = savedPotionEffect;
            boolean bl = false;
            PotionEffect potionEffect = saved.effect;
            if (potionEffect != null && (remainingTime = (original = potionEffect).getDuration() - ($currentTick - saved.currentTime)) > 0) {
                p.addPotionEffect(new PotionEffect(original.getType(), remainingTime, original.getAmplifier(), original.isAmbient(), original.hasParticles()));
            }
        }
    }
}

