/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020 H\u0007J\u000e\u0010#\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020%H\u0007R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020,0+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.\u00a8\u00061"}, d2={"Lru/turbovadim/abilities/main/WaterBreathing;", "Lorg/bukkit/event/Listener;", "Lru/turbovadim/abilities/types/VisibleAbility;", "<init>", "()V", "onEntityAirChange", "", "event", "Lorg/bukkit/event/entity/EntityAirChangeEvent;", "onEntityPotionEffect", "Lorg/bukkit/event/entity/EntityPotionEffectEvent;", "hasWaterBreathing", "", "player", "Lorg/bukkit/entity/Player;", "airKey", "Lorg/bukkit/NamespacedKey;", "getAirKey", "()Lorg/bukkit/NamespacedKey;", "setAirKey", "(Lorg/bukkit/NamespacedKey;)V", "dehydrationKey", "getDehydrationKey", "setDehydrationKey", "damageKey", "getDamageKey", "setDamageKey", "breathingEffect", "Lorg/bukkit/potion/PotionEffect;", "onServerTickEnd", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "onPlayerDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "random", "Ljava/util/Random;", "decreaseAir", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "core"})
@SourceDebugExtension(value={"SMAP\nWaterBreathing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaterBreathing.kt\nru/turbovadim/abilities/main/WaterBreathing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1761#2,3:161\n1869#2,2:164\n1#3:166\n*S KotlinDebug\n*F\n+ 1 WaterBreathing.kt\nru/turbovadim/abilities/main/WaterBreathing\n*L\n59#1:161,3\n77#1:164,2\n*E\n"})
public final class WaterBreathing
implements Listener,
VisibleAbility {
    @NotNull
    private NamespacedKey airKey = new NamespacedKey((Plugin)OriginsReforged.Companion.getInstance(), "fullair");
    @NotNull
    private NamespacedKey dehydrationKey = new NamespacedKey((Plugin)OriginsReforged.Companion.getInstance(), "dehydrating");
    @NotNull
    private NamespacedKey damageKey = new NamespacedKey((Plugin)OriginsReforged.Companion.getInstance(), "ignore-item-damage");
    @NotNull
    private final PotionEffect breathingEffect = new PotionEffect(PotionEffectType.WATER_BREATHING, 200, 0, false, false, true);
    @NotNull
    private final Random random = new Random();
    @NotNull
    private final Key key;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;

    public WaterBreathing() {
        Key key = Key.key("origins:water_breathing");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("You can breathe underwater, but not on land.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Gills", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @EventHandler
    public final void onEntityAirChange(@NotNull EntityAirChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        this.runForAbility(entity, arg_0 -> WaterBreathing.onEntityAirChange$lambda$0(this, event2, arg_0));
    }

    @EventHandler
    public final void onEntityPotionEffect(@NotNull EntityPotionEffectEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getCause() != EntityPotionEffectEvent.Cause.TURTLE_HELMET) {
            return;
        }
        Entity entity = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        this.runForAbility(entity, arg_0 -> WaterBreathing.onEntityPotionEffect$lambda$0(event2, arg_0));
    }

    public final boolean hasWaterBreathing(@NotNull Player player) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Collection collection = player.getActivePotionEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActivePotionEffects(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PotionEffect it = (PotionEffect)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getType(), (Object)PotionEffectType.WATER_BREATHING) || Intrinsics.areEqual((Object)it.getType(), (Object)PotionEffectType.CONDUIT_POWER))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final NamespacedKey getAirKey() {
        return this.airKey;
    }

    public final void setAirKey(@NotNull NamespacedKey namespacedKey) {
        Intrinsics.checkNotNullParameter((Object)namespacedKey, (String)"<set-?>");
        this.airKey = namespacedKey;
    }

    @NotNull
    public final NamespacedKey getDehydrationKey() {
        return this.dehydrationKey;
    }

    public final void setDehydrationKey(@NotNull NamespacedKey namespacedKey) {
        Intrinsics.checkNotNullParameter((Object)namespacedKey, (String)"<set-?>");
        this.dehydrationKey = namespacedKey;
    }

    @NotNull
    public final NamespacedKey getDamageKey() {
        return this.damageKey;
    }

    public final void setDamageKey(@NotNull NamespacedKey namespacedKey) {
        Intrinsics.checkNotNullParameter((Object)namespacedKey, (String)"<set-?>");
        this.damageKey = namespacedKey;
    }

    @EventHandler
    public final void onServerTickEnd(@NotNull ServerTickEndEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)collection);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> WaterBreathing.onServerTickEnd$lambda$0$0(this, arg_0), arg_0 -> WaterBreathing.onServerTickEnd$lambda$0$1(this, arg_0));
        }
    }

    @EventHandler
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (((Number)event2.getPlayer().getPersistentDataContainer().getOrDefault(this.damageKey, PersistentDataType.INTEGER, (Object)0)).intValue() >= Bukkit.getCurrentTick()) {
            event2.deathMessage(event2.getPlayer().displayName().append(Component.text(" didn't manage to keep wet")));
        }
    }

    public final void decreaseAir(@NotNull Player player) {
        ItemMeta itemMeta;
        int respirationLevel;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.getInventory().getHelmet();
        int n = respirationLevel = itemStack != null && (itemMeta = itemStack.getItemMeta()) != null ? itemMeta.getEnchantLevel(OriginsReforged.Companion.getNMSInvoker().getRespirationEnchantment()) : 0;
        if (respirationLevel > 0 && this.random.nextInt(respirationLevel + 1) > 0) {
            return;
        }
        int n2 = player.getRemainingAir();
        player.setRemainingAir(n2 + -1);
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.getPlayer().getPersistentDataContainer().set(this.damageKey, PersistentDataType.INTEGER, (Object)-1);
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    private static final void onEntityAirChange$lambda$0(WaterBreathing this$0, EntityAirChangeEvent $event, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue((Object)persistentDataContainer, (String)"getPersistentDataContainer(...)");
        PersistentDataContainer pdc = persistentDataContainer;
        if (Intrinsics.areEqual((Object)pdc.get(this$0.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN()), (Object)true) || Intrinsics.areEqual((Object)pdc.get(this$0.dehydrationKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN()), (Object)true)) {
            return;
        }
        int newAir = player.getRemainingAir() - $event.getAmount();
        boolean underwater = player.isUnderWater();
        boolean waterBreathing = this$0.hasWaterBreathing(player);
        $event.setCancelled(newAir > 0 && (underwater || waterBreathing) || newAir <= 0 && !underwater && !waterBreathing);
    }

    private static final void onEntityPotionEffect$lambda$0(EntityPotionEffectEvent $event, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.setCancelled(true);
    }

    private static final void onServerTickEnd$lambda$0$0(WaterBreathing this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean underwater = player.isUnderWater();
        boolean waterBreathing = this$0.hasWaterBreathing(player);
        boolean inRain = player.isInRain();
        if (underwater || waterBreathing || inRain) {
            ItemStack itemStack = player.getInventory().getHelmet();
            if (itemStack != null) {
                ItemStack itemStack2;
                ItemStack itemStack3;
                ItemStack it = itemStack3 = itemStack;
                boolean bl = false;
                Object object = itemStack2 = underwater && it.getType() == Material.TURTLE_HELMET ? itemStack3 : null;
                if (itemStack2 != null) {
                    it = itemStack2;
                    boolean bl2 = false;
                    player.addPotionEffect(this$0.breathingEffect);
                }
            }
            if (Intrinsics.areEqual((Object)player.getPersistentDataContainer().get(this$0.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN()), (Object)true)) {
                player.setRemainingAir(-50);
                return;
            }
            player.setRemainingAir((int)Math.min(Math.max((double)(player.getRemainingAir() + 4), 4.0), (double)player.getMaximumAir()));
            if (player.getRemainingAir() == player.getMaximumAir()) {
                player.setRemainingAir(-50);
                player.getPersistentDataContainer().set(this$0.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN(), (Object)true);
            }
        } else {
            if (Intrinsics.areEqual((Object)player.getPersistentDataContainer().get(this$0.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN()), (Object)true)) {
                player.setRemainingAir(player.getMaximumAir());
                player.getPersistentDataContainer().set(this$0.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN(), (Object)false);
            }
            this$0.decreaseAir(player);
            if (player.getRemainingAir() < -25) {
                player.getPersistentDataContainer().set(this$0.dehydrationKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN(), (Object)true);
                player.setRemainingAir(-5);
                player.getPersistentDataContainer().set(this$0.dehydrationKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN(), (Object)false);
                player.getPersistentDataContainer().set(this$0.damageKey, PersistentDataType.INTEGER, (Object)Bukkit.getCurrentTick());
                OriginsReforged.Companion.getNMSInvoker().dealDrowningDamage((LivingEntity)player, 2);
            }
        }
    }

    private static final void onServerTickEnd$lambda$0$1(WaterBreathing this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.getPersistentDataContainer().has(this$0.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN())) {
            player.setRemainingAir(player.getMaximumAir());
            player.getPersistentDataContainer().remove(this$0.airKey);
        }
    }
}

