/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.main;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.SavedPotionEffect;
import ru.turbovadim.ShortcutUtils;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0007R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lru/turbovadim/abilities/main/WaterVision;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "storedEffects", "", "Lorg/bukkit/entity/Player;", "Lru/turbovadim/SavedPotionEffect;", "getStoredEffects", "()Ljava/util/Map;", "setStoredEffects", "(Ljava/util/Map;)V", "onServerTickEnd", "", "event", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "onPlayerItemConsume", "Lorg/bukkit/event/player/PlayerItemConsumeEvent;", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "core"})
@SourceDebugExtension(value={"SMAP\nWaterVision.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaterVision.kt\nru/turbovadim/abilities/main/WaterVision\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1869#2,2:88\n*S KotlinDebug\n*F\n+ 1 WaterVision.kt\nru/turbovadim/abilities/main/WaterVision\n*L\n28#1:88,2\n*E\n"})
public final class WaterVision
implements VisibleAbility,
Listener {
    @NotNull
    private Map<Player, SavedPotionEffect> storedEffects = new HashMap();
    @NotNull
    private final Key key;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;

    public WaterVision() {
        Key key = Key.key("origins:water_vision");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("Your vision underwater is perfect.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Wet Eyes", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @NotNull
    public final Map<Player, SavedPotionEffect> getStoredEffects() {
        return this.storedEffects;
    }

    public final void setStoredEffects(@NotNull Map<Player, SavedPotionEffect> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.storedEffects = map;
    }

    @EventHandler
    public final void onServerTickEnd(@Nullable ServerTickEndEvent event2) {
        int currentTick = Bukkit.getCurrentTick();
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> WaterVision.onServerTickEnd$lambda$0$0(this, currentTick, arg_0));
        }
    }

    @EventHandler
    public final void onPlayerItemConsume(@NotNull PlayerItemConsumeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getItem().getType() == Material.MILK_BUCKET) {
            this.storedEffects.remove(event2.getPlayer());
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    private static final void onServerTickEnd$lambda$0$0(WaterVision this$0, int $currentTick, Player player) {
        block5: {
            PotionEffect potionEffect;
            int remainingDuration;
            block4: {
                boolean showParticles;
                PotionEffect currentEffect2;
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                if (!OriginsReforged.Companion.getNMSInvoker().isUnderWater((LivingEntity)player)) break block4;
                PotionEffect potionEffect2 = currentEffect2 = player.getPotionEffect(PotionEffectType.NIGHT_VISION);
                boolean ambient = potionEffect2 != null ? potionEffect2.isAmbient() : false;
                PotionEffect potionEffect3 = currentEffect2;
                boolean bl = potionEffect3 != null ? potionEffect3.hasParticles() : (showParticles = false);
                if (currentEffect2 != null && !ShortcutUtils.INSTANCE.isInfinite(currentEffect2)) {
                    this$0.storedEffects.put(player, new SavedPotionEffect(currentEffect2, $currentTick));
                    player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                }
                player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, ShortcutUtils.INSTANCE.infiniteDuration(), -1, ambient, showParticles));
                break block5;
            }
            PotionEffect potionEffect4 = player.getPotionEffect(PotionEffectType.NIGHT_VISION);
            if (potionEffect4 != null) {
                PotionEffect effect = potionEffect4;
                boolean bl = false;
                if (ShortcutUtils.INSTANCE.isInfinite(effect)) {
                    player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                }
            }
            SavedPotionEffect savedPotionEffect = this$0.storedEffects.remove(player);
            if (savedPotionEffect == null) break block5;
            SavedPotionEffect saved = savedPotionEffect;
            boolean bl = false;
            PotionEffect potionEffect5 = saved.effect;
            if (potionEffect5 != null && (remainingDuration = (potionEffect = potionEffect5).getDuration() - ($currentTick - saved.currentTime)) > 0) {
                player.addPotionEffect(new PotionEffect(potionEffect.getType(), remainingDuration, potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles()));
            }
        }
    }
}

