/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.mobs;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lru/turbovadim/abilities/mobs/ItemCollector;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "pickUpItem", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/entity/Item;", "onServerTickEnd", "event", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nItemCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemCollector.kt\nru/turbovadim/abilities/mobs/ItemCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1869#2,2:54\n1869#2,2:56\n808#2,11:58\n774#2:69\n865#2,2:70\n1869#2,2:72\n*S KotlinDebug\n*F\n+ 1 ItemCollector.kt\nru/turbovadim/abilities/mobs/ItemCollector\n*L\n33#1:54,2\n43#1:56,2\n46#1:58,11\n47#1:69\n47#1:70,2\n48#1:72,2\n*E\n"})
public final class ItemCollector
implements VisibleAbility,
Listener {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("You have a larger item pickup radius.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Item Collector", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;

    public ItemCollector() {
        Key key = Key.key("moborigins:item_collector");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    private final void pickUpItem(Player player, Item item) {
        EntityPickupItemEvent pickupEvent = new EntityPickupItemEvent((LivingEntity)player, item, 0);
        if (!pickupEvent.callEvent()) {
            return;
        }
        ItemStack[] itemStackArray = new ItemStack[]{item.getItemStack()};
        HashMap hashMap = player.getInventory().addItem(itemStackArray);
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"addItem(...)");
        HashMap remainingItems = hashMap;
        if (remainingItems.isEmpty()) {
            player.playPickupItemAnimation(item);
            item.remove();
        } else {
            Collection collection = remainingItems.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack remainingStack = (ItemStack)element$iv;
                boolean bl = false;
                int pickedUpAmount = item.getItemStack().getAmount() - remainingStack.getAmount();
                player.playPickupItemAnimation(item, pickedUpAmount);
                item.setItemStack(remainingStack);
            }
        }
    }

    @EventHandler
    public final void onServerTickEnd(@Nullable ServerTickEndEvent event2) {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> ItemCollector.onServerTickEnd$lambda$0$0(player, this, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void onServerTickEnd$lambda$0$0(Player $player, ItemCollector this$0, Player it) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = $player.getNearbyEntities(2.5, 2.5, 2.5);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNearbyEntities(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Item)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Item it2 = (Item)element$iv$iv;
            boolean bl = false;
            if (!(it2.canPlayerPickup() && it2.getPickupDelay() <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Item it3 = (Item)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$player);
            this$0.pickUpItem($player, it3);
        }
    }
}

