/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.mobs;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.AttributeModifierAbility;
import ru.turbovadim.abilities.types.BreakSpeedModifierAbility;
import ru.turbovadim.abilities.types.FlightAllowingAbility;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lru/turbovadim/abilities/mobs/LavaWalk;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lru/turbovadim/abilities/types/FlightAllowingAbility;", "Lru/turbovadim/abilities/types/AttributeModifierAbility;", "Lru/turbovadim/abilities/types/BreakSpeedModifierAbility;", "<init>", "()V", "canFly", "", "player", "Lorg/bukkit/entity/Player;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "attribute", "Lorg/bukkit/attribute/Attribute;", "getAttribute", "()Lorg/bukkit/attribute/Attribute;", "amount", "", "getAmount", "()D", "operation", "Lorg/bukkit/attribute/AttributeModifier$Operation;", "getOperation", "()Lorg/bukkit/attribute/AttributeModifier$Operation;", "provideContextFor", "Lru/turbovadim/abilities/types/BreakSpeedModifierAbility$BlockMiningContext;", "shouldActivate", "getFlightSpeed", "", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "core"})
public final class LavaWalk
implements VisibleAbility,
FlightAllowingAbility,
AttributeModifierAbility,
BreakSpeedModifierAbility {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("You have the ability to walk on lava source blocks! You are also quicker while walking on lava, and slower on land.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Lava Walker", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Attribute attribute = OriginsReforged.Companion.getNMSInvoker().getMovementSpeedAttribute();
    private final double amount;
    @NotNull
    private final AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_NUMBER;
    @NotNull
    private final Key key;

    public LavaWalk() {
        Key key = Key.key("moborigins:lava_walk");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
    }

    @Override
    public boolean canFly(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!player.isInLava()) {
            return false;
        }
        if (player.getAllowFlight()) {
            player.setFlying(true);
        }
        if (!player.isSneaking()) {
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            Location location2 = location;
            double fractionalY = location2.getY() - Math.floor(location2.getY());
            Block block = location2.getBlock().getRelative(BlockFace.UP);
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getRelative(...)");
            Block blockAbove = block;
            if (blockAbove.getType() == Material.LAVA || fractionalY + 0.1 < 0.65) {
                player.teleport(location2.add(0.0, 0.1, 0.0));
            } else if (0.65 - fractionalY > 0.04) {
                Location location3;
                Location $this$canFly_u24lambda_u240 = location3 = location2.clone();
                boolean bl = false;
                $this$canFly_u24lambda_u240.setY(Math.floor($this$canFly_u24lambda_u240.getY()) + 0.65);
                Location location4 = location3;
                Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"apply(...)");
                Location newLocation = location4;
                player.teleport(newLocation);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    @NotNull
    public AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    @Override
    @NotNull
    public BreakSpeedModifierAbility.BlockMiningContext provideContextFor(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        return new BreakSpeedModifierAbility.BlockMiningContext(itemStack, player.getPotionEffect(OriginsReforged.Companion.getNMSInvoker().getMiningFatigueEffect()), player.getPotionEffect(OriginsReforged.Companion.getNMSInvoker().getHasteEffect()), player.getPotionEffect(PotionEffectType.CONDUIT_POWER), false, false, true);
    }

    @Override
    public boolean shouldActivate(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.isInLava();
    }

    @Override
    public float getFlightSpeed(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return 0.1f;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }
}

