/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.mobs;

import com.destroystokyo.paper.entity.ai.Goal;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0019H\u0007J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lru/turbovadim/abilities/mobs/PillagerAligned;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "onEntityTargetLivingEntity", "", "event", "Lorg/bukkit/event/entity/EntityTargetLivingEntityEvent;", "onPlayerInteractAtEntity", "Lorg/bukkit/event/player/PlayerInteractEntityEvent;", "onEntitySpawn", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "onEntitiesLoad", "Lorg/bukkit/event/world/EntitiesLoadEvent;", "fixGolem", "golem", "Lorg/bukkit/entity/IronGolem;", "core"})
public final class PillagerAligned
implements VisibleAbility,
Listener {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("Villagers don't like you, and pillagers like you!", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Pillager Aligned", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;

    public PillagerAligned() {
        Key key = Key.key("moborigins:pillager_aligned");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onEntityTargetLivingEntity(@NotNull EntityTargetLivingEntityEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getEntity().getType() == EntityType.PILLAGER) {
            LivingEntity livingEntity = event2.getTarget();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            this.runForAbility((Entity)target, arg_0 -> PillagerAligned.onEntityTargetLivingEntity$lambda$0(event2, arg_0));
        }
    }

    @EventHandler
    public final void onPlayerInteractAtEntity(@NotNull PlayerInteractEntityEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getRightClicked();
        Villager villager = entity instanceof Villager ? (Villager)entity : null;
        if (villager == null) {
            return;
        }
        Villager villager2 = villager;
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.runForAbility((Entity)player, arg_0 -> PillagerAligned.onPlayerInteractAtEntity$lambda$0(event2, villager2, arg_0));
    }

    @EventHandler
    public final void onEntitySpawn(@NotNull EntitySpawnEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getEntity();
        IronGolem ironGolem = entity instanceof IronGolem ? (IronGolem)entity : null;
        if (ironGolem == null) {
            return;
        }
        IronGolem golem = ironGolem;
        this.fixGolem(golem);
    }

    @EventHandler
    public final void onEntitiesLoad(@NotNull EntitiesLoadEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        for (Entity entity : event2.getEntities()) {
            if (!(entity instanceof IronGolem)) continue;
            this.fixGolem((IronGolem)entity);
        }
    }

    public final void fixGolem(@NotNull IronGolem golem) {
        Intrinsics.checkNotNullParameter((Object)golem, (String)"golem");
        Goal<Mob> goal = OriginsReforged.Companion.getNMSInvoker().getIronGolemAttackGoal((LivingEntity)golem, arg_0 -> PillagerAligned.fixGolem$lambda$0(this, arg_0));
        Bukkit.getMobGoals().addGoal((Mob)golem, 3, goal);
    }

    private static final void onEntityTargetLivingEntity$lambda$0(EntityTargetLivingEntityEvent $event, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.setCancelled(true);
    }

    private static final void onPlayerInteractAtEntity$lambda$0(PlayerInteractEntityEvent $event, Villager $villager, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.setCancelled(true);
        $villager.shakeHead();
    }

    private static final boolean fixGolem$lambda$0(PillagerAligned this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this$0.hasAbility(player);
    }
}

