/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.mobs;

import io.papermc.paper.event.entity.EntityMoveEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;
import ru.turbovadim.cooldowns.CooldownAbility;
import ru.turbovadim.cooldowns.Cooldowns;
import ru.turbovadim.events.PlayerLeftClickEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001cH\u0007J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020(H\u0007J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020*H\u0007R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R*\u0010$\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lru/turbovadim/abilities/mobs/Split;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "Lru/turbovadim/cooldowns/CooldownAbility;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "onPlayerLeftClick", "", "event", "Lru/turbovadim/events/PlayerLeftClickEvent;", "getPlayerFromSlime", "Lorg/bukkit/entity/Player;", "slime", "Lorg/bukkit/entity/Entity;", "slimeKey", "Lorg/bukkit/NamespacedKey;", "onEntityTargetLivingEntity", "Lorg/bukkit/event/entity/EntityTargetLivingEntityEvent;", "lastHitEntity", "", "Lorg/bukkit/entity/LivingEntity;", "getLastHitEntity", "()Ljava/util/Map;", "setLastHitEntity", "(Ljava/util/Map;)V", "targetEntity", "getTargetEntity", "setTargetEntity", "onEntityDamageByEntity", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onEntityMove", "Lio/papermc/paper/event/entity/EntityMoveEvent;", "cooldownInfo", "Lru/turbovadim/cooldowns/Cooldowns$CooldownInfo;", "getCooldownInfo", "()Lru/turbovadim/cooldowns/Cooldowns$CooldownInfo;", "core"})
public final class Split
implements VisibleAbility,
Listener,
CooldownAbility {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("Turn your food points into a small slime to defend you!", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Split Ability", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;
    @NotNull
    private final NamespacedKey slimeKey;
    @NotNull
    private Map<Player, LivingEntity> lastHitEntity;
    @NotNull
    private Map<Entity, LivingEntity> targetEntity;
    @NotNull
    private final Cooldowns.CooldownInfo cooldownInfo;

    public Split() {
        Key key = Key.key("moborigins:split");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.slimeKey = new NamespacedKey((Plugin)OriginsReforged.Companion.getInstance(), "slime-target");
        this.lastHitEntity = new LinkedHashMap();
        this.targetEntity = new LinkedHashMap();
        this.cooldownInfo = new Cooldowns.CooldownInfo(600, "split", false, false, 12, null);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onPlayerLeftClick(@NotNull PlayerLeftClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)((Object)event2), (String)"event");
        if (event2.getItem() != null) {
            return;
        }
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        if (player2.getFoodLevel() < 8) {
            return;
        }
        this.runForAbility((Entity)player2, arg_0 -> Split.onPlayerLeftClick$lambda$0(this, player2, arg_0));
    }

    private final Player getPlayerFromSlime(Entity slime) {
        String string = (String)slime.getPersistentDataContainer().get(this.slimeKey, PersistentDataType.STRING);
        if (string == null) {
            return null;
        }
        String s = string;
        return Bukkit.getPlayer((UUID)UUID.fromString(s));
    }

    @EventHandler
    public final void onEntityTargetLivingEntity(@NotNull EntityTargetLivingEntityEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getReason() == EntityTargetEvent.TargetReason.CUSTOM) {
            return;
        }
        Entity entity = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        Entity entity2 = entity;
        if (!entity2.getPersistentDataContainer().has(this.slimeKey)) {
            return;
        }
        String string = (String)entity2.getPersistentDataContainer().get(this.slimeKey, PersistentDataType.STRING);
        if (string == null) {
            return;
        }
        String s = string;
        LivingEntity livingEntity = event2.getTarget();
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(s));
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(...)");
        OfflinePlayer offlinePlayer2 = offlinePlayer;
        if (Intrinsics.areEqual((Object)offlinePlayer2.getUniqueId(), (Object)target.getUniqueId())) {
            Player slimePlayer = this.getPlayerFromSlime(entity2);
            LivingEntity lastHit = this.lastHitEntity.get(slimePlayer);
            event2.setTarget((Entity)lastHit);
            this.targetEntity.put(entity2, lastHit);
        }
    }

    @NotNull
    public final Map<Player, LivingEntity> getLastHitEntity() {
        return this.lastHitEntity;
    }

    public final void setLastHitEntity(@NotNull Map<Player, LivingEntity> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.lastHitEntity = map;
    }

    @NotNull
    public final Map<Entity, LivingEntity> getTargetEntity() {
        return this.targetEntity;
    }

    public final void setTargetEntity(@NotNull Map<Entity, LivingEntity> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.targetEntity = map;
    }

    @EventHandler
    public final void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event2) {
        Player player;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getDamager().getPersistentDataContainer().has(this.slimeKey)) {
            Entity entity = event2.getDamager();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getDamager(...)");
            Player player2 = this.getPlayerFromSlime(entity);
            if (player2 == null) {
                return;
            }
            Player playerFromSlime = player2;
            if (Intrinsics.areEqual((Object)event2.getEntity().getUniqueId(), (Object)playerFromSlime.getUniqueId())) {
                event2.setCancelled(true);
            }
        }
        Entity entity = event2.getDamager();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getDamager(...)");
        Entity damager = entity;
        if (damager instanceof Player) {
            player = (Player)damager;
        } else if (damager instanceof Projectile) {
            ProjectileSource shooter = ((Projectile)damager).getShooter();
            player = shooter instanceof Player ? (Player)shooter : null;
            if (player == null) {
                return;
            }
        } else {
            return;
        }
        Player player3 = player;
        if (event2.getEntity() instanceof LivingEntity) {
            this.lastHitEntity.put(player3, (LivingEntity)event2.getEntity());
        }
    }

    @EventHandler
    public final void onEntityMove(@NotNull EntityMoveEvent event2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            LivingEntity livingEntity = event2.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
            LivingEntity slime = livingEntity;
            if (slime.getType() != EntityType.SLIME || !slime.getPersistentDataContainer().has(this.slimeKey)) {
                return;
            }
            LivingEntity livingEntity2 = this.targetEntity.get(slime);
            if (livingEntity2 == null) break block2;
            LivingEntity target = livingEntity2;
            boolean bl = false;
            if (target.getLocation().distance(slime.getLocation()) <= 1.0) {
                slime.attack((Entity)target);
            }
        }
    }

    @Override
    @NotNull
    public Cooldowns.CooldownInfo getCooldownInfo() {
        return this.cooldownInfo;
    }

    private static final void onPlayerLeftClick$lambda$0(Split this$0, Player $player, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.hasCooldown($player)) {
            return;
        }
        this$0.setCooldown($player);
        $player.setFoodLevel($player.getFoodLevel() - 8);
        Entity entity = $player.getWorld().spawnEntity($player.getLocation(), EntityType.SLIME);
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type org.bukkit.entity.Slime");
        Slime slime = (Slime)entity;
        slime.setSize(2);
        slime.getPersistentDataContainer().set(this$0.slimeKey, PersistentDataType.STRING, (Object)$player.getUniqueId().toString());
    }
}

