/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.mobs;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/turbovadim/abilities/mobs/StrongerSnowballs;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "strongSnowballKey", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/Nullable;", "onProjectileLaunch", "", "event", "Lorg/bukkit/event/entity/ProjectileLaunchEvent;", "onProjectileHit", "Lorg/bukkit/event/entity/ProjectileHitEvent;", "core"})
public final class StrongerSnowballs
implements VisibleAbility,
Listener {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("Snowballs you throw are packed with ice, and deal 1 damage!", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Stronger Snowballs", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;
    @NotNull
    private final NamespacedKey strongSnowballKey;

    public StrongerSnowballs() {
        Key key = Key.key("moborigins:stronger_snowballs");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)"strong-snowball");
        Intrinsics.checkNotNull((Object)namespacedKey);
        this.strongSnowballKey = namespacedKey;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onProjectileLaunch(@NotNull ProjectileLaunchEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getEntity().getType() != EntityType.SNOWBALL) {
            return;
        }
        ProjectileSource projectileSource = event2.getEntity().getShooter();
        Player player = projectileSource instanceof Player ? (Player)projectileSource : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        this.runForAbility((Entity)player2, arg_0 -> StrongerSnowballs.onProjectileLaunch$lambda$0(event2, this, arg_0));
    }

    @EventHandler
    public final void onProjectileHit(@NotNull ProjectileHitEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getHitEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity targetEntity = livingEntity;
        Projectile projectile = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)projectile, (String)"getEntity(...)");
        Projectile projectile2 = projectile;
        boolean isStrongSnowball = Intrinsics.areEqual((Object)projectile2.getPersistentDataContainer().get(this.strongSnowballKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN()), (Object)true);
        if (isStrongSnowball) {
            OriginsReforged.Companion.getNMSInvoker().dealFreezeDamage(targetEntity, 1);
            Vector vector = projectile2.getVelocity();
            Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getVelocity(...)");
            Vector vector2 = vector;
            OriginsReforged.Companion.getNMSInvoker().knockback(targetEntity, 0.5, -vector2.getX(), -vector2.getZ());
        }
    }

    private static final void onProjectileLaunch$lambda$0(ProjectileLaunchEvent $event, StrongerSnowballs this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.getEntity().getPersistentDataContainer().set(this$0.strongSnowballKey, (PersistentDataType)OriginSwapper.BooleanPDT.Companion.getBOOLEAN(), (Object)true);
    }
}

