/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.mobs;

import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.AttributeModifierAbility;
import ru.turbovadim.abilities.types.VisibleAbility;
import ru.turbovadim.cooldowns.CooldownAbility;
import ru.turbovadim.cooldowns.Cooldowns;
import ru.turbovadim.events.PlayerLeftClickEvent;
import ru.turbovadim.packetsenders.NMSInvoker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\"H\u0007J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020(H\u0007J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020%H\u0016J\u0010\u00103\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000204H\u0007J\u0010\u00105\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000206H\u0007J\u001e\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020>2\u0006\u00102\u001a\u00020%R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0006\u0012\u0004\u0018\u00010&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00107\u001a\u000208X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010?\u001a\u00020@X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010B\u00a8\u0006C"}, d2={"Lru/turbovadim/abilities/mobs/TridentExpert;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "Lru/turbovadim/abilities/types/AttributeModifierAbility;", "Lru/turbovadim/cooldowns/CooldownAbility;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "riptideKey", "Lorg/bukkit/NamespacedKey;", "fixTrident", "Lorg/bukkit/inventory/ItemStack;", "item", "onPlayerStopUsingItem", "", "event", "Lio/papermc/paper/event/player/PlayerStopUsingItemEvent;", "onPlayerLeave", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerItemHeld", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "onPlayerInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onPlayerDropItem", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "lastTridentEnabledTime", "", "Lorg/bukkit/entity/Player;", "", "onPlayerLeftClick", "Lru/turbovadim/events/PlayerLeftClickEvent;", "attribute", "Lorg/bukkit/attribute/Attribute;", "getAttribute", "()Lorg/bukkit/attribute/Attribute;", "amount", "", "getAmount", "()D", "getChangedAmount", "player", "onProjectileLaunch", "Lorg/bukkit/event/entity/ProjectileLaunchEvent;", "onProjectileHit", "Lorg/bukkit/event/entity/ProjectileHitEvent;", "operation", "Lorg/bukkit/attribute/AttributeModifier$Operation;", "getOperation", "()Lorg/bukkit/attribute/AttributeModifier$Operation;", "releaseUsing", "stack", "world", "Lorg/bukkit/World;", "cooldownInfo", "Lru/turbovadim/cooldowns/Cooldowns$CooldownInfo;", "getCooldownInfo", "()Lru/turbovadim/cooldowns/Cooldowns$CooldownInfo;", "core"})
public final class TridentExpert
implements VisibleAbility,
Listener,
AttributeModifierAbility,
CooldownAbility {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("You're a master of the trident, dealing +2 damage when you throw it, and +2 melee damage with it. You can also use channeling without thunder, and use riptide without rain/water at the price of extra durability.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Trident Expert", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;
    @NotNull
    private final NamespacedKey riptideKey;
    @NotNull
    private final Map<Player, Integer> lastTridentEnabledTime;
    @NotNull
    private final Attribute attribute;
    private final double amount;
    @NotNull
    private final AttributeModifier.Operation operation;
    @NotNull
    private final Cooldowns.CooldownInfo cooldownInfo;

    public TridentExpert() {
        Key key = Key.key("moborigins:trident_expert");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.riptideKey = new NamespacedKey((Plugin)OriginsReforged.Companion.getInstance(), "riptide-trident");
        this.lastTridentEnabledTime = new HashMap();
        this.attribute = Attribute.GENERIC_ATTACK_DAMAGE;
        this.operation = AttributeModifier.Operation.ADD_NUMBER;
        this.cooldownInfo = new Cooldowns.CooldownInfo(400, "trident_expert", true, false, 8, null);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Nullable
    public final ItemStack fixTrident(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        if (item.getItemMeta() == null) {
            return item;
        }
        if (item.getItemMeta().getPersistentDataContainer().has(this.riptideKey)) {
            ItemMeta meta = item.getItemMeta();
            Object object = item.getItemMeta().getPersistentDataContainer().getOrDefault(this.riptideKey, PersistentDataType.INTEGER, (Object)1);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            int level = ((Number)object).intValue();
            meta.getPersistentDataContainer().remove(this.riptideKey);
            meta.addEnchant(Enchantment.RIPTIDE, level, false);
            meta.removeEnchant(Enchantment.FROST_WALKER);
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public final void onPlayerStopUsingItem(@NotNull PlayerStopUsingItemEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getItem().getType() != Material.TRIDENT) {
            return;
        }
        if (event2.getTicksHeldFor() >= 10 && event2.getItem().getItemMeta().getPersistentDataContainer().has(this.riptideKey)) {
            ItemStack itemStack = this.fixTrident(event2.getItem());
            Intrinsics.checkNotNull((Object)itemStack);
            World world = event2.getPlayer().getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            Player player = event2.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.releaseUsing(itemStack, world, player);
            NMSInvoker nMSInvoker = OriginsReforged.Companion.getNMSInvoker();
            ItemStack itemStack2 = event2.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItem(...)");
            Player player2 = event2.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
            nMSInvoker.damageItem(itemStack2, 10, player2);
        } else {
            this.fixTrident(event2.getItem());
        }
    }

    @EventHandler
    public final void onPlayerLeave(@NotNull PlayerJoinEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.fixTrident(event2.getPlayer().getInventory().getItemInMainHand());
        this.fixTrident(event2.getPlayer().getInventory().getItemInOffHand());
    }

    @EventHandler
    public final void onPlayerItemHeld(@NotNull PlayerItemHeldEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ItemStack item = event2.getPlayer().getInventory().getItem(event2.getPreviousSlot());
        if (item != null && item.getType() == Material.TRIDENT) {
            this.fixTrident(item);
        }
    }

    @EventHandler
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event2) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (event2.getPlayer().isInWaterOrRainOrBubbleColumn()) {
                    return;
                }
                int n = Bukkit.getCurrentTick();
                Integer n2 = this.lastTridentEnabledTime.getOrDefault(event2.getPlayer(), Bukkit.getCurrentTick() - 400);
                Intrinsics.checkNotNull((Object)n2);
                if (n - ((Number)n2).intValue() >= 400) {
                    return;
                }
                if (event2.getItem() == null) break block7;
                ItemStack itemStack = event2.getItem();
                Intrinsics.checkNotNull((Object)itemStack);
                if (itemStack.getType() == Material.TRIDENT) break block8;
            }
            return;
        }
        ItemStack itemStack = event2.getItem();
        Intrinsics.checkNotNull((Object)itemStack);
        if (!itemStack.getItemMeta().hasEnchant(Enchantment.RIPTIDE)) {
            return;
        }
        ItemStack itemStack2 = event2.getItem();
        Intrinsics.checkNotNull((Object)itemStack2);
        ItemMeta meta = itemStack2.getItemMeta();
        ItemStack itemStack3 = event2.getItem();
        Intrinsics.checkNotNull((Object)itemStack3);
        itemStack3.setItemMeta(meta);
        meta.getPersistentDataContainer().set(this.riptideKey, PersistentDataType.INTEGER, (Object)meta.getEnchantLevel(Enchantment.RIPTIDE));
        meta.removeEnchant(Enchantment.RIPTIDE);
        if (meta.getEnchants().isEmpty()) {
            meta.addEnchant(Enchantment.FROST_WALKER, 1, true);
        }
        ItemStack itemStack4 = event2.getItem();
        Intrinsics.checkNotNull((Object)itemStack4);
        itemStack4.setItemMeta(meta);
    }

    @EventHandler
    public final void onPlayerDropItem(@NotNull PlayerDropItemEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Item item = event2.getItemDrop();
        ItemStack itemStack = this.fixTrident(event2.getItemDrop().getItemStack());
        Intrinsics.checkNotNull((Object)itemStack);
        item.setItemStack(itemStack);
    }

    @EventHandler
    public final void onPlayerLeftClick(@NotNull PlayerLeftClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)((Object)event2), (String)"event");
        Object[] objectArray = new Material[]{Material.AIR, Material.TRIDENT};
        if (CollectionsKt.listOf((Object[])objectArray).contains(event2.getPlayer().getInventory().getItemInMainHand().getType())) {
            Player player = event2.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.runForAbility((Entity)player, arg_0 -> TridentExpert.onPlayerLeftClick$lambda$0(this, event2, arg_0));
        }
    }

    @Override
    @NotNull
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double getChangedAmount(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.getInventory().getItemInMainHand().getType() != Material.TRIDENT) return 0.0;
        int n = Bukkit.getCurrentTick();
        Integer n2 = this.lastTridentEnabledTime.getOrDefault(player, Bukkit.getCurrentTick() - 400);
        Intrinsics.checkNotNull((Object)n2);
        if (n - ((Number)n2).intValue() >= 400) return 0.0;
        return 2.0;
    }

    @EventHandler
    public final void onProjectileLaunch(@NotNull ProjectileLaunchEvent event2) {
        Player player;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ProjectileSource projectileSource = event2.getEntity().getShooter();
        Player player2 = player = projectileSource instanceof Player ? (Player)projectileSource : null;
        if (player != null) {
            Trident trident;
            Projectile projectile = event2.getEntity();
            Trident trident2 = trident = projectile instanceof Trident ? (Trident)projectile : null;
            if (trident != null) {
                this.runForAbility((Entity)player, arg_0 -> TridentExpert.onProjectileLaunch$lambda$0(this, player, trident, arg_0));
            }
        }
    }

    @EventHandler
    public final void onProjectileHit(@NotNull ProjectileHitEvent event2) {
        Trident trident;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getHitEntity() == null) {
            return;
        }
        ProjectileSource projectileSource = event2.getEntity().getShooter();
        Player player = projectileSource instanceof Player ? (Player)projectileSource : null;
        Projectile projectile = event2.getEntity();
        Trident trident2 = trident = projectile instanceof Trident ? (Trident)projectile : null;
        if (player != null && trident != null) {
            this.runForAbility((Entity)player, arg_0 -> TridentExpert.onProjectileHit$lambda$0(this, player, trident, event2, arg_0));
        }
    }

    @Override
    @NotNull
    public AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    public final void releaseUsing(@NotNull ItemStack stack, @NotNull World world, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int k = stack.getEnchantmentLevel(Enchantment.RIPTIDE);
        if (k > 0) {
            PlayerRiptideEvent event2 = new PlayerRiptideEvent(player, stack);
            event2.getPlayer().getServer().getPluginManager().callEvent((Event)event2);
            float f = player.getLocation().getYaw();
            float f1 = player.getLocation().getPitch();
            double f2 = -Math.sin(f * ((float)Math.PI / 180)) * Math.cos(f1 * ((float)Math.PI / 180));
            double f3 = -Math.sin(f1 * ((float)Math.PI / 180));
            double f4 = Math.cos(f * ((float)Math.PI / 180)) * Math.cos(f1 * ((float)Math.PI / 180));
            double f5 = Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
            float f6 = 3.0f * ((1.0f + (float)k) / 4.0f);
            f2 *= (double)f6 / f5;
            f3 *= (double)f6 / f5;
            f4 *= (double)f6 / f5;
            if (player.isOnGround()) {
                OriginsReforged.Companion.getNMSInvoker().tridentMove(player);
            }
            player.setVelocity(player.getVelocity().add(new Vector(f2, f3, f4)));
            OriginsReforged.Companion.getNMSInvoker().startAutoSpinAttack(player, 20, 8.0f, stack);
            Sound soundeffect = k >= 3 ? Sound.ITEM_TRIDENT_RIPTIDE_3 : (k == 2 ? Sound.ITEM_TRIDENT_RIPTIDE_2 : Sound.ITEM_TRIDENT_RIPTIDE_1);
            world.playSound(player.getLocation(), soundeffect, 1.0f, 1.0f);
        }
    }

    @Override
    @NotNull
    public Cooldowns.CooldownInfo getCooldownInfo() {
        return this.cooldownInfo;
    }

    private static final void onPlayerLeftClick$lambda$0(TridentExpert this$0, PlayerLeftClickEvent $event, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Player player = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        if (this$0.hasCooldown(player)) {
            return;
        }
        Player player2 = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
        this$0.setCooldown(player2);
        this$0.lastTridentEnabledTime.put($event.getPlayer(), Bukkit.getCurrentTick());
    }

    private static final void onProjectileLaunch$lambda$0(TridentExpert this$0, Player $player, Trident $trident, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = Bukkit.getCurrentTick();
        Integer n2 = this$0.lastTridentEnabledTime.getOrDefault($player, Bukkit.getCurrentTick() - 400);
        Intrinsics.checkNotNull((Object)n2);
        if (n - ((Number)n2).intValue() < 400) {
            $trident.setDamage($trident.getDamage() + (double)2);
        }
    }

    private static final void onProjectileHit$lambda$0(TridentExpert this$0, Player $player, Trident $trident, ProjectileHitEvent $event, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = Bukkit.getCurrentTick();
        Integer n2 = this$0.lastTridentEnabledTime.getOrDefault($player, Bukkit.getCurrentTick() - 400);
        Intrinsics.checkNotNull((Object)n2);
        if (n - ((Number)n2).intValue() < 400 && $trident.getItemStack().getItemMeta().hasEnchant(Enchantment.CHANNELING)) {
            Entity entity = $event.getHitEntity();
            Intrinsics.checkNotNull((Object)entity);
            World world = entity.getWorld();
            Entity entity2 = $event.getHitEntity();
            Intrinsics.checkNotNull((Object)entity2);
            world.strikeLightning(entity2.getLocation());
        }
    }
}

