/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.mobs;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lru/turbovadim/abilities/mobs/Undead;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "onServerTickEnd", "", "event", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "onEntityDamageByEntity", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nUndead.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Undead.kt\nru/turbovadim/abilities/mobs/Undead\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1869#2,2:71\n*S KotlinDebug\n*F\n+ 1 Undead.kt\nru/turbovadim/abilities/mobs/Undead\n*L\n34#1:71,2\n*E\n"})
public final class Undead
implements VisibleAbility,
Listener {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("You are undead, and burn in the daylight. You also take more damage from smite.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Undead", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;

    public Undead() {
        Key key = Key.key("moborigins:undead");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onServerTickEnd(@Nullable ServerTickEndEvent event2) {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> Undead.onServerTickEnd$lambda$0$0(this, arg_0));
        }
    }

    @EventHandler
    public final void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        this.runForAbility(entity, arg_0 -> Undead.onEntityDamageByEntity$lambda$0(event2, arg_0));
    }

    private static final void onServerTickEnd$lambda$0$0(Undead this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Location location2 = location;
        Block block = player.getWorld().getHighestBlockAt(location2);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getHighestBlockAt(...)");
        Block block2 = block;
        while ((MaterialTags.GLASS.isTagged(block2) || MaterialTags.GLASS_PANES.isTagged(block2)) && (double)block2.getY() >= location2.getY()) {
            Intrinsics.checkNotNullExpressionValue((Object)block2.getRelative(BlockFace.DOWN), (String)"getRelative(...)");
        }
        boolean isBelowPlayer = (double)block2.getY() < location2.getY();
        FileConfiguration fileConfiguration = OriginsReforged.Companion.getInstance().getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)fileConfiguration, (String)"getConfig(...)");
        FileConfiguration config = fileConfiguration;
        String string = config.getString("worlds.world");
        if (string == null) {
            Undead $this$onServerTickEnd_u24lambda_u240_u240_u240 = this$0;
            boolean bl = false;
            config.set("worlds.world", (Object)"world");
            OriginsReforged.Companion.getInstance().saveConfig();
            string = "world";
        }
        String overworld = string;
        boolean isInOverworld = player.getWorld() == Bukkit.getWorld((String)overworld);
        boolean isDay = player.getWorld().isDayTime();
        if (isBelowPlayer && isInOverworld && isDay && !player.isInWaterOrRainOrBubbleColumn()) {
            player.setFireTicks((int)Math.max((double)player.getFireTicks(), 60.0));
        }
    }

    private static final void onEntityDamageByEntity$lambda$0(EntityDamageByEntityEvent $event, Player player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Entity entity = $event.getDamager();
            LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            if (livingEntity == null) break block0;
            LivingEntity damager = livingEntity;
            boolean bl = false;
            int level = damager.getActiveItem().getEnchantmentLevel(OriginsReforged.Companion.getNMSInvoker().getSmiteEnchantment());
            $event.setDamage($event.getDamage() + 2.5 * (double)level);
        }
    }
}

