/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.monsters;

import com.destroystokyo.paper.MaterialTags;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.AttributeModifierAbility;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lru/turbovadim/abilities/monsters/BetterGoldArmour;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lru/turbovadim/abilities/types/AttributeModifierAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "attribute", "Lorg/bukkit/attribute/Attribute;", "getAttribute", "()Lorg/bukkit/attribute/Attribute;", "amount", "", "getAmount", "()D", "getChangedAmount", "player", "Lorg/bukkit/entity/Player;", "operation", "Lorg/bukkit/attribute/AttributeModifier$Operation;", "getOperation", "()Lorg/bukkit/attribute/AttributeModifier$Operation;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "onPlayerItemDamage", "", "event", "Lorg/bukkit/event/player/PlayerItemDamageEvent;", "core"})
public final class BetterGoldArmour
implements VisibleAbility,
AttributeModifierAbility,
Listener {
    @NotNull
    private final Attribute attribute = OriginsReforged.Companion.getNMSInvoker().getArmorAttribute();
    private final double amount;
    @NotNull
    private final AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_NUMBER;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("Your adoration for gold unlocks its hidden power, making golden armor unbreakable and as strong as diamond.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Gold Worshipper", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;

    public BetterGoldArmour() {
        Key key = Key.key("monsterorigins:better_gold_armour");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
    }

    @Override
    @NotNull
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public double getChangedAmount(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int amount = 0;
        ItemStack[] itemStackArray = player.getEquipment().getArmorContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getArmorContents(...)");
        for (ItemStack item : itemStackArray) {
            if (item == null) continue;
            if (item.getType() == Material.GOLDEN_HELMET) {
                ++amount;
                continue;
            }
            if (item.getType() == Material.GOLDEN_CHESTPLATE) {
                amount += 3;
                continue;
            }
            if (item.getType() == Material.GOLDEN_LEGGINGS) {
                amount += 3;
                continue;
            }
            if (item.getType() != Material.GOLDEN_BOOTS) continue;
            amount += 2;
        }
        return amount;
    }

    @Override
    @NotNull
    public AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onPlayerItemDamage(@NotNull PlayerItemDamageEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!MaterialTags.ARMOR.isTagged(event2.getItem())) {
            return;
        }
        String string = event2.getItem().getType().toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"gold", (boolean)false, (int)2, null)) {
            return;
        }
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.runForAbility((Entity)player, arg_0 -> BetterGoldArmour.onPlayerItemDamage$lambda$0(event2, arg_0));
    }

    private static final void onPlayerItemDamage$lambda$0(PlayerItemDamageEvent $event, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.setCancelled(true);
    }
}

