/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.monsters;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lru/turbovadim/abilities/monsters/BurnInDay;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onServerTickEnd", "", "ignored", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "core"})
public final class BurnInDay
implements VisibleAbility,
Listener {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("You burn in daylight.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Photoallergic", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;

    public BurnInDay() {
        Key key = Key.key("monsterorigins:burn_in_day");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
    }

    @EventHandler
    public final void onServerTickEnd(@Nullable ServerTickEndEvent ignored) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> BurnInDay.onServerTickEnd$lambda$0(player, arg_0));
        }
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    private static final void onServerTickEnd$lambda$0(Player $player, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Block block = $player.getWorld().getHighestBlockAt($player.getLocation());
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getHighestBlockAt(...)");
        Block block2 = block;
        while (MaterialTags.GLASS.isTagged(block2) || MaterialTags.GLASS_PANES.isTagged(block2) && (double)block2.getY() >= $player.getLocation().getY()) {
            Intrinsics.checkNotNullExpressionValue((Object)block2.getRelative(BlockFace.DOWN), (String)"getRelative(...)");
        }
        boolean height = (double)block2.getY() < $player.getLocation().getY();
        String overworld = OriginsReforged.Companion.getMainConfig().getWorlds().getWorld();
        boolean isInOverworld = $player.getWorld() == Bukkit.getWorld((String)overworld);
        boolean day = $player.getWorld().isDayTime();
        if (height && isInOverworld && day && !$player.isInWaterOrRainOrBubbleColumn()) {
            $player.setFireTicks(Math.max($player.getFireTicks(), 60));
        }
    }
}

