/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.monsters;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001eH\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lru/turbovadim/abilities/monsters/ScareVillagers;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "onEntitySpawn", "", "event", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "onEntitiesLoad", "Lorg/bukkit/event/world/EntitiesLoadEvent;", "fixVillager", "villager", "Lorg/bukkit/entity/Villager;", "hitByPlayerKey", "Lorg/bukkit/NamespacedKey;", "onEntityDamageByEntity", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onPlayerInteractAtEntity", "Lorg/bukkit/event/player/PlayerInteractEntityEvent;", "core"})
public final class ScareVillagers
implements VisibleAbility,
Listener {
    @NotNull
    private final Key key;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;
    @NotNull
    private final NamespacedKey hitByPlayerKey;

    public ScareVillagers() {
        Key key = Key.key("monsterorigins:scare_villagers");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("Villagers are scared of you and refuse to trade with you.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Terrifying Monster", OriginSwapper.LineData.LineComponent.LineType.TITLE);
        this.hitByPlayerKey = new NamespacedKey((Plugin)OriginsReforged.Companion.getInstance(), "hit-by-player");
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @EventHandler
    public final void onEntitySpawn(@NotNull EntitySpawnEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getEntity();
        Villager villager = entity instanceof Villager ? (Villager)entity : null;
        if (villager == null) {
            return;
        }
        Villager villager2 = villager;
        this.fixVillager(villager2);
    }

    @EventHandler
    public final void onEntitiesLoad(@NotNull EntitiesLoadEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        for (Entity entity : event2.getEntities()) {
            Villager villager;
            if ((entity instanceof Villager ? (Villager)entity : null) == null) continue;
            villager = villager;
            this.fixVillager(villager);
        }
    }

    public final void fixVillager(@NotNull Villager villager) {
        Intrinsics.checkNotNullParameter((Object)villager, (String)"villager");
        Bukkit.getMobGoals().addGoal((Mob)villager, 0, OriginsReforged.Companion.getNMSInvoker().getVillagerAfraidGoal((LivingEntity)villager, arg_0 -> ScareVillagers.fixVillager$lambda$0(this, arg_0)));
    }

    @EventHandler
    public final void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getEntity().getType() == EntityType.CREEPER) {
            Player player;
            ProjectileSource projectileSource;
            Entity damager;
            Entity entity = event2.getDamager();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getDamager(...)");
            Entity entity2 = damager = entity;
            Object object = entity2 instanceof Player ? (Player)damager : (entity2 instanceof Projectile ? ((projectileSource = ((Projectile)damager).getShooter()) instanceof Player ? (Player)projectileSource : null) : (player = null));
            if (player != null) {
                this.runForAbility((Entity)player, arg_0 -> ScareVillagers.onEntityDamageByEntity$lambda$0(event2, this, player, arg_0));
            }
        }
    }

    @EventHandler
    public final void onPlayerInteractAtEntity(@NotNull PlayerInteractEntityEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Entity entity = event2.getRightClicked();
        Villager villager = entity instanceof Villager ? (Villager)entity : null;
        if (villager == null) {
            return;
        }
        Villager villager2 = villager;
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.runForAbility((Entity)player, arg_0 -> ScareVillagers.onPlayerInteractAtEntity$lambda$0(event2, villager2, arg_0));
    }

    private static final boolean fixVillager$lambda$0(ScareVillagers this$0, Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this$0.hasAbility(player);
    }

    private static final void onEntityDamageByEntity$lambda$0(EntityDamageByEntityEvent $event, ScareVillagers this$0, Player $player, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.getEntity().getPersistentDataContainer().set(this$0.hitByPlayerKey, PersistentDataType.STRING, (Object)$player.getName());
    }

    private static final void onPlayerInteractAtEntity$lambda$0(PlayerInteractEntityEvent $event, Villager $villager, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.setCancelled(true);
        $villager.shakeHead();
    }
}

