/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.monsters;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;
import ru.turbovadim.cooldowns.CooldownAbility;
import ru.turbovadim.cooldowns.Cooldowns;
import ru.turbovadim.events.PlayerLeftClickEvent;
import ru.turbovadim.packetsenders.NMSInvoker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u0016X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lru/turbovadim/abilities/monsters/SonicBoom;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "Lru/turbovadim/cooldowns/CooldownAbility;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "onPlayerLeftClick", "", "event", "Lru/turbovadim/events/PlayerLeftClickEvent;", "damageAmount", "", "getDamageAmount", "()I", "cooldownInfo", "Lru/turbovadim/cooldowns/Cooldowns$CooldownInfo;", "getCooldownInfo", "()Lru/turbovadim/cooldowns/Cooldowns$CooldownInfo;", "core"})
public final class SonicBoom
implements VisibleAbility,
Listener,
CooldownAbility {
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("Every 30 seconds you can launch a sonic boom by hitting the air with your hand.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Sonic Boom", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;
    private final int damageAmount;
    @NotNull
    private final Cooldowns.CooldownInfo cooldownInfo;

    public SonicBoom() {
        Key key = Key.key("monsterorigins:sonic_boom");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.damageAmount = 15;
        this.cooldownInfo = new Cooldowns.CooldownInfo(600, "sonic_boom", false, false, 12, null);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onPlayerLeftClick(@NotNull PlayerLeftClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)((Object)event2), (String)"event");
        if (event2.getPlayer().getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        Player player = event2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.runForAbility((Entity)player, arg_0 -> SonicBoom.onPlayerLeftClick$lambda$0(this, event2, arg_0));
    }

    public final int getDamageAmount() {
        return this.damageAmount;
    }

    @Override
    @NotNull
    public Cooldowns.CooldownInfo getCooldownInfo() {
        return this.cooldownInfo;
    }

    private static final void onPlayerLeftClick$lambda$0(SonicBoom this$0, PlayerLeftClickEvent $event, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Player player = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        if (this$0.hasCooldown(player)) {
            return;
        }
        Player player2 = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
        this$0.setCooldown(player2);
        Location location = $event.getPlayer().getLocation().clone().add(0.0, 1.5, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        Location currentLoc = location;
        List hitEntities = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            currentLoc.add(currentLoc.getDirection());
            currentLoc.getWorld().spawnParticle(Particle.SONIC_BOOM, currentLoc, 1);
            for (Entity entity : currentLoc.getNearbyEntities(1.0, 1.0, 1.0)) {
                if (entity == $event.getPlayer() || hitEntities.contains(entity) || !(entity instanceof LivingEntity)) continue;
                hitEntities.add(entity);
                NMSInvoker nMSInvoker = OriginsReforged.Companion.getNMSInvoker();
                LivingEntity livingEntity = (LivingEntity)entity;
                int n = this$0.damageAmount;
                Player player3 = $event.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getPlayer(...)");
                nMSInvoker.dealSonicBoomDamage(livingEntity, n, player3);
            }
        }
    }
}

