/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.monsters;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTables;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.abilities.types.VisibleAbility;
import ru.turbovadim.packetsenders.NMSInvoker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lru/turbovadim/abilities/monsters/SuperBartering;", "Lru/turbovadim/abilities/types/VisibleAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "onPiglinBarter", "", "event", "Lorg/bukkit/event/entity/PiglinBarterEvent;", "Companion", "core"})
public final class SuperBartering
implements VisibleAbility,
Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description = OriginSwapper.LineData.Companion.makeLineFor("You're brilliant at bartering after a lifetime of experience, every time you barter you get between 2 and 5 times as many valuables.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title = OriginSwapper.LineData.Companion.makeLineFor("Bartering Master", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    @NotNull
    private final Key key;
    @NotNull
    private static final Random random = new Random();

    public SuperBartering() {
        Key key = Key.key("monsterorigins:super_bartering");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onPiglinBarter(@NotNull PiglinBarterEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        NMSInvoker nMSInvoker = OriginsReforged.Companion.getNMSInvoker();
        Piglin piglin = event2.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)piglin, (String)"getEntity(...)");
        Player player = nMSInvoker.getNearestVisiblePlayer(piglin);
        if (player == null) {
            return;
        }
        this.runForAbility((Entity)player, arg_0 -> SuperBartering.onPiglinBarter$lambda$0(event2, player, arg_0));
    }

    private static final void onPiglinBarter$lambda$0(PiglinBarterEvent $event, Player $player, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int num = random.nextInt(1, 4);
        for (int i = 0; i < num; ++i) {
            Piglin piglin = $event.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)piglin, (String)"getEntity(...)");
            Collection items = SuperBartering.Companion.getBarterResponseItems(piglin);
            Piglin piglin2 = $event.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)piglin2, (String)"getEntity(...)");
            SuperBartering.Companion.throwItemsTowardPlayer(piglin2, $player, items);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lru/turbovadim/abilities/monsters/SuperBartering$Companion;", "", "<init>", "()V", "random", "Ljava/util/Random;", "throwItemsTowardPos", "", "piglin", "Lorg/bukkit/entity/Piglin;", "items", "", "Lorg/bukkit/inventory/ItemStack;", "pos", "Lorg/bukkit/Location;", "throwItemsTowardPlayer", "player", "Lorg/bukkit/entity/Player;", "getBarterResponseItems", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void throwItemsTowardPos(Piglin piglin, Collection<ItemStack> items, Location pos) {
            for (ItemStack itemStack : items) {
                NMSInvoker nMSInvoker = OriginsReforged.Companion.getNMSInvoker();
                Location location = pos.add(0.0, 1.0, 0.0);
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
                nMSInvoker.throwItem(piglin, itemStack, location);
            }
        }

        private final void throwItemsTowardPlayer(Piglin piglin, Player player, Collection<ItemStack> items) {
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            this.throwItemsTowardPos(piglin, items, location);
        }

        private final Collection<ItemStack> getBarterResponseItems(Piglin piglin) {
            Collection collection = LootTables.PIGLIN_BARTERING.getLootTable().populateLoot(random, new LootContext.Builder(piglin.getLocation()).lootedEntity((Entity)piglin).build());
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"populateLoot(...)");
            return collection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

