/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.monsters;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginSwapper;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.SavedPotionEffect;
import ru.turbovadim.ShortcutUtils;
import ru.turbovadim.abilities.types.VisibleAbility;
import ru.turbovadim.packetsenders.NMSInvoker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0007R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lru/turbovadim/abilities/monsters/SwimSpeedMonsters;", "Lorg/bukkit/event/Listener;", "Lru/turbovadim/abilities/types/VisibleAbility;", "<init>", "()V", "storedEffects", "", "Lorg/bukkit/entity/Player;", "Lru/turbovadim/SavedPotionEffect;", "getStoredEffects", "()Ljava/util/Map;", "setStoredEffects", "(Ljava/util/Map;)V", "onServerTickEnd", "", "event", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "onPlayerItemConsume", "Lorg/bukkit/event/player/PlayerItemConsumeEvent;", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "description", "", "Lru/turbovadim/OriginSwapper$LineData$LineComponent;", "getDescription", "()Ljava/util/List;", "title", "getTitle", "core"})
public final class SwimSpeedMonsters
implements Listener,
VisibleAbility {
    @NotNull
    private Map<Player, SavedPotionEffect> storedEffects = new HashMap();
    @NotNull
    private final Key key;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> description;
    @NotNull
    private final List<OriginSwapper.LineData.LineComponent> title;

    public SwimSpeedMonsters() {
        Key key = Key.key("monsterorigins:swim_speed");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.description = OriginSwapper.LineData.Companion.makeLineFor("Your underwater speed is increased.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.title = OriginSwapper.LineData.Companion.makeLineFor("Fast Swimmer", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @NotNull
    public final Map<Player, SavedPotionEffect> getStoredEffects() {
        return this.storedEffects;
    }

    public final void setStoredEffects(@NotNull Map<Player, SavedPotionEffect> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.storedEffects = map;
    }

    @EventHandler
    public final void onServerTickEnd(@Nullable ServerTickEndEvent event2) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> SwimSpeedMonsters.onServerTickEnd$lambda$0(player, this, arg_0));
        }
    }

    @EventHandler
    public final void onPlayerItemConsume(@NotNull PlayerItemConsumeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getItem().getType() == Material.MILK_BUCKET) {
            this.storedEffects.remove(event2.getPlayer());
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return this.title;
    }

    private static final void onServerTickEnd$lambda$0(Player $player, SwimSpeedMonsters this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        NMSInvoker nMSInvoker = OriginsReforged.Companion.getNMSInvoker();
        Intrinsics.checkNotNull((Object)$player);
        if (nMSInvoker.isUnderWater((LivingEntity)$player)) {
            PotionEffect effect = $player.getPotionEffect(PotionEffectType.DOLPHINS_GRACE);
            boolean ambient = false;
            boolean showParticles = false;
            if (effect != null) {
                ambient = effect.isAmbient();
                showParticles = effect.hasParticles();
                if (effect.getAmplifier() != -1) {
                    this$0.storedEffects.put($player, new SavedPotionEffect(effect, Bukkit.getCurrentTick()));
                    $player.removePotionEffect(PotionEffectType.DOLPHINS_GRACE);
                }
            }
            $player.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, ShortcutUtils.INSTANCE.infiniteDuration(), -1, ambient, showParticles));
        } else {
            Object effect;
            if ($player.hasPotionEffect(PotionEffectType.DOLPHINS_GRACE) && (effect = $player.getPotionEffect(PotionEffectType.DOLPHINS_GRACE)) != null && effect.getAmplifier() == -1) {
                $player.removePotionEffect(PotionEffectType.DOLPHINS_GRACE);
            }
            if (this$0.storedEffects.containsKey($player)) {
                SavedPotionEffect savedPotionEffect = this$0.storedEffects.get($player);
                Intrinsics.checkNotNull((Object)savedPotionEffect);
                effect = savedPotionEffect;
                this$0.storedEffects.remove($player);
                PotionEffect potionEffect = effect.effect;
                Intrinsics.checkNotNull((Object)potionEffect);
                PotionEffect potionEffect2 = potionEffect;
                int time = potionEffect2.getDuration() - (Bukkit.getCurrentTick() - effect.currentTime);
                if (time > 0) {
                    $player.addPotionEffect(new PotionEffect(potionEffect2.getType(), time, potionEffect2.getAmplifier(), potionEffect2.isAmbient(), potionEffect2.hasParticles()));
                }
            }
        }
    }
}

