/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.abilities.monsters.metamorphosis;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.turbovadim.OriginsReforged;
import ru.turbovadim.cooldowns.CooldownAbility;
import ru.turbovadim.cooldowns.Cooldowns;
import ru.turbovadim.events.PlayerSwapOriginEvent;
import ru.turbovadim.packetsenders.NMSInvoker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lru/turbovadim/abilities/monsters/metamorphosis/MetamorphosisTemperature;", "Lru/turbovadim/cooldowns/CooldownAbility;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "key", "Lnet/kyori/adventure/key/Key;", "getKey", "()Lnet/kyori/adventure/key/Key;", "onServerTickEnd", "", "event", "Lcom/destroystokyo/paper/event/server/ServerTickEndEvent;", "onPlayerSwapOrigin", "Lru/turbovadim/events/PlayerSwapOriginEvent;", "cooldownInfo", "Lru/turbovadim/cooldowns/Cooldowns$CooldownInfo;", "getCooldownInfo", "()Lru/turbovadim/cooldowns/Cooldowns$CooldownInfo;", "Companion", "core"})
public final class MetamorphosisTemperature
implements CooldownAbility,
Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key key;
    @NotNull
    private final Cooldowns.CooldownInfo cooldownInfo;
    @NotNull
    private static final NamespacedKey playerTemperatureKey = new NamespacedKey((Plugin)OriginsReforged.Companion.getInstance(), "player-temperature");
    @NotNull
    private static MetamorphosisTemperature INSTANCE = new MetamorphosisTemperature();

    public MetamorphosisTemperature() {
        Key key = Key.key("monsterorigins:metamorphosis_temperature");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        this.key = key;
        this.cooldownInfo = new Cooldowns.CooldownInfo(100, "metamorphosis_temperature", true, true);
    }

    @Override
    @NotNull
    public Key getKey() {
        return this.key;
    }

    @EventHandler
    public final void onServerTickEnd(@NotNull ServerTickEndEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNull((Object)player);
            this.runForAbility((Entity)player, arg_0 -> MetamorphosisTemperature.onServerTickEnd$lambda$0(player, arg_0));
        }
    }

    @EventHandler
    public final void onPlayerSwapOrigin(@NotNull PlayerSwapOriginEvent event2) {
        Intrinsics.checkNotNullParameter((Object)((Object)event2), (String)"event");
        PlayerSwapOriginEvent.SwapReason[] swapReasonArray = new PlayerSwapOriginEvent.SwapReason[]{PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN, PlayerSwapOriginEvent.SwapReason.DIED, PlayerSwapOriginEvent.SwapReason.COMMAND, PlayerSwapOriginEvent.SwapReason.INITIAL};
        if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])swapReasonArray), (Object)((Object)event2.getReason()))) {
            Player player = event2.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            Companion.setTemperature(player, 50);
        }
    }

    @Override
    @NotNull
    public Cooldowns.CooldownInfo getCooldownInfo() {
        return this.cooldownInfo;
    }

    private static final void onServerTickEnd$lambda$0(Player $player, Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        double blockTemp = $player.getLocation().getBlock().getTemperature();
        if (blockTemp <= 0.15) {
            Intrinsics.checkNotNull((Object)$player);
            Companion.setTemperature($player, Companion.getTemperature($player) - 1);
        } else if (blockTemp >= 1.75) {
            NMSInvoker nMSInvoker = OriginsReforged.Companion.getNMSInvoker();
            Intrinsics.checkNotNull((Object)$player);
            if (!nMSInvoker.isUnderWater((LivingEntity)$player)) {
                Companion.setTemperature($player, Companion.getTemperature($player) + 1);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lru/turbovadim/abilities/monsters/metamorphosis/MetamorphosisTemperature$Companion;", "", "<init>", "()V", "playerTemperatureKey", "Lorg/bukkit/NamespacedKey;", "INSTANCE", "Lru/turbovadim/abilities/monsters/metamorphosis/MetamorphosisTemperature;", "getINSTANCE", "()Lru/turbovadim/abilities/monsters/metamorphosis/MetamorphosisTemperature;", "setINSTANCE", "(Lru/turbovadim/abilities/monsters/metamorphosis/MetamorphosisTemperature;)V", "getTemperature", "", "player", "Lorg/bukkit/entity/Player;", "setTemperature", "", "amount", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MetamorphosisTemperature getINSTANCE() {
            return INSTANCE;
        }

        public final void setINSTANCE(@NotNull MetamorphosisTemperature metamorphosisTemperature) {
            Intrinsics.checkNotNullParameter((Object)metamorphosisTemperature, (String)"<set-?>");
            INSTANCE = metamorphosisTemperature;
        }

        public final int getTemperature(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Object object = player.getPersistentDataContainer().getOrDefault(playerTemperatureKey, PersistentDataType.INTEGER, (Object)50);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            return ((Number)object).intValue();
        }

        public final void setTemperature(@NotNull Player player, int amount) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            player.getPersistentDataContainer().set(playerTemperatureKey, PersistentDataType.INTEGER, (Object)Math.max(0, Math.min(amount, 100)));
            this.getINSTANCE().setCooldown(player, this.getTemperature(player));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

