/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.SchemaUtils;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManagerKt;
import ru.turbovadim.database.DatabaseManager;
import ru.turbovadim.database.schema.OriginKeyValuePairs;
import ru.turbovadim.database.schema.ShulkerInventory;
import ru.turbovadim.database.schema.UUIDOrigins;
import ru.turbovadim.database.schema.UsedOrigins;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"db", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "getDb", "()Lorg/jetbrains/exposed/v1/jdbc/Database;", "setDb", "(Lorg/jetbrains/exposed/v1/jdbc/Database;)V", "initDb", "", "dataFolder", "Ljava/io/File;", "initH2", "core"})
public final class InitDbKt {
    public static Database db;

    @NotNull
    public static final Database getDb() {
        Database database = db;
        if (database != null) {
            return database;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        return null;
    }

    public static final void setDb(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"<set-?>");
        db = database;
    }

    public static final void initDb(@NotNull File dataFolder) {
        Intrinsics.checkNotNullParameter((Object)dataFolder, (String)"dataFolder");
        System.out.println((Object)"Initializing database with storage type: H2");
        InitDbKt.initH2(dataFolder);
        TransactionManagerKt.transaction((Database)InitDbKt.getDb(), InitDbKt::initDb$lambda$0);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DatabaseManager.INSTANCE.fillOriginCache((Continuation<? super Boolean>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final void initH2(File dataFolder) {
        HikariConfig hikariConfig;
        System.out.println((Object)"Connecting to H2 database...");
        HikariConfig $this$initH2_u24lambda_u240 = hikariConfig = new HikariConfig();
        boolean bl = false;
        $this$initH2_u24lambda_u240.setJdbcUrl("jdbc:h2:" + dataFolder.getAbsolutePath() + "/h2.db;DB_CLOSE_DELAY=-1");
        $this$initH2_u24lambda_u240.setDriverClassName("org.h2.Driver");
        $this$initH2_u24lambda_u240.setMaximumPoolSize(10);
        HikariConfig hikariConfig2 = hikariConfig;
        HikariDataSource dataSource = new HikariDataSource(hikariConfig2);
        InitDbKt.setDb(Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)((DataSource)dataSource), null, null, null, null, (int)30, null));
        System.out.println((Object)"Initialized H2");
    }

    private static final Unit initDb$lambda$0(JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        System.out.println((Object)"Creating missing tables and columns if any...");
        Table[] tableArray = new Table[]{OriginKeyValuePairs.INSTANCE, UsedOrigins.INSTANCE, UUIDOrigins.INSTANCE, ShulkerInventory.INSTANCE};
        SchemaUtils.createMissingTablesAndColumns$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (boolean)false, (int)6, null);
        return Unit.INSTANCE;
    }
}

