/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.events;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.OriginsReforged;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006!"}, d2={"Lru/turbovadim/events/PlayerLeftClickEvent;", "Lorg/bukkit/event/player/PlayerEvent;", "playerInteractEvent", "Lorg/bukkit/event/player/PlayerInteractEvent;", "<init>", "(Lorg/bukkit/event/player/PlayerInteractEvent;)V", "interactionPoint", "Lorg/bukkit/Location;", "getInteractionPoint", "()Lorg/bukkit/Location;", "hasBlock", "", "hasItem", "item", "Lorg/bukkit/inventory/ItemStack;", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "material", "Lorg/bukkit/Material;", "getMaterial", "()Lorg/bukkit/Material;", "clickedBlock", "Lorg/bukkit/block/Block;", "getClickedBlock", "()Lorg/bukkit/block/Block;", "blockFace", "Lorg/bukkit/block/BlockFace;", "getBlockFace", "()Lorg/bukkit/block/BlockFace;", "getHandlers", "Lorg/bukkit/event/HandlerList;", "PlayerLeftClickEventListener", "Companion", "core"})
public final class PlayerLeftClickEvent
extends PlayerEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlayerInteractEvent playerInteractEvent;
    @Nullable
    private final Location interactionPoint;
    @Nullable
    private final ItemStack item;
    @NotNull
    private final Material material;
    @Nullable
    private final Block clickedBlock;
    @Nullable
    private final BlockFace blockFace;
    @NotNull
    private static final HandlerList handlerList = new HandlerList();

    public PlayerLeftClickEvent(@NotNull PlayerInteractEvent playerInteractEvent) {
        Intrinsics.checkNotNullParameter((Object)playerInteractEvent, (String)"playerInteractEvent");
        super(playerInteractEvent.getPlayer());
        this.playerInteractEvent = playerInteractEvent;
        this.interactionPoint = this.playerInteractEvent.getInteractionPoint();
        this.item = this.playerInteractEvent.getItem();
        Material material = this.playerInteractEvent.getMaterial();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getMaterial(...)");
        this.material = material;
        this.clickedBlock = this.playerInteractEvent.getClickedBlock();
        this.blockFace = this.playerInteractEvent.getBlockFace();
    }

    @Nullable
    public final Location getInteractionPoint() {
        return this.interactionPoint;
    }

    public final boolean hasBlock() {
        return this.playerInteractEvent.hasBlock();
    }

    public final boolean hasItem() {
        return this.playerInteractEvent.hasItem();
    }

    @Nullable
    public final ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public final Material getMaterial() {
        return this.material;
    }

    @Nullable
    public final Block getClickedBlock() {
        return this.clickedBlock;
    }

    @Nullable
    public final BlockFace getBlockFace() {
        return this.blockFace;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlerList;
    }

    @JvmStatic
    @NotNull
    public static final HandlerList getHandlerList() {
        return Companion.getHandlerList();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lru/turbovadim/events/PlayerLeftClickEvent$Companion;", "", "<init>", "()V", "handlerList", "Lorg/bukkit/event/HandlerList;", "getHandlerList", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HandlerList getHandlerList() {
            return handlerList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0007R*\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lru/turbovadim/events/PlayerLeftClickEvent$PlayerLeftClickEventListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "lastInteractionTickMap", "", "Lorg/bukkit/entity/Player;", "", "getLastInteractionTickMap", "()Ljava/util/Map;", "setLastInteractionTickMap", "(Ljava/util/Map;)V", "onPlayerInteract", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onPlayerDropItem", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "onBlockBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "core"})
    public static final class PlayerLeftClickEventListener
    implements Listener {
        @NotNull
        private Map<Player, Integer> lastInteractionTickMap = new HashMap();

        @NotNull
        public final Map<Player, Integer> getLastInteractionTickMap() {
            return this.lastInteractionTickMap;
        }

        public final void setLastInteractionTickMap(@NotNull Map<Player, Integer> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.lastInteractionTickMap = map;
        }

        @EventHandler
        public final void onPlayerInteract(@NotNull PlayerInteractEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (!event2.getAction().isLeftClick()) {
                return;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReforged.Companion.getInstance(), () -> PlayerLeftClickEventListener.onPlayerInteract$lambda$0(this, event2));
        }

        @EventHandler
        public final void onPlayerDropItem(@NotNull PlayerDropItemEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            this.lastInteractionTickMap.put(event2.getPlayer(), Bukkit.getCurrentTick() + 1);
        }

        @EventHandler
        public final void onBlockBreak(@NotNull BlockBreakEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            this.lastInteractionTickMap.put(event2.getPlayer(), Bukkit.getCurrentTick() + 1);
        }

        private static final void onPlayerInteract$lambda$0(PlayerLeftClickEventListener this$0, PlayerInteractEvent $event) {
            Integer n = this$0.lastInteractionTickMap.getOrDefault($event.getPlayer(), -1);
            Intrinsics.checkNotNull((Object)n);
            if (((Number)n).intValue() >= Bukkit.getCurrentTick()) {
                return;
            }
            this$0.lastInteractionTickMap.put($event.getPlayer(), Bukkit.getCurrentTick());
            new PlayerLeftClickEvent($event).callEvent();
        }
    }
}

