/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0007J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lru/turbovadim/util/CompressionUtils;", "", "<init>", "()V", "compressFiles", "", "files", "", "Ljava/io/File;", "outputZip", "addToZipFile", "file", "zos", "Ljava/util/zip/ZipOutputStream;", "decompressFiles", "zipFile", "outputDir", "newFile", "destinationDir", "zipEntry", "Ljava/util/zip/ZipEntry;", "core"})
@SourceDebugExtension(value={"SMAP\nCompressionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressionUtils.kt\nru/turbovadim/util/CompressionUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class CompressionUtils {
    @NotNull
    public static final CompressionUtils INSTANCE = new CompressionUtils();

    private CompressionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compressFiles(@NotNull Collection<File> files, @NotNull File outputZip) throws IOException {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)outputZip, (String)"outputZip");
        Closeable closeable = new FileOutputStream(outputZip);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipOutputStream(fos);
            Throwable throwable2 = null;
            try {
                ZipOutputStream zos = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                for (File file : files) {
                    INSTANCE.addToZipFile(file, zos);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToZipFile(File file, ZipOutputStream zos) throws IOException {
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream fis = (FileInputStream)closeable;
            boolean bl = false;
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zos.putNextEntry(zipEntry);
            byte[] buffer = new byte[1024];
            int length = 0;
            while (true) {
                int n;
                int it = n = fis.read(buffer);
                boolean bl2 = false;
                length = it;
                if (n < 0) break;
                zos.write(buffer, 0, length);
            }
            zos.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void decompressFiles(@NotNull File zipFile, @NotNull File outputDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Closeable closeable = new FileInputStream(zipFile);
        Throwable throwable = null;
        try {
            FileInputStream fis = (FileInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipInputStream(fis);
            Throwable throwable2 = null;
            try {
                ZipInputStream zis = (ZipInputStream)closeable2;
                boolean bl2 = false;
                ZipEntry zipEntry = null;
                while (true) {
                    ZipEntry zipEntry2;
                    ZipEntry it = zipEntry2 = zis.getNextEntry();
                    boolean bl3 = false;
                    zipEntry = it;
                    if (zipEntry2 == null) break;
                    ZipEntry zipEntry3 = zipEntry;
                    Intrinsics.checkNotNull((Object)zipEntry3);
                    File newFile = INSTANCE.newFile(outputDir, zipEntry3);
                    if (zipEntry.isDirectory()) {
                        if (!newFile.isDirectory() && !newFile.mkdirs()) {
                            throw new IOException("Failed to create directory " + newFile);
                        }
                    } else {
                        File parent = newFile.getParentFile();
                        if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
                            throw new IOException("Failed to create directory " + parent);
                        }
                        Closeable closeable3 = new FileOutputStream(newFile);
                        Throwable throwable3 = null;
                        try {
                            FileOutputStream fos = (FileOutputStream)closeable3;
                            boolean bl4 = false;
                            byte[] buffer = new byte[1024];
                            int length = 0;
                            while (true) {
                                int n;
                                int it2 = n = zis.read(buffer);
                                boolean bl5 = false;
                                length = it2;
                                if (n <= 0) break;
                                fos.write(buffer, 0, length);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                    }
                    zis.closeEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        Intrinsics.checkNotNull((Object)destFilePath);
        if (!StringsKt.startsWith$default((String)destFilePath, (String)(destDirPath + File.separator), (boolean)false, (int)2, null)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

