/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e\u001a\u001e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"getNearbyEntitiesFast", "", "Lorg/bukkit/entity/Entity;", "loc", "Lorg/bukkit/Location;", "radius", "", "benchmark", "", "label", "", "iterations", "", "block", "Lkotlin/Function0;", "ITERATIONS", "testBenchmarks", "player", "Lorg/bukkit/entity/Player;", "core"})
@SourceDebugExtension(value={"SMAP\ngetNearbyEntitiesFast.kt\nKotlin\n*S Kotlin\n*F\n+ 1 getNearbyEntitiesFast.kt\nru/turbovadim/util/GetNearbyEntitiesFastKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,84:1\n1#2:85\n29#3,3:86\n*S KotlinDebug\n*F\n+ 1 getNearbyEntitiesFast.kt\nru/turbovadim/util/GetNearbyEntitiesFastKt\n*L\n64#1:86,3\n*E\n"})
public final class GetNearbyEntitiesFastKt {
    public static final int ITERATIONS = 100000;

    @NotNull
    public static final List<Entity> getNearbyEntitiesFast(@NotNull Location loc, double radius) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        List nearby = new ArrayList();
        double rSquared = radius * radius;
        double locX = loc.getX();
        double locY = loc.getY();
        double locZ = loc.getZ();
        double minX = locX - radius;
        double maxX = locX + radius;
        double minY = locY - radius;
        double maxY = locY + radius;
        double minZ = locZ - radius;
        double maxZ = locZ + radius;
        int chunkRadius = (int)Math.ceil(radius / (double)16);
        int baseChunkX = loc.getBlockX() >> 4;
        int baseChunkZ = loc.getBlockZ() >> 4;
        int chunkX = baseChunkX - chunkRadius;
        int n = baseChunkX + chunkRadius;
        if (chunkX <= n) {
            while (true) {
                int n2;
                int chunkZ;
                if ((chunkZ = baseChunkZ - chunkRadius) <= (n2 = baseChunkZ + chunkRadius)) {
                    while (true) {
                        Entity[] entityArray;
                        Chunk chunk;
                        Intrinsics.checkNotNullExpressionValue((Object)loc.getWorld().getChunkAt(chunkX, chunkZ), (String)"getChunkAt(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)chunk.getEntities(), (String)"getEntities(...)");
                        for (Entity entity : entityArray) {
                            double dz;
                            double dy;
                            double dx;
                            Location eLoc;
                            Intrinsics.checkNotNull((Object)entity);
                            Entity entity2 = entity;
                            Intrinsics.checkNotNullExpressionValue((Object)entity2.getLocation(), (String)"getLocation(...)");
                            double ex = eLoc.getX();
                            double ey = eLoc.getY();
                            double ez = eLoc.getZ();
                            if (ex < minX || ex > maxX || ey < minY || ey > maxY || ez < minZ || ez > maxZ || !((dx = ex - locX) * dx + (dy = ey - locY) * dy + (dz = ez - locZ) * dz <= rSquared)) continue;
                            nearby.add(entity2);
                        }
                        if (chunkZ == n2) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == n) break;
                ++chunkX;
            }
        }
        return nearby;
    }

    public static final void benchmark(@NotNull String label, int iterations, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int n = 1000;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            block.invoke();
        }
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        int n3 = 0;
        while (n3 < iterations) {
            int it = n3++;
            boolean bl2 = false;
            block.invoke();
        }
        long totalTime = System.currentTimeMillis() - start$iv;
        System.out.println((Object)(label + ": " + iterations + " \u0438\u0442\u0435\u0440\u0430\u0446\u0438\u0439 \u0437\u0430\u043d\u044f\u043b\u0438 " + totalTime + " \u043c\u0441 (\u0432 \u0441\u0440\u0435\u0434\u043d\u0435\u043c " + (double)totalTime / (double)iterations + " \u043c\u0441 \u0437\u0430 \u0438\u0442\u0435\u0440\u0430\u0446\u0438\u044e)"));
    }

    public static /* synthetic */ void benchmark$default(String string, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10000;
        }
        GetNearbyEntitiesFastKt.benchmark(string, n, (Function0<Unit>)function0);
    }

    public static final void testBenchmarks(@NotNull Player player, @NotNull Location loc, double radius) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        GetNearbyEntitiesFastKt.benchmark("Fast \u041a\u043e\u0441\u0442\u044b\u043b\u044c", 100000, (Function0<Unit>)((Function0)() -> GetNearbyEntitiesFastKt.testBenchmarks$lambda$0(loc, radius)));
        GetNearbyEntitiesFastKt.benchmark("Bukkit Sex", 100000, (Function0<Unit>)((Function0)() -> GetNearbyEntitiesFastKt.testBenchmarks$lambda$1(loc, radius)));
        GetNearbyEntitiesFastKt.benchmark("Bukkit default", 100000, (Function0<Unit>)((Function0)() -> GetNearbyEntitiesFastKt.testBenchmarks$lambda$2(player, radius)));
    }

    private static final Unit testBenchmarks$lambda$0(Location $loc, double $radius) {
        GetNearbyEntitiesFastKt.getNearbyEntitiesFast($loc, $radius);
        return Unit.INSTANCE;
    }

    private static final Unit testBenchmarks$lambda$1(Location $loc, double $radius) {
        $loc.getNearbyEntities($radius, $radius, $radius);
        return Unit.INSTANCE;
    }

    private static final Unit testBenchmarks$lambda$2(Player $player, double $radius) {
        $player.getNearbyEntities($radius, $radius, $radius);
        return Unit.INSTANCE;
    }
}

