/*
 * Decompiled with CFR 0.152.
 */
package ru.turbovadim.util;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.turbovadim.abilities.types.Ability;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0010R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/turbovadim/util/WorldGuardHook;", "", "<init>", "()V", "rc", "Lcom/sk89q/worldguard/protection/regions/RegionContainer;", "isAbilityDisabled", "", "location", "Lorg/bukkit/Location;", "ability", "Lru/turbovadim/abilities/types/Ability;", "flag", "Lcom/sk89q/worldguard/protection/flags/StringFlag;", "tryInitialize", "completeInitialize", "", "core"})
@SourceDebugExtension(value={"SMAP\nWorldGuardHook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGuardHook.kt\nru/turbovadim/util/WorldGuardHook\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,54:1\n739#2,9:55\n37#3,2:64\n*S KotlinDebug\n*F\n+ 1 WorldGuardHook.kt\nru/turbovadim/util/WorldGuardHook\n*L\n28#1:55,9\n28#1:64,2\n*E\n"})
public final class WorldGuardHook {
    @NotNull
    public static final WorldGuardHook INSTANCE = new WorldGuardHook();
    @Nullable
    private static RegionContainer rc;
    @Nullable
    private static StringFlag flag;

    private WorldGuardHook() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAbilityDisabled(@NotNull Location location, @NotNull Ability ability) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)ability, (String)"ability");
        try {
            RegionContainer regionContainer = rc;
            Intrinsics.checkNotNull((Object)regionContainer);
            RegionManager manager = regionContainer.get(BukkitAdapter.adapt((World)location.getWorld()));
            if (manager == null) {
                return false;
            }
            ApplicableRegionSet set = manager.getApplicableRegions(new BlockVector3(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
            for (ProtectedRegion r : set) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                String data = (String)r.getFlag((Flag)flag);
                if (data == null) continue;
                Object object = data;
                Regex regex = new Regex(",");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                for (String s : thisCollection$iv.toArray(new String[0])) {
                    if (!Intrinsics.areEqual((Object)s, (Object)ability.getKey().toString())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public final boolean tryInitialize() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        flag = new StringFlag("origins-reborn:disabled-abilities");
        registry.register((Flag)flag);
        return true;
    }

    public final void completeInitialize() {
        rc = WorldGuard.getInstance().getPlatform().getRegionContainer();
    }
}

