/*
 * Decompiled with CFR 0.152.
 */
package top.yanhy.quizzerBot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import top.yanhy.quizzerBot.PlayerStats;
import top.yanhy.quizzerBot.Question;
import top.yanhy.quizzerBot.QuizzerBot;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private final QuizzerBot plugin;

    public CommandHandler(QuizzerBot plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String @NotNull [] args) {
        try {
            this.handleCommand(sender, args);
        }
        catch (Exception e) {
            QuizzerBot.log.warning("\u6307\u4ee4\u9519\u8bef " + e.getMessage());
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String @NotNull [] args) {
        if (command.getName().equalsIgnoreCase("quiz")) {
            if (sender.isOp()) {
                if (args.length == 1) {
                    List<String> completions = Arrays.asList("ans", "top", "query", "me", "add", "delete", "toggle", "modify", "list", "detail", "start", "startnow", "stop", "reload", "enable");
                    String argument = args[0].toLowerCase();
                    return completions.stream().filter(completion -> completion.startsWith(argument)).collect(Collectors.toList());
                }
            } else if (args.length == 1) {
                List<String> completions = List.of("ans", "top", "query", "me");
                String argument = args[0].toLowerCase();
                return completions.stream().filter(completion -> completion.startsWith(argument)).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public void handleCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            this.sendUsage(sender);
            return;
        }
        String subCommand = args[0].toLowerCase();
        try {
            if (subCommand.equals("ans")) {
                if (sender instanceof Player) {
                    this.handleAnswerCommand((Player)sender, Arrays.copyOfRange(args, 1, args.length));
                } else {
                    sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u53ea\u6709\u6e38\u620f\u5185\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4\uff01").color((TextColor)NamedTextColor.RED));
                }
            } else if (subCommand.equals("me") || subCommand.equals("query") || subCommand.equals("top")) {
                this.handlePlayerCommand(sender, args);
            } else if (sender.isOp()) {
                this.handleAdminCommand(sender, args);
            } else {
                sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u4f60\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6b64\u547d\u4ee4\uff01").color((TextColor)NamedTextColor.RED));
            }
        }
        catch (Exception e) {
            sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u6267\u884c\u547d\u4ee4\u65f6\u51fa\u9519:" + e.getMessage())).color((TextColor)NamedTextColor.RED));
            QuizzerBot.log.severe("\u5904\u7406\u547d\u4ee4\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    private void handleAdminCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendAdminUsage(sender);
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "add": {
                this.handleAddQuestion(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            case "delete": 
            case "remove": {
                this.handleDeleteQuestion(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            case "toggle": {
                this.handleToggleQuestion(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            case "modify": {
                this.handleModifyQuestion(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            case "list": {
                this.handleListQuestions(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            case "detail": {
                this.handleDetail(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            case "enable": {
                this.handleEnable(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            case "start": {
                this.handleStart(sender);
                return;
            }
            case "startnow": {
                this.handleStartNow(sender);
                return;
            }
            case "stop": {
                this.handleStop(sender);
                return;
            }
            case "reload": {
                this.plugin.getConfigManager().reloadConfig();
                sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u914d\u7f6e\u5df2\u91cd\u65b0\u52a0\u8f7d\uff01").color((TextColor)NamedTextColor.GREEN));
                return;
            }
        }
        this.sendAdminUsage(sender);
    }

    private void handleAnswerCommand(Player player, String[] args) {
        if (args.length != 1) {
            player.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7528\u6cd5: /quiz ans <\u7b54\u6848>").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (player == null) {
            return;
        }
        if (!this.plugin.getQuizManager().isQuizActive()) {
            player.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u5f53\u524d\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u7b54\u9898\u6d3b\u52a8\uff01").color((TextColor)NamedTextColor.RED));
            return;
        }
        String answer = args[0].toUpperCase();
        if (!answer.matches("[A-D]")) {
            player.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7b54\u6848\u5fc5\u987b\u662fA\u3001B\u3001C\u6216D\u4e2d\u7684\u4e00\u4e2a\uff01").color((TextColor)NamedTextColor.RED));
            return;
        }
        this.plugin.getQuizManager().submitAnswer(player, answer);
    }

    private void handleAddQuestion(CommandSender sender, String[] args) {
        if (args.length < 6) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7528\u6cd5: /quiz add <\u95ee\u9898\u63cf\u8ff0> <A> <B> <C> <D> <\u6b63\u786e\u9009\u9879> (\u9009\u9879\u4e3a\u7a7a\u5219\u4f7f\u7528'-'\u4ee3\u66ff)").color((TextColor)NamedTextColor.RED));
            return;
        }
        try {
            String quiz = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length - 5));
            String optA = args[args.length - 5];
            String optB = args[args.length - 4];
            String optC = args[args.length - 3];
            String optD = args[args.length - 2];
            String answer = args[args.length - 1].toUpperCase();
            if (!answer.matches("[A-D]")) {
                sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7b54\u6848\u5fc5\u987b\u662fA\u3001B\u3001C\u6216D\u4e2d\u7684\u4e00\u4e2a\u9009\u9879\uff01").color((TextColor)NamedTextColor.RED));
                return;
            }
            Question question = new Question(0, quiz, optA, optB, optC, optD, answer, true, 0);
            if (this.plugin.getDbManager().addQuestion(question)) {
                sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u6210\u529f\u6dfb\u52a0\u95ee\u9898: " + quiz)).color((TextColor)NamedTextColor.GREEN));
            } else {
                sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u6dfb\u52a0\u95ee\u9898\u5931\u8d25: " + quiz)).color((TextColor)NamedTextColor.RED));
            }
        }
        catch (NumberFormatException e) {
            QuizzerBot.log.warning("\u6dfb\u52a0\u95ee\u9898\u65f6\u51fa\u73b0\u9519\u8bef" + e.getMessage());
        }
    }

    private void handleDeleteQuestion(CommandSender sender, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7528\u6cd5: /quiz delete <\u95ee\u9898ID>").color((TextColor)NamedTextColor.RED));
            return;
        }
        try {
            int id = Integer.parseInt(args[0]);
            this.plugin.getDbManager().deleteQuestion(id);
            sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u6210\u529f\u5220\u9664ID\u4e3a " + id + " \u7684\u95ee\u9898")).color((TextColor)NamedTextColor.GREEN));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u95ee\u9898ID\u5fc5\u987b\u662f\u6570\u5b57\uff01").color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleToggleQuestion(CommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7528\u6cd5: /quiz toggle <\u95ee\u9898ID> <true|false>").color((TextColor)NamedTextColor.RED));
            return;
        }
        try {
            int id = Integer.parseInt(args[0]);
            boolean enable = Boolean.parseBoolean(args[1]);
            if (this.plugin.getDbManager().toggleQuestion(id, enable).booleanValue()) {
                sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u6210\u529f\u5207\u6362ID\u4e3a " + id + " \u7684\u72b6\u6001\u4e3a" + enable)).color((TextColor)NamedTextColor.YELLOW));
            } else {
                sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u672a\u627e\u5230ID\u4e3a " + id + " \u7684\u95ee\u9898")).color((TextColor)NamedTextColor.RED));
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u95ee\u9898ID\u5fc5\u987b\u662f\u6570\u5b57\uff01").color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleModifyQuestion(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7528\u6cd5: /quiz modify <\u95ee\u9898ID> <\u5b57\u6bb5> <\u65b0\u503c>").color((TextColor)NamedTextColor.RED));
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u53ef\u7528\u5b57\u6bb5: quiz, optA, optB, optC, optD, answer, enable, showCount").color((TextColor)NamedTextColor.YELLOW));
            return;
        }
        try {
            int id = Integer.parseInt(args[0]);
            String field = args[1].toLowerCase();
            String valueStr = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
            Object value = switch (field) {
                case "enable" -> Boolean.parseBoolean(valueStr);
                case "opta" -> {
                    field = "optA";
                    yield valueStr;
                }
                case "optb" -> {
                    field = "optB";
                    yield valueStr;
                }
                case "optc" -> {
                    field = "optC";
                    yield valueStr;
                }
                case "optd" -> {
                    field = "optD";
                    yield valueStr;
                }
                case "showcount" -> {
                    field = "showCount";
                    yield valueStr;
                }
                default -> valueStr;
            };
            if (field.equals("answer") && !valueStr.matches("[A-Da-d]")) {
                sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7b54\u6848\u5fc5\u987b\u662fA\u3001B\u3001C\u6216D\u4e2d\u7684\u4e00\u4e2a\u9009\u9879\uff01").color((TextColor)NamedTextColor.RED));
                return;
            }
            QuizzerBot.log.info(id + " " + field + " " + String.valueOf(value));
            boolean success = this.plugin.getDbManager().updateQuestionField(id, field, value);
            if (success) {
                sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u6210\u529f\u66f4\u65b0\u95ee\u9898ID " + id + " \u7684 " + field + " \u5b57\u6bb5")).color((TextColor)NamedTextColor.GREEN));
            } else {
                sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u66f4\u65b0\u95ee\u9898\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u95ee\u9898ID\u662f\u5426\u5b58\u5728").color((TextColor)NamedTextColor.RED));
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u95ee\u9898ID\u5fc5\u987b\u662f\u6570\u5b57\uff01").color((TextColor)NamedTextColor.RED));
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u65e0\u6548\u7684\u503c\u7c7b\u578b: " + e.getMessage())).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleListQuestions(CommandSender sender, String[] args) {
        int page = 1;
        String sortBy = null;
        int perPage = 10;
        if (args.length > 0) {
            block11: {
                try {
                    page = Integer.parseInt(args[args.length - 1]);
                }
                catch (NumberFormatException e) {
                    if (!args[0].equalsIgnoreCase("show")) break block11;
                    sortBy = args[0].toLowerCase();
                }
            }
            if (args.length > 1 && args[0].equalsIgnoreCase("show")) {
                sortBy = args[0].toLowerCase();
                try {
                    page = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        List<Question> questions = this.plugin.getDbManager().getQuestions(page, perPage, sortBy);
        TextComponent.Builder message = Component.text();
        message.append(Component.text((String)("=== \u9898\u76ee\u5217\u8868 (\u7b2c " + page + " \u9875) ===\n")).color((TextColor)NamedTextColor.GOLD));
        if (sortBy != null) {
            message.append(Component.text((String)("\u6392\u5e8f\u65b9\u5f0f: " + (sortBy.equals("show") ? "\u51fa\u73b0\u6b21\u6570" : "\u4e3e\u62a5\u6b21\u6570") + "\n")).color((TextColor)NamedTextColor.YELLOW));
        }
        for (Question q : questions) {
            TextComponent idComponent = (TextComponent)((TextComponent)((TextComponent)Component.text((String)("[" + q.getId() + "]")).color((TextColor)NamedTextColor.GREEN)).clickEvent(ClickEvent.runCommand((String)("/quiz detail " + q.getId())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5")));
            message.append((Component)idComponent);
            if (sortBy != null) {
                int count = q.getShowCount();
                message.append((Component)Component.text((String)(" - " + count)));
            }
            message.append((Component)Component.text((String)"\n"));
        }
        TextComponent.Builder pagination = Component.text();
        if (page > 1) {
            String prevCommand = "/quiz list" + (String)(sortBy != null ? " " + sortBy : "") + " " + (page - 1);
            pagination.append(((TextComponent)((TextComponent)Component.text((String)"<<").color((TextColor)NamedTextColor.BLUE)).clickEvent(ClickEvent.runCommand((String)prevCommand))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u4e0a\u4e00\u9875"))));
        } else {
            pagination.append(Component.text((String)"<<").color((TextColor)NamedTextColor.GRAY));
        }
        pagination.append((Component)Component.text((String)"    "));
        String nextCommand = "/quiz list" + (String)(sortBy != null ? " " + sortBy : "") + " " + (page + 1);
        pagination.append(((TextComponent)((TextComponent)Component.text((String)">>").color((TextColor)NamedTextColor.BLUE)).clickEvent(ClickEvent.runCommand((String)nextCommand))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u4e0b\u4e00\u9875"))));
        message.append((Component)pagination.build());
        sender.sendMessage((Component)message.build());
    }

    private void handleDetail(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7528\u6cd5: /quiz detail <\u95ee\u9898ID>").color((TextColor)NamedTextColor.RED));
            return;
        }
        try {
            int id = Integer.parseInt(args[0]);
            Question question = this.plugin.getDbManager().getQuestionById(id);
            if (question == null) {
                sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u672a\u627e\u5230ID\u4e3a " + id + " \u7684\u95ee\u9898")).color((TextColor)NamedTextColor.RED));
                return;
            }
            TextComponent.Builder message = Component.text();
            message.append(Component.text((String)("=== \u9898\u76ee\u8be6\u60c5 (ID: " + id + ") ===\n")).color((TextColor)NamedTextColor.GOLD));
            message.append(Component.text((String)("\u95ee\u9898: " + question.getQuiz() + "\n")).color((TextColor)NamedTextColor.WHITE));
            message.append(Component.text((String)("\u9009\u9879A: " + question.getOptA() + "\n")).color((TextColor)NamedTextColor.GRAY));
            message.append(Component.text((String)("\u9009\u9879B: " + question.getOptB() + "\n")).color((TextColor)NamedTextColor.GRAY));
            message.append(Component.text((String)("\u9009\u9879C: " + question.getOptC() + "\n")).color((TextColor)NamedTextColor.GRAY));
            message.append(Component.text((String)("\u9009\u9879D: " + question.getOptD() + "\n")).color((TextColor)NamedTextColor.GRAY));
            message.append(Component.text((String)("\u6b63\u786e\u7b54\u6848: " + question.getAnswer() + "\n")).color((TextColor)NamedTextColor.GREEN));
            message.append(Component.text((String)("\u72b6\u6001: " + (question.isEnable() ? "\u542f\u7528" : "\u7981\u7528") + "\n")).color((TextColor)NamedTextColor.YELLOW));
            message.append(Component.text((String)("\u51fa\u73b0\u6b21\u6570: " + question.getShowCount() + "\n")).color((TextColor)NamedTextColor.AQUA));
            sender.sendMessage((Component)message.build());
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u95ee\u9898ID\u5fc5\u987b\u662f\u6570\u5b57\uff01").color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleEnable(CommandSender sender, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7528\u6cd5: /quiz enable <true|false>").color((TextColor)NamedTextColor.RED));
            return;
        }
        try {
            this.plugin.botEnable = Boolean.parseBoolean(args[0]);
            if (!this.plugin.botEnable.booleanValue()) {
                this.plugin.getQuizManager().stop();
            } else {
                this.plugin.getQuizManager().reset();
            }
            sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u7b54\u9898\u6d3b\u52a8\u72b6\u6001\u5df2\u5207\u6362!\u5f53\u524d\u4e3a: " + this.plugin.botEnable)).color((TextColor)NamedTextColor.YELLOW));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u72b6\u6001\u5207\u6362\u5931\u8d25\uff01").color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleStop(CommandSender sender) {
        try {
            this.plugin.botEnable = false;
            this.plugin.getQuizManager().stop();
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7b54\u9898\u6d3b\u52a8\u5df2\u505c\u6b62").color((TextColor)NamedTextColor.YELLOW));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u72b6\u6001\u505c\u6b62\u5931\u8d25\uff01").color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleStart(CommandSender sender) {
        try {
            this.plugin.botEnable = true;
            this.plugin.getDbManager().initializeDatabase();
            this.plugin.getSchedulerManager().startQuizScheduler();
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7b54\u9898\u6d3b\u52a8\u5df2\u5f00\u542f,\u8c03\u5ea6\u5668\u5df2\u542f\u52a8").color((TextColor)NamedTextColor.YELLOW));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u72b6\u6001\u5f00\u542f\u5931\u8d25\uff01").color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleStartNow(CommandSender sender) {
        try {
            if (this.plugin.getQuizManager().isQuizActive()) {
                sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u5f53\u524d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u7b54\u9898\u6d3b\u52a8\uff01").color((TextColor)NamedTextColor.RED));
                return;
            }
            if (this.plugin.botEnable.booleanValue()) {
                this.plugin.getSchedulerManager().startQuizNow();
                sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7b54\u9898\u6d3b\u52a8\u5df2\u76f4\u63a5\u542f\u52a8,\u5c06\u57283\u79d2\u540e\u53d1\u8d77! ").color((TextColor)NamedTextColor.YELLOW));
            } else {
                this.plugin.getSchedulerManager().startQuizNow();
                sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot]\u7b54\u9898\u6d3b\u52a8\u5df2\u505c\u6b62,\u8bf7\u5148\u5f00\u542f\u6d3b\u52a8! ").color((TextColor)NamedTextColor.YELLOW));
            }
        }
        catch (Exception e) {
            sender.sendMessage(Component.text((String)("[\u7b54\u9898Bot]\u7acb\u5373\u542f\u52a8\u5931\u8d25: " + e.getMessage())).color((TextColor)NamedTextColor.RED));
            QuizzerBot.log.severe("\u7acb\u5373\u542f\u52a8\u7b54\u9898\u5931\u8d25: " + e.getMessage());
        }
    }

    private void handlePlayerCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot] \u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4\uff01").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (args.length == 0) {
            this.handleQueryMe((Player)sender);
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "me": {
                this.handleQueryMe((Player)sender);
                break;
            }
            case "query": {
                this.handleQueryPlayer((Player)sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "top": {
                this.handleLeaderboard((Player)sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                this.sendPlayerUsage(sender);
            }
        }
    }

    private void handleQueryMe(Player player) {
        PlayerStats stats = this.plugin.getDbManager().getPlayerStats(player.getUniqueId());
        if (stats == null) {
            player.sendMessage(Component.text((String)"[\u7b54\u9898Bot] \u4f60\u8fd8\u6ca1\u6709\u7b54\u9898\u8bb0\u5f55\uff01").color((TextColor)NamedTextColor.YELLOW));
            return;
        }
        BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"=== \u4f60\u7684\u7b54\u9898\u7edf\u8ba1 ===\n").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)("\u603b\u7b54\u9898\u6570: " + stats.gettotal_attempts() + "\n")).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)("\u7b54\u5bf9\u6b21\u6570: " + stats.getcorrect_daily_rewards() + "\n")).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)("\u62a2\u7b54\u6b21\u6570: " + stats.getquick_daily_rewards() + "\n")).color((TextColor)NamedTextColor.AQUA))).append(Component.text((String)("\u6bcf\u65e5\u5956\u52b1: " + stats.getdaily_rewards() + "\n")).color((TextColor)NamedTextColor.LIGHT_PURPLE))).append(Component.text((String)("\u6700\u540e\u7b54\u9898: " + stats.last_played_date())).color((TextColor)NamedTextColor.GRAY))).build();
        player.sendMessage((Component)message);
    }

    private void handleQueryPlayer(Player sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot] \u7528\u6cd5: /quiz query <\u73a9\u5bb6\u540d>").color((TextColor)NamedTextColor.RED));
            return;
        }
        String username = args[0];
        PlayerStats stats = this.plugin.getDbManager().getPlayerStatsByUsername(username);
        if (stats == null) {
            sender.sendMessage(Component.text((String)"[\u7b54\u9898Bot] Ta\u8fd8\u6ca1\u6709\u7b54\u9898\u8bb0\u5f55\uff01").color((TextColor)NamedTextColor.YELLOW));
            return;
        }
        BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"=== Ta\u7684\u7b54\u9898\u7edf\u8ba1 ===\n").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)("\u603b\u7b54\u9898\u6570: " + stats.gettotal_attempts() + "\n")).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)("\u7b54\u5bf9\u6b21\u6570: " + stats.getcorrect_daily_rewards() + "\n")).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)("\u62a2\u7b54\u6b21\u6570: " + stats.getquick_daily_rewards() + "\n")).color((TextColor)NamedTextColor.AQUA))).append(Component.text((String)("\u6bcf\u65e5\u5956\u52b1: " + stats.getdaily_rewards() + "\n")).color((TextColor)NamedTextColor.LIGHT_PURPLE))).append(Component.text((String)("\u6700\u540e\u7b54\u9898: " + stats.last_played_date())).color((TextColor)NamedTextColor.GRAY))).build();
        sender.sendMessage((Component)message);
    }

    private void handleLeaderboard(Player player, String[] args) {
        String arg;
        String sortBy = "total";
        int limit = 10;
        if (args.length > 0 && ((arg = args[0].toLowerCase()).equals("total") || arg.equals("correct") || arg.equals("quick") || arg.equals("rewards") || arg.equals("rate"))) {
            sortBy = arg;
        }
        List<PlayerStats> leaderboard = this.plugin.getDbManager().getLeaderboard(sortBy, limit);
        TextComponent.Builder message = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"=== \u7b54\u9898\u6392\u884c\u699c ===\n").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)"\u6392\u5e8f\u65b9\u5f0f: ").color((TextColor)NamedTextColor.YELLOW))).append(((TextComponent)Component.text((String)(this.getSortTypeName(sortBy) + "\n\n")).color((TextColor)NamedTextColor.YELLOW)).decorate(TextDecoration.BOLD));
        for (int i = 0; i < leaderboard.size(); ++i) {
            PlayerStats stats = leaderboard.get(i);
            TextComponent playerName = (TextComponent)((TextComponent)((TextComponent)Component.text((String)(i + 1 + ". " + stats.getusername())).color((TextColor)NamedTextColor.GREEN)).clickEvent(ClickEvent.runCommand((String)("/quiz query " + stats.getusername())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5")));
            TextComponent statValue = switch (sortBy) {
                case "correct" -> (TextComponent)Component.text((String)(" - \u7b54\u5bf9: " + stats.getcorrect_daily_rewards())).color((TextColor)NamedTextColor.GREEN);
                case "quick" -> (TextComponent)Component.text((String)(" - \u62a2\u7b54: " + stats.getquick_daily_rewards())).color((TextColor)NamedTextColor.AQUA);
                case "rewards" -> (TextComponent)Component.text((String)(" - \u5956\u52b1: " + stats.getdaily_rewards())).color((TextColor)NamedTextColor.LIGHT_PURPLE);
                default -> (TextComponent)Component.text((String)(" - \u603b\u7b54\u9898: " + stats.gettotal_attempts())).color((TextColor)NamedTextColor.WHITE);
            };
            ((TextComponent.Builder)((TextComponent.Builder)message.append((Component)playerName)).append((Component)statValue)).append((Component)Component.text((String)"\n"));
        }
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)message.append(Component.text((String)"\n\u6392\u5e8f\u9009\u9879: ").color((TextColor)NamedTextColor.GRAY))).append((Component)this.createSortOption("correct", "\u7b54\u5bf9\u6570", sortBy.equals("correct")))).append((Component)Component.text((String)" | "))).append((Component)this.createSortOption("total", "\u603b\u7b54\u9898", sortBy.equals("total")))).append((Component)Component.text((String)" | "))).append((Component)this.createSortOption("quick", "\u62a2\u7b54\u6570", sortBy.equals("quick")))).append((Component)Component.text((String)" | "))).append((Component)this.createSortOption("rewards", "\u5956\u52b1\u6570", sortBy.equals("rewards")));
        player.sendMessage((Component)message.build());
    }

    private String getSortTypeName(String sortBy) {
        return switch (sortBy) {
            case "correct" -> "\u7b54\u5bf9\u6b21\u6570";
            case "quick" -> "\u62a2\u7b54\u6b21\u6570";
            case "rewards" -> "\u6bcf\u65e5\u5956\u52b1";
            default -> "\u603b\u7b54\u9898\u6570";
        };
    }

    private TextComponent createSortOption(String sortType, String displayName, boolean isActive) {
        return (TextComponent)((TextComponent)((TextComponent)Component.text((String)displayName).color((TextColor)(isActive ? NamedTextColor.GOLD : NamedTextColor.WHITE))).clickEvent(ClickEvent.runCommand((String)("/quiz top " + sortType)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("\u70b9\u51fb\u6309" + displayName + "\u6392\u5e8f"))));
    }

    private void sendPlayerUsage(CommandSender sender) {
        sender.sendMessage(Component.text((String)"=== \u73a9\u5bb6\u547d\u4ee4\u5e2e\u52a9 ===").color((TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"/quiz me - \u67e5\u770b\u6211\u7684\u7b54\u9898\u7edf\u8ba1").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz query <\u73a9\u5bb6> - \u67e5\u8be2\u73a9\u5bb6\u7b54\u9898\u7edf\u8ba1").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz top [total|correct|quick|rewards|rate] - \u67e5\u770b\u6392\u884c\u699c").color((TextColor)NamedTextColor.YELLOW));
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage(Component.text((String)"=== QuizzerBot \u4f7f\u7528\u5e2e\u52a9 ===").color((TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"/quiz ans <\u7b54\u6848> - \u63d0\u4ea4\u7b54\u6848").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz me - \u67e5\u770b\u6211\u7684\u7b54\u9898\u7edf\u8ba1").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz top - \u67e5\u770b\u6392\u884c\u699c").color((TextColor)NamedTextColor.YELLOW));
        if (sender.isOp()) {
            sender.sendMessage(Component.text((String)"/quiz add - \u6dfb\u52a0\u95ee\u9898(\u7ba1\u7406\u5458)").color((TextColor)NamedTextColor.YELLOW));
            sender.sendMessage(Component.text((String)"/quiz delete - \u5220\u9664\u95ee\u9898(\u7ba1\u7406\u5458)").color((TextColor)NamedTextColor.YELLOW));
            sender.sendMessage(Component.text((String)"/quiz toggle - \u542f\u7528/\u7981\u7528\u95ee\u9898(\u7ba1\u7406\u5458)").color((TextColor)NamedTextColor.YELLOW));
            sender.sendMessage(Component.text((String)"/quiz modify - \u4fee\u6539\u95ee\u9898(\u7ba1\u7406\u5458)").color((TextColor)NamedTextColor.YELLOW));
            sender.sendMessage(Component.text((String)"/quiz list - \u5217\u51fa\u95ee\u9898(\u7ba1\u7406\u5458)").color((TextColor)NamedTextColor.YELLOW));
            sender.sendMessage(Component.text((String)"/quiz list [show] [\u9875\u7801] - \u5217\u51fa\u95ee\u9898(\u7ba1\u7406\u5458)").color((TextColor)NamedTextColor.YELLOW));
            sender.sendMessage(Component.text((String)"/quiz detail <ID> - \u67e5\u770b\u95ee\u9898\u8be6\u60c5(\u7ba1\u7406\u5458)").color((TextColor)NamedTextColor.YELLOW));
            sender.sendMessage(Component.text((String)"/quiz reload - \u91cd\u8f7d\u914d\u7f6e(\u7ba1\u7406\u5458)").color((TextColor)NamedTextColor.YELLOW));
            sender.sendMessage(Component.text((String)"=== Issues: yanhy2000@foxmail.com === \n \u516c\u6d4b\u671f\u95f4\u5982\u6709\u95ee\u9898\u8bf7\u53cd\u9988,\u6b63\u5f0f\u7248\u672c\u53d1\u5e03\u540e\u5c06\u5220\u9664\u672c\u6761\u4fe1\u606f ").color((TextColor)NamedTextColor.YELLOW));
        }
    }

    private void sendAdminUsage(CommandSender sender) {
        sender.sendMessage(Component.text((String)"=== QuizzerBot \u7ba1\u7406\u5458\u5e2e\u52a9 ===").color((TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"/quiz add <\u95ee\u9898> <A> <B> <C> <D> <\u6b63\u786e\u7b54\u6848>").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz delete <\u95ee\u9898ID>").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz toggle <\u95ee\u9898ID> <true|false>").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz modify <\u95ee\u9898ID> <\u5b57\u6bb5> <\u65b0\u503c>").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz list [\u9875\u7801]").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz list [show] [\u9875\u7801]").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz detail <ID>").color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(Component.text((String)"/quiz reload").color((TextColor)NamedTextColor.YELLOW));
    }
}

