/*
 * Decompiled with CFR 0.152.
 */
package top.yanhy.quizzerBot;

import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import top.yanhy.quizzerBot.QuizzerBot;

public class ConfigManager {
    private final QuizzerBot plugin;
    private FileConfiguration config;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = (QuizzerBot)plugin;
        plugin.saveDefaultConfig();
    }

    public void loadConfig() {
        this.config = this.plugin.getConfig();
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u6700\u4f4e\u73a9\u5bb6\u9650\u5236: " + this.getMinPlayers());
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u7b54\u9898\u65f6\u95f4: " + this.getAnswerRevealDelaySec());
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u5956\u52b1\u6307\u4ee4: " + String.valueOf(this.getRewardCommands()));
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u6bcf\u65e5\u5956\u52b1\u9650\u5236: " + this.getDailyRewardLimit());
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u89e6\u53d1\u95f4\u9694: " + String.valueOf(this.getTriggerIntervalSec()));
    }

    public void reloadConfig() {
        this.plugin.getQuizManager().reset();
        this.plugin.getDbManager().closeConnection();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        QuizzerBot.log.info("\u91cd\u8f7d\u914d\u7f6e\u6587\u4ef6...");
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u6700\u4f4e\u73a9\u5bb6\u9650\u5236: " + this.getMinPlayers());
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u7b54\u9898\u65f6\u95f4: " + this.getAnswerRevealDelaySec());
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u5956\u52b1\u6307\u4ee4: " + String.valueOf(this.getRewardCommands()));
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u6bcf\u65e5\u5956\u52b1\u9650\u5236: " + this.getDailyRewardLimit());
        QuizzerBot.log.info("\u914d\u7f6e\u9879:\u89e6\u53d1\u95f4\u9694: " + String.valueOf(this.getTriggerIntervalSec()));
        this.plugin.getDbManager().initializeDatabase();
        this.plugin.getSchedulerManager().startQuizScheduler();
    }

    public int getMinPlayers() {
        return this.config.getInt("quiz.min_players", 3);
    }

    public List<Integer> getTriggerIntervalSec() {
        return this.config.getIntegerList("quiz.trigger_interval_sec");
    }

    public int getAnswerRevealDelaySec() {
        return Math.toIntExact(this.config.getLong("quiz.answer_reveal_delay_sec", 60L));
    }

    public List<String> getRewardCommands() {
        return this.config.getStringList("quiz.reward_commands");
    }

    public int getDailyRewardLimit() {
        return Math.toIntExact(this.config.getLong("quiz.daily_reward_limit", 5L));
    }

    public int getPlayerRewardLimit() {
        return Math.toIntExact(this.config.getLong("quiz.player_reward_limit", 3L));
    }

    public int getPlayerQuickAnswerLimit() {
        return Math.toIntExact(this.config.getLong("quiz.player_QuickAnswer_limit", 3L));
    }
}

