/*
 * Decompiled with CFR 0.152.
 */
package top.yanhy.quizzerBot;

import java.lang.runtime.SwitchBootstraps;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import top.yanhy.quizzerBot.PlayerStats;
import top.yanhy.quizzerBot.Question;
import top.yanhy.quizzerBot.QuizzerBot;

public class DatabaseManager {
    private Connection connection;
    private final QuizzerBot plugin;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = (QuizzerBot)plugin;
        this.initializeDatabase();
    }

    public void initializeDatabase() {
        try {
            String url = "jdbc:sqlite:" + this.plugin.getDataFolder().getAbsolutePath() + "/quizzerBook.db";
            this.connection = DriverManager.getConnection(url);
            try (Statement stmt = this.connection.createStatement();){
                String sql = "CREATE TABLE IF NOT EXISTS QuizzerBook (id INTEGER PRIMARY KEY AUTOINCREMENT,quiz TEXT NOT NULL,optA TEXT,optB TEXT,optC TEXT,optD TEXT,answer TEXT NOT NULL,isEnable BOOLEAN NOT NULL DEFAULT TRUE,showCount INTEGER)";
                stmt.execute(sql);
                String createPlayerStatsTable = "CREATE TABLE IF NOT EXISTS PlayerStats (uuid TEXT PRIMARY KEY, username TEXT NOT NULL, total_attempts INTEGER DEFAULT 0, correct_answers INTEGER DEFAULT 0, quick_answers INTEGER DEFAULT 0, daily_rewards INTEGER DEFAULT 0, last_played_date TEXT)";
                stmt.execute(createPlayerStatsTable);
                QuizzerBot.log.info("\u6570\u636e\u5e93\u521d\u59cb\u5316\u5b8c\u6210");
            }
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u6570\u636e\u5e93\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public boolean addQuestion(Question question) {
        String sql = "INSERT INTO QuizzerBook(quiz, optA, optB, optC, optD, answer, isEnable, showCount) VALUES(?,?,?,?,?,?,?,?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, question.getQuiz());
            pstmt.setString(2, question.getOptA());
            pstmt.setString(3, question.getOptB());
            pstmt.setString(4, question.getOptC());
            pstmt.setString(5, question.getOptD());
            pstmt.setString(6, question.getAnswer());
            pstmt.setBoolean(7, true);
            pstmt.setInt(8, 0);
            pstmt.executeUpdate();
            QuizzerBot.log.info("\u6210\u529f\u6dfb\u52a0\u95ee\u9898: " + question.getQuiz());
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u6dfb\u52a0\u95ee\u9898\u5931\u8d25", e);
            return false;
        }
        return true;
    }

    public void deleteQuestion(int id) {
        String sql = "DELETE FROM QuizzerBook WHERE id = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setInt(1, id);
            int affectedRows = pstmt.executeUpdate();
            if (affectedRows > 0) {
                QuizzerBot.log.info("\u6210\u529f\u5220\u9664ID\u4e3a " + id + " \u7684\u95ee\u9898");
            } else {
                QuizzerBot.log.info("\u672a\u627e\u5230ID\u4e3a " + id + " \u7684\u95ee\u9898");
            }
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u5220\u9664\u95ee\u9898\u5931\u8d25", e);
        }
    }

    public void updateQuestion(Question question) {
        String sql = "UPDATE QuizzerBook SET quiz = ?, optA = ?, optB = ?, optC = ?, optD = ?, answer = ?, isEnable = ?, showCount = ? WHERE id = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, question.getQuiz());
            pstmt.setString(2, question.getOptA());
            pstmt.setString(3, question.getOptB());
            pstmt.setString(4, question.getOptC());
            pstmt.setString(5, question.getOptD());
            pstmt.setString(6, question.getAnswer());
            pstmt.setBoolean(7, question.isEnable());
            pstmt.setInt(8, question.getShowCount());
            pstmt.setInt(9, question.getId());
            int affectedRows = pstmt.executeUpdate();
            if (affectedRows > 0) {
                QuizzerBot.log.info("\u6210\u529f\u66f4\u65b0ID\u4e3a " + question.getId() + " \u7684\u95ee\u9898");
            } else {
                QuizzerBot.log.info("\u672a\u627e\u5230ID\u4e3a " + question.getId() + " \u7684\u95ee\u9898");
            }
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u66f4\u65b0\u95ee\u9898\u5931\u8d25", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean toggleQuestion(Integer id, Boolean isEnable) {
        String sql = "UPDATE QuizzerBook SET isEnable = ? WHERE id = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setBoolean(1, isEnable);
            pstmt.setInt(2, id);
            int affectedRows = pstmt.executeUpdate();
            if (affectedRows > 0) {
                QuizzerBot.log.info("\u6210\u529f\u5207\u6362ID\u4e3a " + id + " \u7684\u72b6\u6001\u4e3a" + isEnable);
                Boolean bl2 = true;
                return bl2;
            }
            QuizzerBot.log.info("\u5207\u6362\u5931\u8d25,\u672a\u627e\u5230ID\u4e3a " + id + " \u7684\u95ee\u9898");
            Boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u5207\u6362\u95ee\u9898\u5f00\u5173\u5931\u8d25", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateQuestionField(int id, String field, Object value) {
        Set<String> allowedFields = Set.of("quiz", "optA", "optB", "optC", "optD", "answer", "isEnable", "showCount");
        if (!allowedFields.contains(field)) {
            this.plugin.getLogger().warning("\u5c1d\u8bd5\u66f4\u65b0\u4e0d\u5141\u8bb8\u7684\u5b57\u6bb5: " + field);
            return false;
        }
        String sql = "UPDATE QuizzerBook SET " + field + " = ? WHERE id = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            boolean bl = false;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, String.class, Boolean.class}, (Object)object2, bl ? 1 : 0)) {
                case 0: {
                    Integer i = (Integer)object2;
                    pstmt.setInt(1, i);
                    break;
                }
                case 1: {
                    String s = (String)object2;
                    pstmt.setString(1, s);
                    break;
                }
                case 2: {
                    Boolean b = (Boolean)object2;
                    pstmt.setBoolean(1, b);
                    break;
                }
                default: {
                    this.plugin.getLogger().warning("\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b: " + value.getClass().getName());
                    boolean bl2 = false;
                    return bl2;
                }
            }
            pstmt.setInt(2, id);
            int affectedRows = pstmt.executeUpdate();
            if (affectedRows > 0) {
                this.plugin.getLogger().info("\u6210\u529f\u66f4\u65b0\u95ee\u9898ID " + id + " \u7684\u5b57\u6bb5 " + field);
                bl = true;
                return bl;
            }
            this.plugin.getLogger().info("\u672a\u627e\u5230ID\u4e3a " + id + " \u7684\u95ee\u9898");
            bl = false;
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u66f4\u65b0\u95ee\u9898\u5b57\u6bb5\u5931\u8d25", e);
            return false;
        }
    }

    public List<Question> getQuestions(int page, int perPage, String sortBy) {
        ArrayList<Question> questions = new ArrayList<Question>();
        Object sql = "SELECT * FROM QuizzerBook";
        if (sortBy != null) {
            if (sortBy.equalsIgnoreCase("show")) {
                sql = (String)sql + " ORDER BY showCount DESC";
            }
        } else {
            sql = (String)sql + " ORDER BY id ASC";
        }
        sql = (String)sql + " LIMIT ? OFFSET ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement((String)sql);){
            pstmt.setInt(1, perPage);
            pstmt.setInt(2, (page - 1) * perPage);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Question question = new Question(rs.getInt("id"), rs.getString("quiz"), rs.getString("optA"), rs.getString("optB"), rs.getString("optC"), rs.getString("optD"), rs.getString("answer"), rs.getBoolean("isEnable"), rs.getInt("showCount"));
                questions.add(question);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u83b7\u53d6\u95ee\u9898\u5217\u8868\u5931\u8d25", e);
        }
        return questions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Question getQuestionById(int id) {
        String sql = "SELECT * FROM QuizzerBook WHERE id = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setInt(1, id);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            Question question = new Question(rs.getInt("id"), rs.getString("quiz"), rs.getString("optA"), rs.getString("optB"), rs.getString("optC"), rs.getString("optD"), rs.getString("answer"), rs.getBoolean("isEnable"), rs.getInt("showCount"));
            return question;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u83b7\u53d6\u95ee\u9898\u8be6\u60c5\u5931\u8d25", e);
        }
        return null;
    }

    public Question getRandomQuestion() {
        ArrayList<Question> questions = new ArrayList<Question>();
        String selectSql = "SELECT * FROM QuizzerBook WHERE isEnable = TRUE";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                questions.add(new Question(rs.getInt("id"), rs.getString("quiz"), rs.getString("optA"), rs.getString("optB"), rs.getString("optC"), rs.getString("optD"), rs.getString("answer"), rs.getBoolean("isEnable"), rs.getInt("showCount")));
            }
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u83b7\u53d6\u95ee\u9898\u5217\u8868\u5931\u8d25", e);
            return null;
        }
        if (questions.isEmpty()) {
            return null;
        }
        int[] weights = new int[questions.size()];
        int minShowCount = questions.stream().mapToInt(Question::getShowCount).min().orElse(0);
        for (int i = 0; i < questions.size(); ++i) {
            weights[i] = ((Question)questions.get(i)).getShowCount() - minShowCount + 1;
        }
        Question selectedQuestion = this.weightedRandomSelect(questions, weights);
        if (selectedQuestion != null) {
            String updateSql = "UPDATE QuizzerBook SET showCount = showCount + 1 WHERE id = ?";
            try (PreparedStatement pstmt = this.connection.prepareStatement(updateSql);){
                pstmt.setInt(1, selectedQuestion.getId());
                pstmt.executeUpdate();
                selectedQuestion.setShowCount(selectedQuestion.getShowCount() + 1);
            }
            catch (SQLException e) {
                QuizzerBot.log.log(Level.SEVERE, "\u66f4\u65b0\u95ee\u9898\u5c55\u793a\u6b21\u6570\u5931\u8d25", e);
            }
        }
        return selectedQuestion;
    }

    private Question weightedRandomSelect(List<Question> questions, int[] weights) {
        int totalWeight = 0;
        for (int weight : weights) {
            totalWeight += weight;
        }
        int random = (int)(Math.random() * (double)totalWeight);
        int cumulativeWeight = 0;
        for (int i = 0; i < questions.size(); ++i) {
            if (random >= (cumulativeWeight += weights[i])) continue;
            return questions.get(i);
        }
        return questions.getLast();
    }

    public void initPlayerData(UUID uuid, String username) {
        String sql = "INSERT OR IGNORE INTO PlayerStats (uuid, username) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET username = excluded.username";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u521d\u59cb\u5316\u73a9\u5bb6\u6570\u636e\u5931\u8d25", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlayerStats getPlayerStats(UUID uuid) {
        String sql = "SELECT * FROM PlayerStats WHERE uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            PlayerStats playerStats = new PlayerStats(rs.getString("uuid"), rs.getString("username"), rs.getInt("total_attempts"), rs.getInt("correct_answers"), rs.getInt("quick_answers"), rs.getInt("daily_rewards"), rs.getString("last_played_date"));
            return playerStats;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u83b7\u53d6\u73a9\u5bb6\u7edf\u8ba1\u5931\u8d25", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlayerStats getPlayerStatsByUsername(String username) {
        String sql = "SELECT * FROM PlayerStats WHERE username = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, username);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            PlayerStats playerStats = new PlayerStats(rs.getString("uuid"), rs.getString("username"), rs.getInt("total_attempts"), rs.getInt("correct_answers"), rs.getInt("quick_answers"), rs.getInt("daily_rewards"), rs.getString("last_played_date"));
            return playerStats;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u83b7\u53d6\u73a9\u5bb6\u7edf\u8ba1\u5931\u8d25", e);
        }
        return null;
    }

    public void updatePlayerStats(PlayerStats stats) {
        String sql = "INSERT OR REPLACE INTO PlayerStats (uuid, username, total_attempts, correct_answers, quick_answers, daily_rewards, last_played_date) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, stats.getuuid());
            pstmt.setString(2, stats.getusername());
            pstmt.setInt(3, stats.gettotal_attempts());
            pstmt.setInt(4, stats.getcorrect_daily_rewards());
            pstmt.setInt(5, stats.getquick_daily_rewards());
            pstmt.setInt(6, stats.getdaily_rewards());
            pstmt.setString(7, stats.last_played_date());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u66f4\u65b0\u73a9\u5bb6\u7edf\u8ba1\u5931\u8d25", e);
        }
    }

    public List<PlayerStats> getLeaderboard(String sortBy, int limit) {
        ArrayList<PlayerStats> leaderboard = new ArrayList<PlayerStats>();
        String sql = DatabaseManager.getString(sortBy);
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setInt(1, limit);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                PlayerStats stats = new PlayerStats(rs.getString("uuid"), rs.getString("username"), rs.getInt("total_attempts"), rs.getInt("correct_answers"), rs.getInt("quick_answers"), rs.getInt("daily_rewards"), rs.getString("last_played_date"));
                leaderboard.add(stats);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u83b7\u53d6\u6392\u884c\u699c\u5931\u8d25", e);
        }
        return leaderboard;
    }

    @NotNull
    private static String getString(String sortBy) {
        Object sql = "SELECT * FROM PlayerStats ";
        switch (sortBy.toLowerCase()) {
            case "total": {
                sql = (String)sql + "ORDER BY total_attempts DESC";
                break;
            }
            case "correct": {
                sql = (String)sql + "ORDER BY correct_answers DESC";
                break;
            }
            case "quick": {
                sql = (String)sql + "ORDER BY quick_answers DESC";
                break;
            }
            case "rewards": {
                sql = (String)sql + "ORDER BY daily_rewards DESC";
                break;
            }
            default: {
                sql = (String)sql + "ORDER BY (correct_answers * 1.0 / NULLIF(total_attempts, 0)) DESC";
            }
        }
        sql = (String)sql + " LIMIT ?";
        return sql;
    }

    public boolean incrementDailyRewards(UUID uuid) {
        boolean bl;
        block8: {
            this.resetDailyStatsIfNeeded(uuid);
            int dailyLimit = this.plugin.getConfigManager().getDailyRewardLimit();
            String sql = "UPDATE PlayerStats SET daily_rewards = daily_rewards + 1 WHERE uuid = ? AND daily_rewards < ?";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, uuid.toString());
                pstmt.setInt(2, dailyLimit);
                boolean bl2 = bl = pstmt.executeUpdate() > 0;
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    QuizzerBot.log.log(Level.SEVERE, "\u589e\u52a0\u6bcf\u65e5\u5956\u52b1\u8ba1\u6570\u5931\u8d25", e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public int getDailyRewardsCount(UUID uuid) {
        int n;
        block8: {
            this.resetDailyStatsIfNeeded(uuid);
            String sql = "SELECT daily_rewards FROM PlayerStats WHERE uuid = ?";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, uuid.toString());
                ResultSet rs = pstmt.executeQuery();
                int n2 = n = rs.next() ? rs.getInt("daily_rewards") : 0;
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    QuizzerBot.log.log(Level.SEVERE, "\u83b7\u53d6\u6bcf\u65e5\u5956\u52b1\u8ba1\u6570\u5931\u8d25", e);
                    return 0;
                }
            }
            pstmt.close();
        }
        return n;
    }

    private void resetDailyStatsIfNeeded(UUID uuid) {
        String currentDate = LocalDate.now().toString();
        String sql = "UPDATE PlayerStats SET daily_rewards = 0, last_played_date = ? WHERE uuid = ? AND (last_played_date IS NULL OR last_played_date != ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, currentDate);
            pstmt.setString(2, uuid.toString());
            pstmt.setString(3, currentDate);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u91cd\u7f6e\u6bcf\u65e5\u6570\u636e\u5931\u8d25", e);
        }
    }

    public void incrementPlayerStats(UUID uuid, int attemptsIncrement, int correctIncrement, int quickIncrement) {
        this.resetDailyStatsIfNeeded(uuid);
        String sql = "UPDATE PlayerStats SET total_attempts = total_attempts + ?, correct_answers = correct_answers + ?, quick_answers = quick_answers + ? WHERE uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setInt(1, attemptsIncrement);
            pstmt.setInt(2, correctIncrement);
            pstmt.setInt(3, quickIncrement);
            pstmt.setString(4, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u6279\u91cf\u66f4\u65b0\u73a9\u5bb6\u6570\u636e\u5931\u8d25", e);
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                QuizzerBot.log.info("\u6570\u636e\u5e93\u8fde\u63a5\u5df2\u5173\u95ed");
            }
        }
        catch (SQLException e) {
            QuizzerBot.log.log(Level.SEVERE, "\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u9519", e);
        }
    }
}

