/*
 * Decompiled with CFR 0.152.
 */
package top.yanhy.quizzerBot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import top.yanhy.quizzerBot.DatabaseManager;
import top.yanhy.quizzerBot.Question;
import top.yanhy.quizzerBot.QuizzerBot;

public class QuizManager {
    private final QuizzerBot plugin;
    private Question currentQuestion;
    private final HashMap<UUID, Boolean> quickAnswerPlayers = new HashMap();
    private final HashMap<UUID, String> playerAnswers;

    public QuizManager(QuizzerBot plugin) {
        this.plugin = plugin;
        this.playerAnswers = new HashMap();
    }

    public void startNewQuiz() {
        this.playerAnswers.clear();
        this.quickAnswerPlayers.clear();
        this.currentQuestion = this.plugin.getDbManager().getRandomQuestion();
        if (this.currentQuestion == null) {
            this.plugin.getLogger().warning("\u6ca1\u6709\u53ef\u7528\u7684\u9898\u76ee\u6216\u83b7\u53d6\u9898\u76ee\u5931\u8d25\uff01");
            return;
        }
        this.broadcastQuizQuestion();
        this.plugin.getSchedulerManager().startAnswerTimer();
    }

    public void endQuiz() {
        Player player;
        if (this.currentQuestion == null) {
            return;
        }
        String correctAnswer = this.currentQuestion.getAnswer().toUpperCase();
        ArrayList<UUID> quickCorrectPlayers = new ArrayList<UUID>();
        ArrayList<UUID> CorrectPlayers = new ArrayList<UUID>();
        DatabaseManager dbManager = this.plugin.getDbManager();
        int RewardLimit = this.plugin.getConfigManager().getPlayerRewardLimit();
        for (UUID playerId : this.playerAnswers.keySet()) {
            Player player2 = Bukkit.getPlayer((UUID)playerId);
            if (player2 == null || !player2.isOnline()) continue;
            String playerAnswer = this.playerAnswers.get(playerId);
            boolean isCorrect = playerAnswer.equalsIgnoreCase(correctAnswer);
            boolean isQuickAnswer = this.quickAnswerPlayers.containsKey(playerId);
            dbManager.incrementPlayerStats(playerId, 1, isCorrect ? 1 : 0, isQuickAnswer ? 1 : 0);
            if (isCorrect) {
                if (isQuickAnswer) {
                    quickCorrectPlayers.add(playerId);
                } else {
                    CorrectPlayers.add(playerId);
                }
            }
            if (isQuickAnswer) {
                player2.sendMessage(Component.text((String)(isCorrect ? "[\u7b54\u9898Bot] \u62a2\u7b54\u6b63\u786e\uff01" : "[\u7b54\u9898Bot] \u62a2\u7b54\u9519\u8bef~")).color((TextColor)(isCorrect ? NamedTextColor.GOLD : NamedTextColor.RED)));
                continue;
            }
            player2.sendMessage(Component.text((String)(isCorrect ? "[\u7b54\u9898Bot] \u56de\u7b54\u6b63\u786e\uff01" : "[\u7b54\u9898Bot] \u56de\u7b54\u9519\u8bef~")).color((TextColor)(isCorrect ? NamedTextColor.GREEN : NamedTextColor.RED)));
        }
        int rewardsGiven = 0;
        for (UUID playerId : quickCorrectPlayers) {
            if (rewardsGiven >= RewardLimit) break;
            player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) continue;
            this.giveReward(player);
            ++rewardsGiven;
        }
        for (UUID playerId : CorrectPlayers) {
            if (rewardsGiven >= RewardLimit) break;
            player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) continue;
            this.giveReward(player);
            ++rewardsGiven;
        }
        this.plugin.getServer().broadcast(Component.text((String)String.format("[\u7b54\u9898Bot] \u7b54\u6848\u63ed\u6653: \u3010%s\u3011! \u62a2\u7b54\u6b63\u786e: %d\u4eba, \u666e\u901a\u56de\u7b54\u6b63\u786e: %d\u4eba, \u5171\u53d1\u653e\u5956\u52b1: %d\u4eba", correctAnswer, quickCorrectPlayers.size(), CorrectPlayers.size(), rewardsGiven)).color((TextColor)NamedTextColor.GOLD));
        this.currentQuestion = null;
        this.playerAnswers.clear();
        this.quickAnswerPlayers.clear();
    }

    public void submitAnswer(Player player, String answer) {
        int QUICK_ANSWER_LIMIT = this.plugin.getConfigManager().getPlayerQuickAnswerLimit();
        if (!this.isQuizActive()) {
            player.sendMessage(Component.text((String)"[\u7b54\u9898Bot] \u5f53\u524d\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u7b54\u9898\u6d3b\u52a8\uff01").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (this.playerAnswers.containsKey(player.getUniqueId())) {
            player.sendMessage(Component.text((String)"[\u7b54\u9898Bot] \u60a8\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u7b54\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u4f5c\u7b54\uff01").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (answer == null || answer.length() != 1) {
            player.sendMessage(Component.text((String)"[\u7b54\u9898Bot] \u7b54\u6848\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165A/B/C/D\u4e2d\u7684\u4e00\u4e2a\u5b57\u6bcd\uff01").color((TextColor)NamedTextColor.RED));
            return;
        }
        try {
            String upperAnswer = answer.toUpperCase();
            this.playerAnswers.put(player.getUniqueId(), upperAnswer);
            this.plugin.getDbManager().initPlayerData(player.getUniqueId(), player.getName());
            if (this.quickAnswerPlayers.size() < QUICK_ANSWER_LIMIT) {
                this.quickAnswerPlayers.put(player.getUniqueId(), false);
                int currentCount = this.quickAnswerPlayers.size();
                String message = String.format("[\u7b54\u9898Bot] %s \u62a2\u7b54\u6210\u529f\uff01[%d/%d]", player.getName(), currentCount, QUICK_ANSWER_LIMIT);
                this.plugin.getServer().broadcast(Component.text((String)message).color((TextColor)NamedTextColor.YELLOW));
            } else {
                String message = String.format("[\u7b54\u9898Bot] %s \u63d0\u4ea4\u4e86\u7b54\u6848\uff01", player.getName());
                this.plugin.getServer().broadcast(Component.text((String)message).color((TextColor)NamedTextColor.YELLOW));
            }
            player.sendMessage(Component.text((String)("[\u7b54\u9898Bot] \u7b54\u6848 " + answer + " \u5df2\u63d0\u4ea4\uff01")).color((TextColor)NamedTextColor.GREEN));
        }
        catch (Exception e) {
            QuizzerBot.log.warning("\u62a2\u7b54\u65f6\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
        }
    }

    public boolean isQuizActive() {
        return this.currentQuestion != null;
    }

    public Question getCurrentQuestion() {
        return this.currentQuestion;
    }

    private void broadcastQuizQuestion() {
        if (this.currentQuestion == null) {
            return;
        }
        this.plugin.getServer().broadcast(Component.text((String)"[\u7b54\u9898Bot] \u7b54\u9898\u65f6\u95f4\u5230~").color((TextColor)NamedTextColor.GOLD));
        this.plugin.getServer().broadcast(this.currentQuestion.getFormattedQuestion());
        this.plugin.getServer().broadcast(Component.text((String)("\u7b54\u6848\u5728 " + this.plugin.getConfigManager().getAnswerRevealDelaySec() + "s \u540e\u63ed\u6653\uff0c\u3010\u70b9\u51fb\u9009\u9879\u3011\u5373\u53ef\u7b54\u9898\n")).color((TextColor)NamedTextColor.GREEN));
    }

    private void giveReward(Player player) {
        try {
            DatabaseManager dbManager = this.plugin.getDbManager();
            int dailyRewards = dbManager.getDailyRewardsCount(player.getUniqueId());
            int dailyLimit = this.plugin.getConfigManager().getDailyRewardLimit();
            if (dailyRewards >= dailyLimit) {
                player.sendMessage((Component)Component.text((String)String.format("\u00a7c[\u7b54\u9898Bot] \u4eca\u65e5\u5956\u52b1\u5df2\u8fbe\u4e0a\u9650(%d/%d)\uff0c\u8bf7\u660e\u5929\u518d\u6765\uff01", dailyRewards, dailyLimit)));
                return;
            }
            List<String> commands = this.plugin.getConfigManager().getRewardCommands();
            if (commands == null || commands.isEmpty()) {
                player.sendMessage((Component)Component.text((String)"\u00a7c[\u7b54\u9898Bot] \u5956\u52b1\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
                return;
            }
            if (!dbManager.incrementDailyRewards(player.getUniqueId())) {
                player.sendMessage((Component)Component.text((String)"\u00a7c[\u7b54\u9898Bot] \u5956\u52b1\u53d1\u653e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
                return;
            }
            for (String cmd : commands) {
                try {
                    String processedCmd = cmd.trim().replace("%player%", player.getName());
                    if (processedCmd.isEmpty()) continue;
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processedCmd);
                }
                catch (Exception e) {
                    QuizzerBot.log.warning("\u5956\u52b1\u6307\u4ee4\u6267\u884c\u51fa\u9519: " + cmd + " " + String.valueOf(e));
                    player.sendMessage((Component)Component.text((String)"\u00a7c[\u7b54\u9898Bot] \u90e8\u5206\u5956\u52b1\u53d1\u653e\u5931\u8d25"));
                }
            }
            int remaining = dailyLimit - (dailyRewards + 1);
            player.sendMessage((Component)Component.text((String)String.format("\u00a7a[\u7b54\u9898Bot] \u5956\u52b1\u5df2\u53d1\u653e\uff01\u4eca\u65e5\u8fd8\u53ef\u83b7\u5f97 %d \u6b21\u5956\u52b1", remaining)));
        }
        catch (Exception e) {
            QuizzerBot.log.warning("\u53d1\u653e\u5956\u52b1\u65f6\u53d1\u751f\u9519\u8bef" + String.valueOf(e));
            player.sendMessage((Component)Component.text((String)"\u00a7c[\u7b54\u9898Bot] \u5956\u52b1\u7cfb\u7edf\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
    }

    public HashMap<UUID, String> getPlayerAnswers() {
        return this.playerAnswers;
    }

    public void stop() {
        this.currentQuestion = null;
        this.playerAnswers.clear();
        this.quickAnswerPlayers.clear();
        Component resetMessage = Component.text((String)"[\u7b54\u9898Bot] \u7b54\u9898\u7cfb\u7edf\u5df2\u5173\u95ed\uff0c\u6240\u6709\u8fdb\u884c\u4e2d\u7684\u7b54\u9898\u5df2\u53d6\u6d88\uff01").color((TextColor)NamedTextColor.RED);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.playerAnswers.containsKey(player.getUniqueId())) continue;
            player.sendMessage(resetMessage);
        }
        QuizzerBot.log.info("\u7b54\u9898\u7cfb\u7edf\u5df2\u5b8c\u5168\u5173\u95ed\uff0c\u6240\u6709\u72b6\u6001\u5df2\u6e05\u7a7a");
        this.plugin.getSchedulerManager().shutdown();
    }

    public void start() {
        this.reset();
        if (this.plugin.getConfigManager() == null || this.plugin.getSchedulerManager() == null) {
            QuizzerBot.log.severe("\u7b54\u9898\u7cfb\u7edf\u542f\u52a8\u5931\u8d25\uff1a\u4f9d\u8d56\u7ec4\u4ef6\u672a\u521d\u59cb\u5316");
            return;
        }
        try {
            this.plugin.getSchedulerManager().startQuizScheduler();
            QuizzerBot.log.info("\u7b54\u9898\u7cfb\u7edf\u5df2\u6210\u529f\u542f\u52a8");
        }
        catch (Exception e) {
            QuizzerBot.log.severe("\u7b54\u9898\u7cfb\u7edf\u542f\u52a8\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void reset() {
        this.currentQuestion = null;
        this.playerAnswers.clear();
        this.quickAnswerPlayers.clear();
        try {
            this.plugin.getSchedulerManager().reset();
            QuizzerBot.log.info("\u7b54\u9898\u7cfb\u7edf\u72b6\u6001\u5df2\u91cd\u7f6e");
        }
        catch (Exception e) {
            QuizzerBot.log.severe("\u91cd\u7f6e\u8c03\u5ea6\u5668\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

