/*
 * Decompiled with CFR 0.152.
 */
package top.yanhy.quizzerBot;

import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import top.yanhy.quizzerBot.CommandHandler;
import top.yanhy.quizzerBot.ConfigManager;
import top.yanhy.quizzerBot.DatabaseManager;
import top.yanhy.quizzerBot.QuizListener;
import top.yanhy.quizzerBot.QuizManager;
import top.yanhy.quizzerBot.SchedulerManager;

public final class QuizzerBot
extends JavaPlugin {
    public static final String PLUGIN_ID = "QuizzerBot";
    public static final Logger log = Logger.getLogger("QuizzerBot");
    public static final String VERSION = "v1.0.1";
    public Boolean botEnable = true;
    private QuizManager quizManager;
    private DatabaseManager dbManager;
    private ConfigManager configManager;
    private SchedulerManager schedulerManager;
    private CommandHandler commandHandler;

    public void onEnable() {
        log.info("QuizzerBot version v1.0.1 is enabled!");
        log.info("Issues: yanhy2000@foxmail.com \u516c\u6d4b\u671f\u95f4\u5982\u6709\u95ee\u9898\u8bf7\u53cd\u9988,\u6b63\u5f0f\u7248\u672c\u53d1\u5e03\u540e\u5c06\u5220\u9664\u672c\u6761\u4fe1\u606f");
        log.info("\u6d4b\u8bd5\u7248\u4fe1\u606f\u4ec5\u51fa\u73b0\u5728\u521d\u59cb\u5316\u65e5\u5fd7\u4e0eOP\u5e2e\u52a9\u83dc\u5355\u5185,\u4e0d\u5f71\u54cd\u6e38\u73a9\u4e0e\u4f7f\u7528");
        this.configManager = new ConfigManager(this);
        this.dbManager = new DatabaseManager(this);
        this.quizManager = new QuizManager(this);
        this.schedulerManager = new SchedulerManager(this);
        this.commandHandler = new CommandHandler(this);
        this.configManager.loadConfig();
        this.schedulerManager.initialize();
        this.quizManager.start();
        this.getServer().getPluginManager().registerEvents((Listener)new QuizListener(this), (Plugin)this);
        PluginCommand command = this.getCommand("quiz");
        if (command != null) {
            command.setExecutor((CommandExecutor)this.commandHandler);
            command.setTabCompleter((TabCompleter)this.commandHandler);
        } else {
            this.getLogger().severe("Failed to register command 'quiz': Command not found in plugin.yml");
        }
    }

    public void onDisable() {
        log.info("QuizzerBot is disabled!");
        if (this.schedulerManager != null) {
            this.schedulerManager.shutdown();
        }
        this.quizManager.reset();
        this.dbManager.closeConnection();
    }

    public QuizManager getQuizManager() {
        return this.quizManager;
    }

    public DatabaseManager getDbManager() {
        return this.dbManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public SchedulerManager getSchedulerManager() {
        return this.schedulerManager;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }
}

