/*
 * Decompiled with CFR 0.152.
 */
package top.yanhy.quizzerBot;

import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import top.yanhy.quizzerBot.QuizzerBot;

public class SchedulerManager {
    private final QuizzerBot plugin;
    private final Random random = new Random();
    private ScheduledExecutorService scheduler;
    private final AtomicLong quizStartTime = new AtomicLong(0L);
    private volatile boolean isQuizActive = false;

    public SchedulerManager(QuizzerBot plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        if (this.scheduler == null || this.scheduler.isShutdown()) {
            this.scheduler = Executors.newScheduledThreadPool(2);
        }
    }

    public void startQuizScheduler() {
        this.cancelAllTasks();
        long delaySeconds = this.getRandomDelayInSeconds();
        this.scheduler.schedule(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            int minPlayers = this.plugin.getConfigManager().getMinPlayers();
            int onlinePlayers = Bukkit.getOnlinePlayers().size();
            if (onlinePlayers >= minPlayers && !this.isQuizActive) {
                this.plugin.getQuizManager().startNewQuiz();
                this.quizStartTime.set(System.currentTimeMillis());
                this.isQuizActive = true;
                this.scheduleNextQuiz();
            } else {
                QuizzerBot.log.info("\u73a9\u5bb6\u6570\u91cf\u4e0d\u8db3(" + onlinePlayers + "/" + minPlayers + ")\u6216\u7b54\u9898\u8fdb\u884c\u4e2d");
                this.scheduleNextQuiz();
            }
        }), delaySeconds, TimeUnit.SECONDS);
    }

    public void startAnswerTimer() {
        int answerTime = this.plugin.getConfigManager().getAnswerRevealDelaySec();
        this.scheduler.schedule(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getQuizManager().endQuiz();
            this.isQuizActive = false;
        }), (long)answerTime, TimeUnit.SECONDS);
    }

    private void scheduleNextQuiz() {
        long delaySeconds = this.getRandomDelayInSeconds();
        this.scheduler.schedule(this::startQuizScheduler, delaySeconds, TimeUnit.SECONDS);
    }

    private long getRandomDelayInSeconds() {
        try {
            int min = this.plugin.getConfigManager().getTriggerIntervalSec().get(0);
            int max = this.plugin.getConfigManager().getTriggerIntervalSec().get(1);
            if (max == min) {
                return min;
            }
            return min + this.random.nextInt(max - min + 1);
        }
        catch (Exception ignored) {
            QuizzerBot.log.warning("\u968f\u673a\u89e6\u53d1\u65f6\u95f4\u6bb5\u8bbe\u7f6e\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6! \u5c06\u4f7f\u7528\u9ed8\u8ba4\u65f6\u95f4\u6bb5\u968f\u673a");
            int min = 600;
            int max = 900;
            return min + this.random.nextInt(max - min + 1);
        }
    }

    public void startQuizNow() {
        this.scheduler.schedule(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!this.isQuizActive) {
                this.plugin.getQuizManager().startNewQuiz();
                this.quizStartTime.set(System.currentTimeMillis());
                this.isQuizActive = true;
            }
        }), 3L, TimeUnit.SECONDS);
    }

    public void cancelAllTasks() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
        this.initialize();
    }

    public void shutdown() {
        this.isQuizActive = false;
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public void reset() {
        this.isQuizActive = false;
        this.quizStartTime.set(0L);
        this.cancelAllTasks();
    }
}

