/*
 * Decompiled with CFR 0.152.
 */
package com.gahaha.entitycount.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static final Path CONFIG_FILE = Paths.get("config", "entitycount.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonObject configJson = new JsonObject();
    private static boolean showEntitiesCount = true;
    private static String entityType = "All";
    private static String listMode = "Blacklist";
    private static float scale = 10.0f;
    private static int textColor = -1;
    private static int backgroundColor = 1065386112;
    private static float x = 0.01f;
    private static float y = 0.01f;
    private static int maxListLength = -1;
    private static int threshold = -1;
    private static List<String> whiteList = List.of();
    private static List<String> blackList = List.of();

    public static boolean getShowEntitiesCount() {
        return showEntitiesCount;
    }

    public static void setShowEntitiesCount(boolean showEntitiesCount) {
        ConfigManager.showEntitiesCount = showEntitiesCount;
        configJson.addProperty("showEntitiesCount", Boolean.valueOf(showEntitiesCount));
        ConfigManager.writeJson();
    }

    public static String getEntityType() {
        return entityType;
    }

    public static void setEntityType(String entityType) {
        ConfigManager.entityType = entityType;
        configJson.addProperty("entityType", entityType);
        ConfigManager.writeJson();
    }

    public static String getListMode() {
        return listMode;
    }

    public static void setListMode(String listMode) {
        ConfigManager.listMode = listMode;
        configJson.addProperty("listMode", listMode);
        ConfigManager.writeJson();
    }

    public static List<String> getWhiteList() {
        return whiteList;
    }

    public static void setWhiteList(List<String> whiteList) {
        ConfigManager.whiteList = whiteList;
        configJson.add("whiteList", GSON.toJsonTree(whiteList));
        ConfigManager.writeJson();
    }

    public static List<String> getBlackList() {
        return blackList;
    }

    public static void setBlackList(List<String> blackList) {
        ConfigManager.blackList = blackList;
        configJson.add("blackList", GSON.toJsonTree(blackList));
        ConfigManager.writeJson();
    }

    public static float getScale() {
        return scale;
    }

    public static void setScale(float scale) {
        ConfigManager.scale = scale;
        configJson.addProperty("scale", (Number)Float.valueOf(scale));
        ConfigManager.writeJson();
    }

    public static int getTextColor() {
        return textColor;
    }

    public static void setTextColor(int textColor) {
        ConfigManager.textColor = textColor;
        configJson.addProperty("textColor", (Number)textColor);
        ConfigManager.writeJson();
    }

    public static int getBackgroundColor() {
        return backgroundColor;
    }

    public static void setBackgroundColor(int backgroundColor) {
        ConfigManager.backgroundColor = backgroundColor;
        configJson.addProperty("backgroundColor", (Number)backgroundColor);
        ConfigManager.writeJson();
    }

    public static float getX() {
        return x;
    }

    public static void setX(float x) {
        x = Math.max(0.0f, x);
        ConfigManager.x = x = Math.min(1.0f, x);
        configJson.addProperty("x", (Number)Float.valueOf(x));
        ConfigManager.writeJson();
    }

    public static float getY() {
        return y;
    }

    public static void setY(float y) {
        y = Math.max(0.0f, y);
        ConfigManager.y = y = Math.min(1.0f, y);
        configJson.addProperty("y", (Number)Float.valueOf(y));
        ConfigManager.writeJson();
    }

    public static int getMaxListLength() {
        return maxListLength;
    }

    public static void setMaxListLength(int maxListLength) {
        ConfigManager.maxListLength = maxListLength;
        configJson.addProperty("maxListLength", (Number)maxListLength);
        ConfigManager.writeJson();
    }

    public static int getThreshold() {
        return threshold;
    }

    public static void setThreshold(int threshold) {
        ConfigManager.threshold = threshold;
        configJson.addProperty("threshold", (Number)threshold);
        ConfigManager.writeJson();
    }

    public static void reset() {
        ConfigManager.setShowEntitiesCount(true);
        ConfigManager.setEntityType("All");
        ConfigManager.setListMode("Blacklist");
        ConfigManager.setWhiteList(List.of());
        ConfigManager.setBlackList(List.of());
        ConfigManager.setScale(10.0f);
        ConfigManager.setTextColor(-1);
        ConfigManager.setBackgroundColor(1065386112);
        ConfigManager.setX(0.01f);
        ConfigManager.setY(0.01f);
        ConfigManager.setMaxListLength(-1);
        ConfigManager.setThreshold(-1);
    }

    public static void init() {
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            ConfigManager.load();
        } else {
            ConfigManager.reset();
            ConfigManager.writeJson();
        }
    }

    public static void load() {
        try {
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                JsonObject loadedJson = (JsonObject)GSON.fromJson((Reader)Files.newBufferedReader(CONFIG_FILE, StandardCharsets.UTF_8), JsonObject.class);
                if (loadedJson.has("showEntitiesCount")) {
                    ConfigManager.setShowEntitiesCount(loadedJson.get("showEntitiesCount").getAsBoolean());
                }
                if (loadedJson.has("entityType")) {
                    ConfigManager.setEntityType(loadedJson.get("entityType").getAsString());
                }
                if (loadedJson.has("listMode")) {
                    ConfigManager.setListMode(loadedJson.get("listMode").getAsString());
                }
                if (loadedJson.has("whiteList")) {
                    ConfigManager.setWhiteList((List)GSON.fromJson(loadedJson.get("whiteList"), List.class));
                }
                if (loadedJson.has("blackList")) {
                    ConfigManager.setBlackList((List)GSON.fromJson(loadedJson.get("blackList"), List.class));
                }
                if (loadedJson.has("scale")) {
                    ConfigManager.setScale(loadedJson.get("scale").getAsFloat());
                }
                if (loadedJson.has("textColor")) {
                    ConfigManager.setTextColor(loadedJson.get("textColor").getAsInt());
                }
                if (loadedJson.has("backgroundColor")) {
                    ConfigManager.setBackgroundColor(loadedJson.get("backgroundColor").getAsInt());
                }
                if (loadedJson.has("x")) {
                    ConfigManager.setX(loadedJson.get("x").getAsFloat());
                }
                if (loadedJson.has("y")) {
                    ConfigManager.setY(loadedJson.get("y").getAsFloat());
                }
                if (loadedJson.has("maxListLength")) {
                    ConfigManager.setMaxListLength(loadedJson.get("maxListLength").getAsInt());
                }
                if (loadedJson.has("threshold")) {
                    ConfigManager.setThreshold(loadedJson.get("threshold").getAsInt());
                }
            }
        }
        catch (IOException var1) {
            IOException e = var1;
            e.printStackTrace();
        }
    }

    private static void writeJson() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE.toFile(), StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)configJson, (Appendable)writer);
        }
        catch (IOException var5) {
            IOException e = var5;
            e.printStackTrace();
        }
    }

    public static final class Default {
        public static final boolean showEntitiesCount = true;
        public static final String entityType = "All";
        public static final String listMode = "Blacklist";
        public static final float scale = 10.0f;
        public static final int textColor = -1;
        public static final int backgroundColor = 1065386112;
        public static final float x = 0.01f;
        public static final float y = 0.01f;
        public static final int maxListLength = -1;
        public static final int threshold = -1;
        public static final List<String> whiteList = List.of();
        public static final List<String> blackList = List.of();
    }
}

