/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost.playbacks;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.manager.ParkourGhostManager;
import fr.loudo.parkourGhost.playbacks.PlaybackCountdown;
import fr.loudo.parkourGhost.recordings.RecordingData;
import fr.loudo.parkourGhost.recordings.actions.ActionPlayer;
import fr.loudo.parkourGhost.recordings.actions.MovementData;
import fr.loudo.parkourGhost.recordings.actions.PlayerPoseChange;
import fr.loudo.parkourGhost.utils.GhostPlayer;
import io.github.a5h73y.parkour.Parkour;
import io.github.a5h73y.parkour.type.checkpoint.Checkpoint;
import io.github.a5h73y.parkour.type.course.Course;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Playback {
    private RecordingData recordingData;
    private ServerPlayer serverPlayer;
    private Player player;
    private String courseName;
    private ServerPlayer ghostPlayer;
    private boolean isPlayingBack;
    private int tick;
    private boolean onCountdown;
    private BukkitTask countdownTask;
    private BukkitTask blockPlayerTask;
    private BukkitTask ghostPlayerTask;

    public Playback(RecordingData recordingData, Player player, String courseName) {
        this.recordingData = recordingData;
        this.serverPlayer = ((CraftPlayer)player).getHandle();
        this.player = player;
        this.courseName = courseName;
        this.isPlayingBack = false;
    }

    public boolean start() {
        if (this.isPlayingBack) {
            return false;
        }
        this.isPlayingBack = true;
        if (ParkourGhost.getPlugin().getConfig().getBoolean("playback.countdown")) {
            this.startCountdown();
        } else {
            this.run();
        }
        return true;
    }

    private void createGhostPlayer() {
        GameProfile ghostGameProfile = new GameProfile(UUID.randomUUID(), this.serverPlayer.displayName);
        GameProfile playerProfile = this.serverPlayer.getGameProfile();
        Property textures = (Property)playerProfile.getProperties().get((Object)"textures").iterator().next();
        if (textures != null) {
            ghostGameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", textures.value(), textures.signature()));
        }
        this.ghostPlayer = new GhostPlayer(this.serverPlayer.serverLevel(), ghostGameProfile);
        ServerGamePacketListenerImpl connection = this.serverPlayer.connection;
        boolean seeUsername = ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.see-username");
        boolean ghostPlayerInvisible = ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.invisible");
        Scoreboard scoreboard = new Scoreboard();
        PlayerTeam team = new PlayerTeam(scoreboard, "Ghost");
        team.setCollisionRule(Team.CollisionRule.NEVER);
        if (!seeUsername) {
            team.setNameTagVisibility(Team.Visibility.NEVER);
        }
        if (ghostPlayerInvisible) {
            this.ghostPlayer.setInvisible(true);
            team.setSeeFriendlyInvisibles(true);
        }
        scoreboard.addPlayerToTeam(this.serverPlayer.getDisplayName().getString(), team);
        scoreboard.addPlayerToTeam(this.ghostPlayer.getDisplayName().getString(), team);
        SynchedEntityData dataWatcherGhost = this.ghostPlayer.getEntityData();
        EntityDataAccessor ENTITY_LAYER = new EntityDataAccessor(17, EntityDataSerializers.BYTE);
        dataWatcherGhost.set(ENTITY_LAYER, (Object)127);
        MovementData firstLoc = this.recordingData.getMovementData().getFirst();
        this.ghostPlayer.moveTo(firstLoc.getX(), firstLoc.getY(), firstLoc.getZ());
        connection.send((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, this.ghostPlayer));
        connection.send((Packet)ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)team, (boolean)true));
        this.serverPlayer.serverLevel().addFreshEntity((Entity)this.ghostPlayer);
        if (ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.particles-apparition")) {
            this.serverPlayer.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.CLOUD, false, true, this.ghostPlayer.getX(), this.ghostPlayer.getY(), this.ghostPlayer.getZ(), 0.5f, 1.3f, 0.5f, 0.05f, 50));
        }
    }

    public void run() {
        this.createGhostPlayer();
        this.onCountdown = false;
        this.tick = 0;
        this.ghostPlayerTask = new BukkitRunnable(){

            public void run() {
                ActionPlayer actionPlayer;
                if (Playback.this.tick >= Playback.this.recordingData.getMovementData().size()) {
                    Playback.this.player.sendMessage(String.valueOf(ChatColor.GREEN) + "The " + String.valueOf(ChatColor.YELLOW) + "ghost" + String.valueOf(ChatColor.GREEN) + " finished the parkour.");
                    Playback.this.stop();
                    return;
                }
                MovementData pos = Playback.this.recordingData.getMovementData().get(Playback.this.tick);
                PositionMoveRotation positionMoveRotation = new PositionMoveRotation(new Vec3(pos.getX(), pos.getY(), pos.getZ()), new Vec3(0.0, 0.0, 0.0), pos.getyRot(), pos.getxRot());
                Playback.this.serverPlayer.connection.send((Packet)new ClientboundEntityPositionSyncPacket(Playback.this.ghostPlayer.getId(), positionMoveRotation, false));
                Playback.this.serverPlayer.connection.send((Packet)new ClientboundRotateHeadPacket((Entity)Playback.this.ghostPlayer, pos.getHeadYRot()));
                if (!Playback.this.recordingData.getActionsPlayer().isEmpty() && (actionPlayer = Playback.this.recordingData.getActionsPlayer().get(Playback.this.tick)) != null) {
                    switch (actionPlayer.getActionType()) {
                        case SWING: {
                            Playback.this.ghostPlayer.swing(InteractionHand.MAIN_HAND);
                            break;
                        }
                        case POSE: {
                            Pose pose = ((PlayerPoseChange)actionPlayer).getPose();
                            Playback.this.ghostPlayer.setPose(pose);
                        }
                    }
                }
                ++Playback.this.tick;
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
    }

    private void startCountdown() {
        this.onCountdown = true;
        final PlaybackCountdown playbackCountdown = new PlaybackCountdown(this.player, this);
        final Course course = Parkour.getInstance().getCourseManager().findByName(this.courseName);
        this.countdownTask = new BukkitRunnable(){

            public void run() {
                playbackCountdown.update();
                if (playbackCountdown.getSeconds() < 0) {
                    playbackCountdown.getPlayback().run();
                    ParkourGhostManager.getCurrentPlayerRecording(Playback.this.player).start();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 20L);
        this.blockPlayerTask = new BukkitRunnable(){

            public void run() {
                Playback.this.player.teleport(((Checkpoint)course.getCheckpoints().get(0)).getLocation());
                if (playbackCountdown.getSeconds() < 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
    }

    public boolean stop() {
        if (!this.isPlayingBack) {
            return false;
        }
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
            this.countdownTask = null;
        }
        if (this.blockPlayerTask != null) {
            this.blockPlayerTask.cancel();
            this.blockPlayerTask = null;
        }
        if (this.ghostPlayerTask != null) {
            this.ghostPlayerTask.cancel();
            this.ghostPlayerTask = null;
        }
        if (this.ghostPlayer != null) {
            this.ghostPlayer.remove(Entity.RemovalReason.KILLED);
            this.serverPlayer.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.ghostPlayer.getUUID())));
        }
        this.isPlayingBack = false;
        return true;
    }

    public boolean isOnCountdown() {
        return this.onCountdown;
    }
}

