/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost.playbacks;

import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.playbacks.Playback;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlaybackCountdown {
    private Player player;
    private Playback playback;
    private final Sound COUNTDOWN_SOUND = Sound.BLOCK_NOTE_BLOCK_BANJO;
    private int seconds;
    private ChatColor currentColor;
    private float currentPitch;

    public PlaybackCountdown(Player player, Playback playback) {
        this.player = player;
        this.playback = playback;
        this.seconds = ParkourGhost.getPlugin().getConfig().getInt("playback.start-second");
    }

    public void update() {
        switch (this.seconds) {
            case 3: {
                this.currentPitch = 0.5f;
                this.currentColor = ChatColor.GREEN;
                break;
            }
            case 2: {
                this.currentPitch = 0.6f;
                this.currentColor = ChatColor.YELLOW;
                break;
            }
            case 1: {
                this.currentPitch = 0.9f;
                this.currentColor = ChatColor.RED;
                break;
            }
            default: {
                this.currentPitch = 0.5f;
                this.currentColor = ChatColor.GREEN;
            }
        }
        if (this.seconds == 0) {
            this.player.playSound((Entity)this.player, this.COUNTDOWN_SOUND, 1.0f, 1.0f);
            this.player.sendTitle("", String.valueOf(ChatColor.GREEN) + "GO!", 0, 30, 3);
        } else {
            this.player.playSound((Entity)this.player, this.COUNTDOWN_SOUND, 1.0f, this.currentPitch);
            this.player.sendTitle("", String.valueOf(this.currentColor) + String.valueOf(this.seconds), 0, 30, 0);
        }
        --this.seconds;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public Playback getPlayback() {
        return this.playback;
    }
}

