/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.data.player.PlayerData;
import fr.loudo.parkourGhost.recordings.RecordingData;
import fr.loudo.parkourGhost.recordings.actions.ActionPlayer;
import fr.loudo.parkourGhost.recordings.actions.ActionPlayerDeserliazer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class PlayersDataManager {
    private static final File PLAYERS_FOLDER = new File(ParkourGhost.getPlugin().getDataFolder(), "players");

    public static void folderInit() {
        if (!PLAYERS_FOLDER.exists()) {
            PLAYERS_FOLDER.mkdirs();
        }
    }

    public static void writeRecordingData(RecordingData recordingData, Player player, String courseName) throws IOException {
        PlayerData playerData;
        File playerDataFile = new File(PLAYERS_FOLDER, String.valueOf(player.getUniqueId()) + ".json");
        if (!playerDataFile.exists()) {
            Files.createFile(playerDataFile.toPath(), new FileAttribute[0]);
        }
        Gson gson = new GsonBuilder().create();
        try (FileReader reader = new FileReader(playerDataFile);){
            playerData = (PlayerData)gson.fromJson((Reader)reader, PlayerData.class);
        }
        if (playerData == null) {
            playerData = new PlayerData(player.getDisplayName());
        }
        HashMap<String, RecordingData> recordedRuns = playerData.getRecordedRuns();
        recordedRuns.remove(courseName);
        recordedRuns.put(courseName, recordingData);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(playerDataFile));){
            gson.toJson((Object)playerData, (Appendable)writer);
        }
    }

    public static PlayerData getRecordingData(Player player) throws IOException {
        PlayerData playerData;
        File playerDataFile = new File(PLAYERS_FOLDER, String.valueOf(player.getUniqueId()) + ".json");
        if (!playerDataFile.exists()) {
            return null;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(ActionPlayer.class, (Object)new ActionPlayerDeserliazer()).create();
        try (BufferedReader reader = new BufferedReader(new FileReader(playerDataFile));){
            playerData = (PlayerData)gson.fromJson((Reader)reader, PlayerData.class);
        }
        return playerData;
    }
}

