/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.nms_1_21_R3;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import fr.loudo.nms_1_21_R3.utils.GhostPlayer;
import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.manager.ParkourGhostManager;
import fr.loudo.parkourGhost.nms.PlaybackInterface;
import fr.loudo.parkourGhost.playbacks.PlaybackCountdown;
import fr.loudo.parkourGhost.recordings.RecordingData;
import fr.loudo.parkourGhost.recordings.actions.ActionPlayer;
import fr.loudo.parkourGhost.recordings.actions.MovementData;
import fr.loudo.parkourGhost.utils.ParsePose;
import io.github.a5h73y.parkour.Parkour;
import io.github.a5h73y.parkour.type.checkpoint.Checkpoint;
import io.github.a5h73y.parkour.type.course.Course;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Playback
implements PlaybackInterface {
    private RecordingData recordingData;
    private Player player;
    private EntityPlayer serverPlayer;
    private EntityPlayer ghostPlayer;
    private String courseName;
    private boolean isPlayingBack;
    private int tick;
    private BukkitTask countdownTask;
    private BukkitTask blockPlayerTask;
    private BukkitTask ghostPlayerTask;
    private ScoreboardTeam team;

    public Playback(Player player, RecordingData recordingData, String courseName) {
        this.recordingData = recordingData;
        this.player = player;
        this.serverPlayer = ((CraftPlayer)player).getHandle();
        this.courseName = courseName;
        this.isPlayingBack = false;
    }

    @Override
    public boolean start() {
        if (this.isPlayingBack) {
            return false;
        }
        this.isPlayingBack = true;
        if (ParkourGhost.getPlugin().getConfig().getBoolean("playback.countdown")) {
            this.startCountdown();
        } else {
            this.runPlayback();
        }
        return true;
    }

    private void createGhostPlayer() {
        GameProfile ghostGameProfile = new GameProfile(UUID.randomUUID(), this.serverPlayer.displayName);
        GameProfile playerProfile = this.serverPlayer.gh();
        if (playerProfile.getProperties().containsKey((Object)"textures")) {
            Property textures = (Property)playerProfile.getProperties().get((Object)"textures").iterator().next();
            ghostGameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", textures.value(), textures.signature()));
        }
        this.ghostPlayer = new GhostPlayer(this.serverPlayer.y(), ghostGameProfile);
        PlayerConnection connection = this.serverPlayer.f;
        boolean seeUsername = ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.see-username");
        boolean ghostPlayerInvisible = ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.invisible");
        Scoreboard scoreboard = this.serverPlayer.gy();
        this.team = new ScoreboardTeam(scoreboard, "Ghost");
        this.team.a(ScoreboardTeamBase.EnumTeamPush.b);
        if (!seeUsername) {
            this.team.a(ScoreboardTeamBase.EnumNameTagVisibility.b);
        }
        if (ghostPlayerInvisible) {
            this.ghostPlayer.k(true);
        }
        scoreboard.a(this.serverPlayer.al().getString(), this.team);
        scoreboard.a(this.ghostPlayer.al().getString(), this.team);
        DataWatcher dataWatcherGhost = this.ghostPlayer.au();
        DataWatcherObject ENTITY_LAYER = new DataWatcherObject(17, DataWatcherRegistry.a);
        dataWatcherGhost.a(ENTITY_LAYER, (Object)127);
        connection.b((Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)true));
        MovementData firstLoc = this.recordingData.getMovementData().getFirst();
        this.ghostPlayer.b(firstLoc.getX(), firstLoc.getY(), firstLoc.getZ(), firstLoc.getxRot(), firstLoc.getyRot());
        NamespacedKey isGhostParkourKey = new NamespacedKey((Plugin)ParkourGhost.getPlugin(), "isParkourGhost");
        this.ghostPlayer.getBukkitEntity().getPlayer().getPersistentDataContainer().set(isGhostParkourKey, PersistentDataType.INTEGER, (Object)1);
        this.serverPlayer.f.b((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.a, this.ghostPlayer));
        this.serverPlayer.y().b((Entity)this.ghostPlayer);
    }

    @Override
    public void runPlayback() {
        this.createGhostPlayer();
        this.tick = 0;
        if (ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.particles-apparition")) {
            this.serverPlayer.f.b((Packet)new PacketPlayOutWorldParticles((ParticleParam)Particles.e, false, true, this.ghostPlayer.dA(), this.ghostPlayer.dC(), this.ghostPlayer.dG(), 0.5f, 1.3f, 0.5f, 0.05f, 50));
        }
        this.ghostPlayerTask = new BukkitRunnable(){

            public void run() {
                ActionPlayer actionPlayer;
                if (Playback.this.tick >= Playback.this.recordingData.getMovementData().size()) {
                    Playback.this.player.sendMessage(ParkourGhost.getPlugin().getConfig().getString("messages.ghost_finished_parkour"));
                    Playback.this.stop();
                    return;
                }
                MovementData pos = Playback.this.recordingData.getMovementData().get(Playback.this.tick);
                Playback.this.ghostPlayer.a_(pos.getX(), pos.getY(), pos.getZ());
                Playback.this.ghostPlayer.w(pos.getxRot());
                Playback.this.ghostPlayer.v(pos.getyRot());
                Playback.this.ghostPlayer.q(pos.getyRot());
                if (!Playback.this.recordingData.getActionsPlayer().isEmpty() && (actionPlayer = Playback.this.recordingData.getActionsPlayer().get(Playback.this.tick)) != null) {
                    switch (actionPlayer.getActionType()) {
                        case SWING: {
                            Playback.this.ghostPlayer.a(EnumHand.a);
                            break;
                        }
                        case POSE: {
                            Playback.this.ghostPlayer.b(EntityPose.valueOf((String)ParsePose.parse(actionPlayer)));
                            break;
                        }
                        case HURT: {
                            Playback.this.serverPlayer.f.b((Packet)new PacketPlayOutAnimation((Entity)Playback.this.ghostPlayer, 1));
                        }
                    }
                }
                ++Playback.this.tick;
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
    }

    private void startCountdown() {
        final PlaybackCountdown playbackCountdown = new PlaybackCountdown(this.player, this);
        final Course course = Parkour.getInstance().getCourseManager().findByName(this.courseName);
        this.countdownTask = new BukkitRunnable(){

            public void run() {
                playbackCountdown.update();
                if (playbackCountdown.getSeconds() < 0) {
                    playbackCountdown.getPlayback().runPlayback();
                    ParkourGhostManager.getCurrentPlayerRecording(Playback.this.player).start();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 20L);
        this.blockPlayerTask = new BukkitRunnable(){

            public void run() {
                Playback.this.player.teleport(((Checkpoint)course.getCheckpoints().get(0)).getLocation());
                if (playbackCountdown.getSeconds() < 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
    }

    @Override
    public boolean stop() {
        if (!this.isPlayingBack) {
            return false;
        }
        if (this.blockPlayerTask != null) {
            this.blockPlayerTask.cancel();
            this.blockPlayerTask = null;
        }
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
            this.countdownTask = null;
        }
        if (this.ghostPlayerTask != null) {
            this.ghostPlayerTask.cancel();
            this.ghostPlayerTask = null;
        }
        if (this.ghostPlayer != null) {
            this.ghostPlayer.a(Entity.RemovalReason.a);
            this.serverPlayer.f.b((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.ghostPlayer.cG())));
            this.serverPlayer.f.b((Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team));
        }
        this.isPlayingBack = false;
        return true;
    }
}

