/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost.commands;

import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.manager.ParkourGhostManager;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ParkourGhostCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (Arrays.stream(args).toList().isEmpty()) {
                this.sendHelp(p);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "help": {
                    this.sendHelp(p);
                    break;
                }
                case "reload": {
                    if (p.hasPermission("parkourghost.admin")) {
                        ParkourGhost.getPlugin().reloadConfig();
                        p.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully reloaded ParkourGhost config!");
                        break;
                    }
                    p.sendMessage(ParkourGhost.getPlugin().getConfig().getString("messages.no_ghost"));
                    break;
                }
                case "play": {
                    if (args.length == 1) {
                        p.sendMessage(ParkourGhost.getPlugin().getConfig().getString("messages.not_valid_name"));
                        return true;
                    }
                    if (ParkourGhostManager.joinPlayerParkourAndStartPlayback(p, args[1].toLowerCase())) break;
                    p.sendMessage(ParkourGhost.getPlugin().getConfig().getString("messages.no_ghost"));
                    break;
                }
                default: {
                    this.sendHelp(p);
                }
            }
        }
        return true;
    }

    private void sendHelp(Player p) {
        p.sendMessage(ParkourGhost.getPlugin().getConfig().getString("help_pg_cmd.1"));
        if (p.hasPermission("parkourghost.admin")) {
            p.sendMessage(ParkourGhost.getPlugin().getConfig().getString("help_pg_cmd.2"));
        }
    }
}

