/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost.recordings;

import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.manager.PlayersDataManager;
import fr.loudo.parkourGhost.recordings.RecordingData;
import fr.loudo.parkourGhost.recordings.actions.ActionPlayer;
import fr.loudo.parkourGhost.recordings.actions.ActionType;
import fr.loudo.parkourGhost.recordings.actions.MovementData;
import fr.loudo.parkourGhost.recordings.actions.PlayerPoseChange;
import io.github.a5h73y.parkour.event.ParkourTimeResultEvent;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Recording {
    private String courseName;
    private Player player;
    private RecordingData recordingData;
    private boolean isRecording;
    private int tick;
    private BukkitTask recordTask;

    public Recording(Player player, String courseName) {
        this.courseName = courseName;
        this.player = player;
        this.recordingData = new RecordingData();
    }

    public boolean start() {
        if (this.isRecording) {
            return false;
        }
        this.isRecording = true;
        this.recordingData.getMovementData().clear();
        final AtomicReference<Pose> lastPos = new AtomicReference<Pose>(this.player.getPose());
        this.tick = 0;
        this.recordTask = new BukkitRunnable(){

            public void run() {
                MovementData movementData = MovementData.getMovementDataFromPlayer(Recording.this.player);
                Recording.this.recordingData.getMovementData().add(movementData);
                if (Recording.this.player.getPose() != lastPos.get()) {
                    Recording.this.recordingData.getActionsPlayer().put(Recording.this.tick, new PlayerPoseChange(Recording.this.player.getPose()));
                }
                lastPos.set(Recording.this.player.getPose());
                ++Recording.this.tick;
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
        return true;
    }

    public void addAction(ActionType actionType) {
        this.recordingData.getActionsPlayer().put(this.tick, new ActionPlayer(actionType));
    }

    public boolean stop(ParkourTimeResultEvent event, boolean force) {
        if (!this.isRecording) {
            return false;
        }
        this.recordTask.cancel();
        this.recordTask = null;
        this.isRecording = false;
        if (!force) {
            try {
                if (event.isPlayerRecord() || event.isGlobalRecord()) {
                    this.save();
                    this.player.sendMessage(ParkourGhost.getPlugin().getConfig().getString("messages.new_pb").replace("%course_name%", event.getCourseName()));
                }
            }
            catch (Exception e) {
                this.player.sendMessage(ParkourGhost.getPlugin().getConfig().getString("messages.unexpected_error_save_record"));
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public void save() throws IOException {
        PlayersDataManager.writeRecordingData(this.recordingData, this.player, this.courseName);
    }
}

