/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost.utils;

import fr.loudo.parkourGhost.ParkourGhost;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import org.bukkit.entity.Player;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CheckVersion {
    private static String latestVersion;
    private static boolean newVersionAvailable;

    public static void verify() throws IOException, ParseException {
        ParkourGhost.getPlugin().getLogger().info("Checking for new update...");
        URL url = new URL("https://api.github.com/repos/LOUDO56/ParkourGhost/releases/latest");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.connect();
        int status = conn.getResponseCode();
        if (status != 200) {
            throw new RuntimeException("Github API down, can't check new update.");
        }
        StringBuilder inline = new StringBuilder();
        Scanner scanner = new Scanner(url.openStream());
        while (scanner.hasNext()) {
            inline.append(scanner.nextLine());
        }
        JSONParser parse = new JSONParser();
        JSONObject dataObj = (JSONObject)parse.parse(inline.toString());
        latestVersion = ((String)dataObj.get((Object)"tag_name")).replace("v", "");
        if (!ParkourGhost.getPlugin().getDescription().getVersion().equals(latestVersion)) {
            newVersionAvailable = true;
            ParkourGhost.getPlugin().getLogger().info("New update available: " + latestVersion);
        } else {
            ParkourGhost.getPlugin().getLogger().info("No update available.");
        }
    }

    public static void notifyPlayer(Player player) {
        if (newVersionAvailable) {
            player.sendMessage("[ParkourGhost] \u00a7aParkourGhost has a new update available: \u00a7e" + latestVersion + "\u00a7a. Download it here: \u00a7ehttps://github.com/LOUDO56/ParkourGhost/releases");
        }
    }

    static {
        newVersionAvailable = false;
    }
}

