/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost.manager;

import fr.loudo.parkourGhost.data.player.PlayerData;
import fr.loudo.parkourGhost.manager.PlayersDataManager;
import fr.loudo.parkourGhost.nms.NMSHandler;
import fr.loudo.parkourGhost.nms.PlaybackInterface;
import fr.loudo.parkourGhost.recordings.Recording;
import fr.loudo.parkourGhost.recordings.RecordingData;
import io.github.a5h73y.parkour.Parkour;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class ParkourGhostManager {
    private static final HashMap<Player, Recording> SERVER_PLAYER_RECORDING_HASH_MAP = new HashMap();
    private static final HashMap<Player, PlaybackInterface> SERVER_PLAYER_PLAYBACK_HASH_MAP = new HashMap();

    public static boolean joinPlayerParkour(Player player, String courseName) {
        if (SERVER_PLAYER_RECORDING_HASH_MAP.containsKey(player)) {
            ParkourGhostManager.restartPlayerParkour(player, courseName);
            return false;
        }
        Recording recording = new Recording(player, courseName);
        SERVER_PLAYER_RECORDING_HASH_MAP.put(player, recording);
        if (SERVER_PLAYER_PLAYBACK_HASH_MAP.get(player) == null) {
            recording.start();
        }
        return true;
    }

    public static boolean restartPlayerParkour(Player player, String courseName) {
        if (!SERVER_PLAYER_RECORDING_HASH_MAP.containsKey(player)) {
            return false;
        }
        PlaybackInterface currentPlayback = SERVER_PLAYER_PLAYBACK_HASH_MAP.get(player);
        ParkourGhostManager.stopRecordOrPlayback(player, true);
        if (currentPlayback != null) {
            ParkourGhostManager.startPlaybackOfPlayer(player, courseName);
        }
        ParkourGhostManager.joinPlayerParkour(player, courseName);
        return true;
    }

    public static boolean joinPlayerParkourAndStartPlayback(Player player, String courseName) {
        if (!ParkourGhostManager.startPlaybackOfPlayer(player, courseName)) {
            return false;
        }
        Parkour.getInstance().getPlayerManager().joinCourse(player, courseName);
        player.sendTitle(" ", " ", 0, 0, 0);
        return true;
    }

    public static boolean startPlaybackOfPlayer(Player player, String courseName) {
        PlayerData playerData;
        try {
            playerData = PlayersDataManager.getRecordingData(player);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get player recording data: " + String.valueOf(e));
        }
        if (playerData == null) {
            return false;
        }
        HashMap<String, RecordingData> recordedRuns = playerData.getRecordedRuns();
        if (!recordedRuns.containsKey(courseName)) {
            return false;
        }
        PlaybackInterface currentPlayback = SERVER_PLAYER_PLAYBACK_HASH_MAP.get(player);
        if (currentPlayback != null) {
            currentPlayback.stop();
        }
        PlaybackInterface playback = NMSHandler.getPlaybackInstance(player, recordedRuns.get(courseName), courseName);
        SERVER_PLAYER_PLAYBACK_HASH_MAP.put(player, playback);
        playback.start();
        return true;
    }

    public static void stopRecordOrPlayback(Player player, boolean force) {
        Recording recording;
        PlaybackInterface playback = SERVER_PLAYER_PLAYBACK_HASH_MAP.get(player);
        if (playback != null) {
            playback.stop();
            SERVER_PLAYER_PLAYBACK_HASH_MAP.remove(player, playback);
        }
        if ((recording = SERVER_PLAYER_RECORDING_HASH_MAP.get(player)) != null) {
            recording.stop(force);
            SERVER_PLAYER_RECORDING_HASH_MAP.remove(player, recording);
        }
    }

    public static Recording getCurrentPlayerRecording(Player player) {
        return SERVER_PLAYER_RECORDING_HASH_MAP.get(player);
    }

    public static PlaybackInterface getCurrentPlayerPlayback(Player player) {
        return SERVER_PLAYER_PLAYBACK_HASH_MAP.get(player);
    }
}

