/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost;

import fr.loudo.bukkit.Metrics;
import fr.loudo.parkourGhost.commands.ParkourGhostCommand;
import fr.loudo.parkourGhost.commands.ParkourGhostTabCompleter;
import fr.loudo.parkourGhost.events.JoinEvent;
import fr.loudo.parkourGhost.events.ParkourEvents;
import fr.loudo.parkourGhost.manager.PlayersDataManager;
import fr.loudo.parkourGhost.utils.CheckVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.parser.ParseException;

public final class ParkourGhost
extends JavaPlugin {
    private static ParkourGhost plugin;
    private static String version;

    public void onEnable() {
        plugin = this;
        Plugin parkour = this.getServer().getPluginManager().getPlugin("Parkour");
        if (parkour == null && !parkour.isEnabled()) {
            Bukkit.getLogger().severe("[ParkourGhost] Parkour plugin isn't installed, ParkourGhost is an add-on from this plugin and need to be installed! Install it here: https://www.spigotmc.org/resources/parkour.23685/");
            this.setEnabled(false);
            return;
        }
        this.getCommand("parkourghost").setExecutor((CommandExecutor)new ParkourGhostCommand());
        this.getCommand("parkourghost").setTabCompleter((TabCompleter)new ParkourGhostTabCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new ParkourEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinEvent(), (Plugin)this);
        PlayersDataManager.folderInit();
        this.saveDefaultConfig();
        version = Bukkit.getBukkitVersion();
        String versionDot = version.split("-")[0];
        ArrayList<String> versionsSupported = new ArrayList<String>(Arrays.asList("1.18.2", "1.19.4", "1.20.6", "1.21.4"));
        if (!versionsSupported.contains(versionDot)) {
            Bukkit.getLogger().severe("[ParkourGhost] Your minecraft version isn't supported. ParkourGhost is disabled. If you think this is an error, check that your server is at the latest version, e.g. 1.18 -> 1.18.2");
            this.setEnabled(false);
        }
        if ((version = versionDot.replace(".", "_")).split("_").length > 2) {
            version = version.split("_")[0] + "_" + version.split("_")[1];
        }
        if (this.getConfig().getBoolean("check-version")) {
            try {
                CheckVersion.verify();
            }
            catch (IOException | ParseException e) {
                this.getLogger().info("Couldn't check for a new update, passing.");
            }
        }
        int pluginId = 24993;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
    }

    public void onDisable() {
    }

    public static ParkourGhost getPlugin() {
        return plugin;
    }

    public static String getVersion() {
        return version;
    }
}

