/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.nms_1_18;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import fr.loudo.nms_1_18.utils.GhostPlayer;
import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.manager.ParkourGhostManager;
import fr.loudo.parkourGhost.nms.PlaybackInterface;
import fr.loudo.parkourGhost.playbacks.PlaybackCountdown;
import fr.loudo.parkourGhost.recordings.RecordingData;
import fr.loudo.parkourGhost.recordings.actions.ActionPlayer;
import fr.loudo.parkourGhost.recordings.actions.MovementData;
import fr.loudo.parkourGhost.utils.ParsePose;
import io.github.a5h73y.parkour.Parkour;
import io.github.a5h73y.parkour.type.checkpoint.Checkpoint;
import io.github.a5h73y.parkour.type.course.Course;
import java.util.UUID;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Playback
implements PlaybackInterface {
    private RecordingData recordingData;
    private Player player;
    private EntityPlayer serverPlayer;
    private EntityPlayer ghostPlayer;
    private String courseName;
    private boolean isPlayingBack;
    private int tick;
    private BukkitTask countdownTask;
    private BukkitTask blockPlayerTask;
    private BukkitTask ghostPlayerTask;

    public Playback(Player player, RecordingData recordingData, String courseName) {
        this.recordingData = recordingData;
        this.player = player;
        this.serverPlayer = ((CraftPlayer)player).getHandle();
        this.courseName = courseName;
        this.isPlayingBack = false;
    }

    @Override
    public boolean start() {
        if (this.isPlayingBack) {
            return false;
        }
        this.isPlayingBack = true;
        this.createGhostPlayer();
        if (ParkourGhost.getPlugin().getConfig().getBoolean("playback.countdown")) {
            this.startCountdown();
        } else {
            this.runPlayback();
        }
        return true;
    }

    private void createGhostPlayer() {
        GameProfile ghostGameProfile = new GameProfile(UUID.randomUUID(), this.serverPlayer.displayName);
        GameProfile playerProfile = this.serverPlayer.fq();
        if (playerProfile.getProperties().containsKey((Object)"textures")) {
            Property textures = (Property)playerProfile.getProperties().get((Object)"textures").iterator().next();
            ghostGameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", textures.getValue(), textures.getSignature()));
        }
        this.ghostPlayer = new GhostPlayer(this.serverPlayer.x(), ghostGameProfile);
        boolean seeUsername = ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.see-username");
        boolean ghostPlayerInvisible = ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.invisible");
        Scoreboard scoreboard = new Scoreboard();
        ScoreboardTeam team = new ScoreboardTeam(scoreboard, "Ghost");
        team.a(ScoreboardTeamBase.EnumTeamPush.b);
        if (!seeUsername) {
            team.a(ScoreboardTeamBase.EnumNameTagVisibility.b);
        }
        if (ghostPlayerInvisible) {
            this.ghostPlayer.j(true);
            team.b(true);
        }
        scoreboard.a(this.serverPlayer.C_().getString(), team);
        scoreboard.a(this.ghostPlayer.C_().getString(), team);
        this.serverPlayer.b.a((Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (boolean)true));
        this.serverPlayer.b.a((Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (boolean)true));
        MovementData firstPos = this.recordingData.getMovementData().get(0);
        DataWatcher dataWatcherGhost = this.ghostPlayer.ai();
        DataWatcherObject ENTITY_LAYER = new DataWatcherObject(17, DataWatcherRegistry.a);
        dataWatcherGhost.b(ENTITY_LAYER, (Object)127);
        this.ghostPlayer.b(firstPos.getX(), firstPos.getY(), firstPos.getZ(), firstPos.getxRot(), firstPos.getyRot());
        NamespacedKey isGhostParkourKey = new NamespacedKey((Plugin)ParkourGhost.getPlugin(), "isParkourGhost");
        this.ghostPlayer.getBukkitEntity().getPlayer().getPersistentDataContainer().set(isGhostParkourKey, PersistentDataType.INTEGER, (Object)1);
    }

    @Override
    public void runPlayback() {
        this.serverPlayer.b.a((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{this.ghostPlayer}));
        this.serverPlayer.x().b((Entity)this.ghostPlayer);
        if (ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.particles-apparition")) {
            this.serverPlayer.b.a((Packet)new PacketPlayOutWorldParticles((ParticleParam)Particles.f, true, this.ghostPlayer.dc(), this.ghostPlayer.de(), this.ghostPlayer.di(), 0.5f, 1.3f, 0.5f, 0.05f, 50));
        }
        this.tick = 0;
        this.ghostPlayerTask = new BukkitRunnable(){

            public void run() {
                ActionPlayer actionPlayer;
                if (Playback.this.tick >= Playback.this.recordingData.getMovementData().size()) {
                    Playback.this.player.sendMessage(ChatColor.GREEN + "The " + ChatColor.YELLOW + "ghost" + ChatColor.GREEN + " finished the parkour.");
                    Playback.this.stop();
                    return;
                }
                MovementData pos = Playback.this.recordingData.getMovementData().get(Playback.this.tick);
                Playback.this.ghostPlayer.e(pos.getX(), pos.getY(), pos.getZ());
                Playback.this.ghostPlayer.p(pos.getxRot());
                Playback.this.ghostPlayer.o(pos.getyRot());
                Playback.this.ghostPlayer.l(pos.getyRot());
                if (!Playback.this.recordingData.getActionsPlayer().isEmpty() && (actionPlayer = Playback.this.recordingData.getActionsPlayer().get(Playback.this.tick)) != null) {
                    switch (actionPlayer.getActionType()) {
                        case SWING: {
                            Playback.this.ghostPlayer.a(EnumHand.a);
                            break;
                        }
                        case POSE: {
                            Playback.this.ghostPlayer.b(EntityPose.valueOf((String)ParsePose.parse(actionPlayer)));
                            break;
                        }
                        case HURT: {
                            ((Playback)Playback.this).serverPlayer.b.a((Packet)new PacketPlayOutAnimation((Entity)Playback.this.ghostPlayer, 1));
                        }
                    }
                }
                Playback.this.tick++;
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
    }

    private void startCountdown() {
        final PlaybackCountdown playbackCountdown = new PlaybackCountdown(this.player, this);
        final Course course = Parkour.getInstance().getCourseManager().findByName(this.courseName);
        this.countdownTask = new BukkitRunnable(){

            public void run() {
                playbackCountdown.update();
                if (playbackCountdown.getSeconds() < 0) {
                    playbackCountdown.getPlayback().runPlayback();
                    ParkourGhostManager.getCurrentPlayerRecording(Playback.this.player).start();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 20L);
        this.blockPlayerTask = new BukkitRunnable(){

            public void run() {
                Playback.this.player.teleport(((Checkpoint)course.getCheckpoints().get(0)).getLocation());
                if (playbackCountdown.getSeconds() < 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
    }

    @Override
    public boolean stop() {
        if (!this.isPlayingBack) {
            return false;
        }
        if (this.blockPlayerTask != null) {
            this.blockPlayerTask.cancel();
            this.blockPlayerTask = null;
        }
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
            this.countdownTask = null;
        }
        if (this.ghostPlayerTask != null) {
            this.ghostPlayerTask.cancel();
            this.ghostPlayerTask = null;
        }
        if (this.ghostPlayer != null) {
            this.ghostPlayer.a(Entity.RemovalReason.a);
            this.serverPlayer.b.a((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[]{this.ghostPlayer}));
            this.serverPlayer.b.a((Packet)new PacketPlayOutEntityDestroy(new int[]{this.ghostPlayer.ae()}));
        }
        this.isPlayingBack = false;
        return true;
    }
}

