/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.nms_1_20;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import fr.loudo.nms_1_20.utils.GhostPlayer;
import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.manager.ParkourGhostManager;
import fr.loudo.parkourGhost.nms.PlaybackInterface;
import fr.loudo.parkourGhost.playbacks.PlaybackCountdown;
import fr.loudo.parkourGhost.recordings.RecordingData;
import fr.loudo.parkourGhost.recordings.actions.ActionPlayer;
import fr.loudo.parkourGhost.recordings.actions.MovementData;
import fr.loudo.parkourGhost.utils.ParsePose;
import io.github.a5h73y.parkour.Parkour;
import io.github.a5h73y.parkour.type.checkpoint.Checkpoint;
import io.github.a5h73y.parkour.type.course.Course;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Playback
implements PlaybackInterface {
    private RecordingData recordingData;
    private Player player;
    private ServerPlayer serverPlayer;
    private ServerPlayer ghostPlayer;
    private String courseName;
    private boolean isPlayingBack;
    private int tick;
    private BukkitTask countdownTask;
    private BukkitTask blockPlayerTask;
    private BukkitTask ghostPlayerTask;

    public Playback(Player player, RecordingData recordingData, String courseName) {
        this.recordingData = recordingData;
        this.player = player;
        this.serverPlayer = ((CraftPlayer)player).getHandle();
        this.courseName = courseName;
        this.isPlayingBack = false;
    }

    @Override
    public boolean start() {
        if (this.isPlayingBack) {
            return false;
        }
        this.isPlayingBack = true;
        this.createGhostPlayer();
        if (ParkourGhost.getPlugin().getConfig().getBoolean("playback.countdown")) {
            this.startCountdown();
        } else {
            this.runPlayback();
        }
        return true;
    }

    private void createGhostPlayer() {
        GameProfile ghostGameProfile = new GameProfile(UUID.randomUUID(), this.serverPlayer.displayName);
        GameProfile playerProfile = this.serverPlayer.getGameProfile();
        if (playerProfile.getProperties().containsKey((Object)"textures")) {
            Property textures = (Property)playerProfile.getProperties().get((Object)"textures").iterator().next();
            ghostGameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", textures.value(), textures.signature()));
        }
        this.ghostPlayer = new GhostPlayer(this.serverPlayer.serverLevel(), ghostGameProfile);
        boolean seeUsername = ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.see-username");
        boolean ghostPlayerInvisible = ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.invisible");
        Scoreboard scoreboard = new Scoreboard();
        PlayerTeam team = new PlayerTeam(scoreboard, "Ghost");
        team.setCollisionRule(Team.CollisionRule.NEVER);
        if (!seeUsername) {
            team.setNameTagVisibility(Team.Visibility.NEVER);
        }
        if (ghostPlayerInvisible) {
            this.ghostPlayer.setInvisible(true);
            team.setSeeFriendlyInvisibles(true);
        }
        scoreboard.addPlayerToTeam(this.serverPlayer.getDisplayName().getString(), team);
        scoreboard.addPlayerToTeam(this.ghostPlayer.getDisplayName().getString(), team);
        this.serverPlayer.connection.send((Packet)ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)team, (boolean)true));
        MovementData firstPos = this.recordingData.getMovementData().get(0);
        SynchedEntityData dataWatcherGhost = this.ghostPlayer.getEntityData();
        EntityDataAccessor ENTITY_LAYER = new EntityDataAccessor(17, EntityDataSerializers.BYTE);
        dataWatcherGhost.set(ENTITY_LAYER, (Object)127);
        this.ghostPlayer.moveTo(firstPos.getX(), firstPos.getY(), firstPos.getZ(), firstPos.getxRot(), firstPos.getyRot());
        NamespacedKey isGhostParkourKey = new NamespacedKey((Plugin)ParkourGhost.getPlugin(), "isParkourGhost");
        this.ghostPlayer.getBukkitEntity().getPlayer().getPersistentDataContainer().set(isGhostParkourKey, PersistentDataType.INTEGER, (Object)1);
    }

    @Override
    public void runPlayback() {
        this.serverPlayer.connection.send((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, this.ghostPlayer));
        this.serverPlayer.serverLevel().addFreshEntity((Entity)this.ghostPlayer);
        if (ParkourGhost.getPlugin().getConfig().getBoolean("ghostplayer.particles-apparition")) {
            this.serverPlayer.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.CLOUD, true, this.ghostPlayer.getX(), this.ghostPlayer.getY(), this.ghostPlayer.getZ(), 0.5f, 1.3f, 0.5f, 0.05f, 50));
        }
        this.tick = 0;
        this.ghostPlayerTask = new BukkitRunnable(){

            public void run() {
                ActionPlayer actionPlayer;
                if (Playback.this.tick >= Playback.this.recordingData.getMovementData().size()) {
                    Playback.this.player.sendMessage(ChatColor.GREEN + "The " + ChatColor.YELLOW + "ghost" + ChatColor.GREEN + " finished the parkour.");
                    Playback.this.stop();
                    return;
                }
                MovementData pos = Playback.this.recordingData.getMovementData().get(Playback.this.tick);
                Playback.this.ghostPlayer.setPos(pos.getX(), pos.getY(), pos.getZ());
                Playback.this.ghostPlayer.setXRot(pos.getxRot());
                Playback.this.ghostPlayer.setYRot(pos.getyRot());
                Playback.this.ghostPlayer.setYHeadRot(pos.getyRot());
                if (!Playback.this.recordingData.getActionsPlayer().isEmpty() && (actionPlayer = Playback.this.recordingData.getActionsPlayer().get(Playback.this.tick)) != null) {
                    switch (actionPlayer.getActionType()) {
                        case SWING: {
                            Playback.this.ghostPlayer.swing(InteractionHand.MAIN_HAND);
                            break;
                        }
                        case POSE: {
                            Playback.this.ghostPlayer.setPose(Pose.valueOf((String)ParsePose.parse(actionPlayer)));
                            break;
                        }
                        case HURT: {
                            ((Playback)Playback.this).serverPlayer.connection.send((Packet)new ClientboundAnimatePacket((Entity)Playback.this.ghostPlayer, 1));
                        }
                    }
                }
                Playback.this.tick++;
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
    }

    private void startCountdown() {
        final PlaybackCountdown playbackCountdown = new PlaybackCountdown(this.player, this);
        final Course course = Parkour.getInstance().getCourseManager().findByName(this.courseName);
        this.countdownTask = new BukkitRunnable(){

            public void run() {
                playbackCountdown.update();
                if (playbackCountdown.getSeconds() < 0) {
                    playbackCountdown.getPlayback().runPlayback();
                    ParkourGhostManager.getCurrentPlayerRecording(Playback.this.player).start();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 20L);
        this.blockPlayerTask = new BukkitRunnable(){

            public void run() {
                Playback.this.player.teleport(((Checkpoint)course.getCheckpoints().get(0)).getLocation());
                if (playbackCountdown.getSeconds() < 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
    }

    @Override
    public boolean stop() {
        if (!this.isPlayingBack) {
            return false;
        }
        if (this.blockPlayerTask != null) {
            this.blockPlayerTask.cancel();
            this.blockPlayerTask = null;
        }
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
            this.countdownTask = null;
        }
        if (this.ghostPlayerTask != null) {
            this.ghostPlayerTask.cancel();
            this.ghostPlayerTask = null;
        }
        if (this.ghostPlayer != null) {
            this.ghostPlayer.remove(Entity.RemovalReason.KILLED);
            this.serverPlayer.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(Collections.singletonList(this.ghostPlayer.getUUID())));
            this.serverPlayer.connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.ghostPlayer.getId()}));
        }
        this.isPlayingBack = false;
        return true;
    }
}

